<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\UsersController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [Controller::class, 'home']);

Route::get('app-kayu', [\Rap2hpoutre\LaravelLogViewer\LogViewerController::class, 'index']);
Route::get('mpone-log', [Controller::class, 'logMpone']);
Route::get('mpone-log/trigger', [Controller::class, 'logMponeTrigger']);
Route::get('mpone-log/decline', [Controller::class, 'logMponeDecline']);

Route::group(['prefix' => 'account'], function () {
    Route::get('confirmation/{code}', [UsersController::class, 'confirmation']);
    Route::get('reset/{code}', [AuthController::class, 'resetPassword']);
});
