<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use App\Repository\TelemedicineManager;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\AppDeviceController;
use App\Http\Controllers\ExternalController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Blog\BlogController;
use App\Http\Controllers\Claim\ClaimController;
use App\Http\Controllers\Ecard\EcardController;
use App\Http\Controllers\Claim\ClaimDevController;
use App\Http\Controllers\Contact\ContactController;
use App\Http\Controllers\Web\Auth\AuthWebController;
use App\Http\Controllers\BukuSaku\BukuSakuController;
use App\Http\Controllers\Provider\ProviderController;
use App\Http\Controllers\Promotion\PromotionController;
use App\Http\Controllers\Notifikasi\NotifikasiController;
use App\Http\Controllers\Telemedicine\TelemedicineController;
use App\Http\Controllers\Reimbursement\ReimbursementController;
use App\Http\Controllers\HospitalPortal\HospitalPortalController;
use App\Http\Controllers\Payment\PaymentController;
use App\Http\Controllers\Telemedicine\DokterController;
use App\Http\Controllers\Web\Telemedicine\TelemedicineWebController;
use App\Http\Controllers\Telemedicine\WhatsappController;
use App\Http\Controllers\Web\UsersWebController;
use App\Http\Controllers\Web\Notifikasi\NotifikasiWebController;
use App\Http\Controllers\Web\Telemedicine\DashboardController;
use App\Http\Controllers\Web\Telemedicine\DokterWebController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/', [Controller::class, 'home']);

// for telmed
Route::get('web/guest/detail', [TelemedicineWebController::class, 'meetAppointment']);

// for dev purpose
Route::get('getsig', [Controller::class, 'generateSignature']);
Route::get('serve_img', [Controller::class, 'serveImg']);
Route::post('upload', [Controller::class, 'uploadTest']);

Route::post('notify/test_firebase', [NotifikasiController::class, 'test_firebase']);
Route::post('notify', [NotifikasiController::class, 'notifyStatus']);
Route::post('telmed/appointment', [TelemedicineController::class, 'telmedMpone']);
Route::post('telmed/appointment/cancel', [TelemedicineController::class, 'telmedCancel']);
Route::get('dokter/schedule', [TelemedicineController::class, 'listScheduleDokter']);
Route::get('telmed/schedule', [TelemedicineController::class, 'listTimeByDokterDateMPone']);
Route::get('telmed/schedule-doctor', [TelemedicineController::class, 'listDokterByDateMPone']);
Route::post('telmed/appointment/reschedule', [TelemedicineController::class, 'rescheduleMpone']);

// external
Route::any('external/faspay', [ExternalController::class, 'fastpayHook']);
Route::any('external/jitsi', [ExternalController::class, 'jitsiHook']);
Route::post('payment/notify', [PaymentController::class, 'notify']);

// **Registrasi*/
Route::post('registration', [UsersController::class, 'create']);

Route::post('app/set_device', [AppDeviceController::class, 'set_device']);
Route::get('app/get_version', [AppDeviceController::class, 'get_version']);

Route::group(['prefix' => 'auth'], function () {
    Route::post('login', [AuthController::class, 'login']);
    Route::post('login-dev', [AuthController::class, 'loginDev']);
    Route::post('logout', [AuthController::class, 'logout']);
    Route::post('refresh', [AuthController::class, 'refresh']);
    Route::post('password/forgot', [AuthController::class, 'forgot']);
    Route::post('forgot/{code}', [AuthController::class, 'resetPasswordPost']);
    Route::post('check', [AuthController::class, 'check']);

});
Route::group(['middleware' => ['jwtApi.auth']], function () {
    Route::post('auth/password/change', [AuthController::class, 'changePassword']);
});
//**User */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'profile'], function () {
    Route::get('/', [UsersController::class, 'profile']);
    Route::get('/me', [UsersController::class, 'list']);
    Route::get('/profile', [AuthController::class, 'getProfile']);
    Route::put('/', [UsersController::class, 'update']);
    Route::put('member', [UsersController::class, 'membershipVerification']);
    Route::post('photo', [UsersController::class, 'photo']);
    Route::post('set_token', [UsersController::class, 'set_token']);
    Route::post('unset_token', [UsersController::class, 'unset_token']);
    Route::post('unset_user', [UsersController::class, 'unset_user']);
    Route::post('resend_email', [UsersController::class, 'reSendEmailConfirmation']);
    Route::post('reset_member', [UsersController::class, 'resetMembership']);

    Route::get('family', [UsersController::class, 'getMember']);
    Route::post('family', [UsersController::class, 'switchMember']);
});
//**Provider */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'provider'], function () {
    Route::get('/', [ProviderController::class, 'getNearbyProvider']);
});
//**Claim */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'claim'], function () {
    Route::get('/', [ClaimController::class, 'claim']);
    Route::get('/history', [ClaimController::class, 'claimHistory']);
    Route::get('/admisionDate', [ClaimController::class, 'getAdmisionDate']);
    Route::get('/detail', [ClaimController::class, 'detailClaim']);
    Route::get('/benefit', [ClaimController::class, 'claimBenefit']);
});
//**Claim Dev */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'claim-dev'], function () {
    Route::get('/', [ClaimDevController::class, 'claim']);
    Route::get('/history', [ClaimDevController::class, 'claimHistory']);
    Route::get('/detail', [ClaimDevController::class, 'detailClaim']);
    Route::get('/benefit', [ClaimDevController::class, 'claimBenefit']);
});
//**Contact */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'contact'], function () {
    Route::get('/', [ContactController::class, 'getContact']);
});
//**Blog */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'blog'], function () {
    Route::get('promo', [BlogController::class, 'banner']);
    Route::get('/', [BlogController::class, 'blog']);
    Route::get('/category', [BlogController::class, 'blogCategory']);
    Route::get('/banner', [BlogController::class, 'banner']);
});
//**Ecard */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'ecard'], function () {
    Route::post('/', [EcardController::class, 'eCard']);
    // Route::post('/download', [EcardController::class, 'downloadEcard']);
    Route::get('/list', [EcardController::class, 'listEcard']);
});
//**Hospital Portal */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'hospital'], function () {
    Route::post('/', [HospitalPortalController::class, 'hospitalPortal']);
    Route::get('/portal', [HospitalPortalController::class, 'list']);
    Route::get('/claim_type', [HospitalPortalController::class, 'getClaimType']);
    Route::get('/detail', [HospitalPortalController::class, 'detailAppointment']);
});
//**Reimbursment */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'reimbursement'], function () {
    Route::post('/', [ReimbursementController::class, 'reimbursement']);
    Route::post('/reupload', [ReimbursementController::class, 'reUploadReimbursment']);
    Route::get('/', [ReimbursementController::class, 'list']);
    Route::get('/detail', [ReimbursementController::class, 'detail']);
});
//**Notifikasi */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'notify'], function () {
    Route::get('/list', [NotifikasiController::class, 'list']);
    Route::post('/read', [NotifikasiController::class, 'status']);
    Route::get('/count', [NotifikasiController::class, 'count']);
});
//**Buku Saku */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'buku-saku'], function () {
    Route::post('/', [BukuSakuController::class, 'getBukuSakuMpOne']);
});
//**Promotion */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'promotion'], function () {
    Route::get('/', [PromotionController::class, 'getVoucher']);
    Route::get('/detail', [PromotionController::class, 'getPromotionDetail']);
    Route::get('/myvoucher', [PromotionController::class, 'myVoucher']);
    Route::post('/claim', [PromotionController::class, 'claimVoucher']);
    Route::post('/redeem', [PromotionController::class, 'redeemVoucher']);
    Route::get('/pay_method', [PromotionController::class, 'paymentMethod']);
});
//**Telemedicine */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'telmed'], function () {
    Route::post('/member', [TelemedicineController::class, 'appointmentMember']);
    Route::post('/retail', [TelemedicineController::class, 'appointmentRetail']);
    Route::get('/get_member', [TelemedicineController::class, 'getMember']);
    Route::get('/list', [TelemedicineController::class, 'listApointment']);
    Route::get('/detail', [TelemedicineController::class, 'detailApointment']);
    Route::post('/reschedule', [TelemedicineController::class, 'rescheduleTelmed']);
    Route::post('/refund', [TelemedicineController::class, 'refundTelmed']);
    Route::post('/redeemMedicine', [TelemedicineController::class, 'redeemMedicine']);
    // Dokter
    Route::group(['prefix' => 'dokter'], function () {
        Route::get('/specialist', [DokterController::class, 'listSpecialist']); 
        Route::get('/list', [DokterController::class, 'listDokter']); 
        Route::get('/listSchedule', [DokterController::class, 'listScheduleDokter']); 
        Route::get('/listScheduleDay', [DokterController::class, 'listdayDokter']); 
        Route::get('/listScheduleHoliday', [DokterController::class, 'listScheduleDokterHoliday']); 

        Route::get('/listDate', [DokterController::class, 'listDateByDokter']); 
        Route::get('/listDateTime', [DokterController::class, 'listTimeByDokterDate']); 
    });
    //**Report  */
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'report'], function () {
        Route::post('gl', [TelemedicineController::class, 'getGLReport']);
        Route::post('obat', [TelemedicineController::class, 'getObatReport']);
        Route::post('invoice', [TelemedicineController::class, 'getInvoiceReport']);
        Route::post('mr', [TelemedicineController::class, 'getMrReport']);
    });
});
//**Whatsapp */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'whatsapp'], function () {
    Route::get('/status', [WhatsappController::class, 'status']);
    Route::post('/request', [WhatsappController::class, 'request']);
    Route::post('/resend', [WhatsappController::class, 'resend']);
    Route::post('/submit', [WhatsappController::class, 'submit']);
});
//**Payment */
Route::group(['middleware' => ['jwtApi.auth'],'prefix' => 'payment'], function () {
    Route::post('/postData', [PaymentController::class, 'postData']);
    Route::post('/postData/retail', [PaymentController::class, 'postDataRetail']);
    Route::get('/channel/list', [PaymentController::class, 'getPaymentChannelList']);
    Route::get('/instructions', [PaymentController::class, 'getInstruction']);
});
// **Web */
Route::group(['prefix' => 'web'], function () {
    Route::group(['prefix' => 'auth'], function () {
        Route::group(['middleware' => ['jwtApi.auth:web_users']], function () {
            Route::post('password/change', [AuthWebController::class, 'changePassword']);
            Route::get('/profile', [AuthWebController::class, 'getProfile']);
            Route::post('/profile', [AuthWebController::class, 'updatePhoto']);
        });
        Route::post('login', [AuthWebController::class, 'login']);
        Route::post('logout', [AuthWebController::class, 'logout']);
        Route::post('refresh', [AuthWebController::class, 'refresh']);
        Route::post('password/forgot', [AuthWebController::class, 'forgot']);
        Route::post('reset', [AuthWebController::class, 'resetPasswordPost']);
        Route::post('checksession', [AuthWebController::class, 'checkSession']);
    });
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'dashboard'], function () {
        Route::get('overview', [DashboardController::class, 'overview']);
        Route::get('waiting', [DashboardController::class, 'waiting']);
        Route::get('finish', [DashboardController::class, 'finish']);
        Route::get('today', [DashboardController::class, 'today']);
        Route::get('schedule', [DashboardController::class, 'schedule']);
    });
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'appointment'], function () {
        Route::get('list', [TelemedicineWebController::class, 'listAppointment']);
        Route::get('export', [TelemedicineWebController::class, 'exportAppointment']);
        Route::get('detail', [TelemedicineWebController::class, 'detailAppointment']);
        Route::post('approval', [TelemedicineWebController::class, 'approval']);
        Route::post('addResult', [TelemedicineWebController::class, 'addResult']);
        Route::post('editResult', [TelemedicineWebController::class, 'editResult']);
        Route::post('deleteAttachment', [TelemedicineWebController::class, 'deleteAttachment']);
        Route::post('setDone', [TelemedicineWebController::class, 'setDone']);
        Route::post('reschedule', [TelemedicineWebController::class, 'rescheduleTelmed']);
        Route::post('check/status', [TelemedicineWebController::class, 'checkStatus']);
    });
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'dokter'], function () {
        Route::get('listSchedule', [DokterWebController::class, 'listScheduleDokter']);
        Route::get('schedule/appointment', [DokterWebController::class, 'scheduleAppointment']);
        Route::get('schedule/appointment/dokter', [DokterWebController::class, 'dokterAppointment']);
        Route::get('list', [DokterWebController::class, 'listDokter']);
        Route::get('detail', [DokterWebController::class, 'detailDokter']);
        Route::post('addSchedule', [DokterWebController::class, 'addSchedule']);
        Route::post('addScheduleHoliday', [DokterWebController::class, 'addScheduleHoliday']);
        Route::post('updateScheduleHoliday', [DokterWebController::class, 'updateScheduleHoliday']);
        Route::post('deleteScheduleHoliday', [DokterWebController::class, 'deleteScheduleHoliday']);
        Route::post('deleteScheduleDokter', [DokterWebController::class, 'deleteScheduleDokter']);
        Route::get('listScheduleHoliday', [DokterWebController::class, 'listScheduleDokterHoliday']);
        Route::post('updateSchedule', [DokterWebController::class, 'updateSchedule']);
        Route::post('sync', [DokterWebController::class, 'syncDataDokter']);
        Route::post('updateStatus', [DokterWebController::class, 'status']);
        Route::post('create', [DokterWebController::class, 'create']);
        Route::post('update', [DokterWebController::class, 'update']);
    });

    //**Notifikasi */
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'notify'], function () {
        Route::get('/list', [NotifikasiWebController::class, 'list']);
        Route::post('/read', [NotifikasiWebController::class, 'status']);
        Route::get('/count', [NotifikasiWebController::class, 'count']);
    });
    //**Obat */
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'obat'], function () {
        Route::post('list', [TelemedicineWebController::class, 'listObat']);
    });
    //**Plan */
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'plan'], function () {
        Route::get('list', [TelemedicineWebController::class, 'listPlan']);
    });
    //**Apotek */
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'apotek'], function () {
        Route::get('list', [TelemedicineWebController::class, 'listApotek']);
    });
    //**Icd 10 */
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'icd'], function () {
        Route::get('list', [TelemedicineWebController::class, 'listIcd']);
    });
    //**Manage user*/
    Route::group(['middleware' => ['jwtApi.auth:web_users'],'prefix' => 'user'], function () {
        Route::get('list', [UsersWebController::class, 'listUsers']);
        Route::post('create', [UsersWebController::class, 'create']);
        Route::post('update', [UsersWebController::class, 'update']);
        Route::get('detail', [UsersWebController::class, 'detail']);
        Route::post('updateStatus', [UsersWebController::class, 'status']);
        Route::post('updateRole', [UsersWebController::class, 'updateRole']);
        Route::post('changePassword', [UsersWebController::class, 'changePasswordUser']);
        Route::get('roleCaption', [UsersWebController::class, 'roleCaption']);
    });

});
