<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Reset Password</title>
        <link rel="icon" href="{{asset('img/icon.png')}}">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

        <style>
           #box {
                background: rgba(255, 255, 255, 0.877);
                border-bottom-left-radius: 25px;
                border-bottom-right-radius: 25px;
                border-top-left-radius: 25px;
                border-top-right-radius: 25px;
                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.4);
                display: -webkit-flexbox;
                display: -ms-flexbox;
                display: -webkit-flex;
                display: flex;
                -webkit-flex-align: center;
                -ms-flex-align: center;
                -webkit-align-items: center;
                align-items: center;
                justify-content: center;
            }
            body {
                font-family: "Nunito Sans", sans-serif;
                font-size: 0.7rem;
            }
            .container1 {
                    position: fixed;
                    padding-top: 5%;
                    height: 100%;
                    width: 100%;
                    background-repeat: repeat;
                    background-size: 60%;
                    & > .row {
                        height: 100%;
                    }
            } 
        </style>
    </head>
    <body>
        <div class="container1" style="background-color: #0987d0;">
            <div class="row align-items-center justify-content-center">
                <div class="col-10 col-md-4 col-xxl-3">
                    <div class="row align-items-center" id="box"">
                        <img src="{{asset('img/logo.png')}}" style="width:150px; height:40px">
                        @if (!!$is_found) 
                        <form method='post' action={{url('api/auth/forgot/'.$code.'')}} class=" mb-4" v-if="!isSuccess">
                            <div class="loader" v-if='isLoad'>
                                <spin-loader></spin-loader>
                            </div>
                            <div class="form-box" v-if='!isLoad'>
                                <h3 class="sign-in mb-4">Reset Password</h3>
                                <div class="form-group mb-4">
                                    <input type="password" name="password" class="form-control" id="password" placeholder="Password">
                                </div>
                                <div class="form-group mb-4">
                                    <input type="hidden" name="code" class="form-control" id="code" placeholder="code">
                                </div>
                                <div class="form-group mb-4">
                                    <input type="password" name="password_confirmation" class="form-control" id="password_confirmation" placeholder="Password Confirmation">
                                </div>
                                <div class="form-group mb-2">
                                    <p class="sub-title-login">Masukkan password baru anda.</p>
                                </div>
                            </div>
                            @if (!$status) 
                            <div class="form-group alert-login">
                                <p class="text-danger login-message mx-auto">{{ $message }}</p>
                            </div>
                            @endif
                            @if ($status)
                            <div class="form-group alert-login" v-if='status'>
                                <p class="text-success login-message mx-auto">{{ $message }}</p>
                            </div>
                            @endif
                            <div class="form-group button-login-box">
                                <button type="submit" class="btn btn-primary mt-2" >Reset</button>
                            </div>
                        </form>
                        @elseif (isset($is_success))
                            <h5 class="text-center mb-4 mt-4" >Reset Password Success. Silahkan login kembali</h5>
                        @else
                            <h5 class="text-center mb-4 mt-4" >Link expired.</h5>       
                        @endif
                    </div>
                </div>
            
            </div>
        </div>
    </body>
</html>