<html>

<head>
    <title>Medika Plaza - {{$data['subject']}}</title>
    <style type="text/css">
        .box {
            position: relative;
            width: 100%;
        }

        .inner-box {
            margin-left: auto;
            margin-right: auto;
            width: 100%;
            max-width: 600px;
        }

        .inner-box table {
            width: 100%;
        }
        .td-table {
            font-weight: normal;
            padding: 16px
        }
        .detail {
            font-size:12px;
            font-weight:normal;
            text-align: left;
            line-height:12px;
            margin:0;
        }
        .detail.detail-trx {
            font-weight:bold;
            text-align: left;
        }
        table {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;  
        }
        th {
            text-align: left;
            border-bottom: 1px solid #dddddd;
            padding: 8px;
            font-weight:bold;
            background-color: #E3E3E3;
        }
        
        td.detail, table.detail {
        border-bottom: 1px solid #dddddd;
        padding: 8px;
        }
        @media only screen and (max-width: 640px) {

        }
    </style>
</head>

<body>
    <div class="box">
        <div class="inner-box">
            <table>
                <tbody>
                    <tr>
                        <td align="center" valign="top" style="font-weight:normal">
                            <div style="border-radius:4px;overflow:hidden">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%"
                                    style="background-color:#fff;border-collapse:collapse!important">
                                    <tbody>
                                        <tr>
                                            <td valign="top"
                                                style="color:#434343;font-family:sans-serif;font-size:14px;font-weight:normal;line-height:150%;padding:24px 16px;padding-bottom:0!important;padding-left:0!important;padding-right:0!important;padding-top:0!important;text-align:left">
                                                <table border="0" cellpadding="0" cellspacing="0" width="100%"
                                                    style="border-collapse:collapse!important">
                                                    <tbody>
                                                        <tr>
                                                                <td class="td-table">
                                                                    <p
                                                                        style="font-size:16px;color:#134F7C;font-weight:normal;line-height:24px;margin:0;margin-bottom:8px!important">
                                                                        <b>{{$data['subject']}}</b>
                                                                    </p>
                                                                    <p
                                                                        style="color:#5E6C84;display:block;font-family:sans-serif;font-size:14px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:24px;margin:0;text-align:left">
                                                                        Dear {{$data['cust_name']}},
                                                                    </p>
                                                                    <p style="color:#5E6C84;display:block;padding-top:8px;font-family:sans-serif;font-size:14px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                        Thank you for using our telemedicine system to get the medical care you need. We would like to inform you that your appointment with doctor`s {{$data['dokter_name']}} has been completed.
                                                                    </p>
                                                                    <p style="color:#5E6C84;display:block;padding-top:8px;font-family:sans-serif;font-size:14px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                        Please find below your medical history and digital prescriptions.
                                                                    </p>
                                                                </td>
                                                            </tr>
                                                        @if(!empty($data['soap']))
                                                        <tr>
                                                            <td style="font-weight:normal;padding-left:50px;padding-right:50px;padding-bottom:8px!important;padding-top:8px!important">
                                                                <table>
                                                                    <th colspan="2">Medical History</th>
                                                                    <tr>
                                                                        <td class="detail">Subjektif Anamnesia</td>
                                                                        <td class="detail detail-trx">{{$data['soap']['subjektif']}}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="detail">Objektif</td>
                                                                        <td class="detail detail-trx">{{$data['soap']['objektif']}}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="detail">Assessment</td>
                                                                        <td class="detail detail-trx">{{$data['soap']['assessment']}}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="detail">Plan</td>
                                                                        <td class="detail detail-trx">{{$data['soap']['plan']}}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="detail">Alergy</td>
                                                                        <td class="detail detail-trx">{{$data['soap']['alergi']}}</td>
                                                                    </tr>
                                                                    </table>
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        @if(!empty($data['icd10']))
                                                        <tr>
                                                            <td style="font-weight:normal;padding-left:50px;padding-right:50px;padding-bottom:8px!important;padding-top:8px!important">
                                                                <table>
                                                                    <th colspan="3">Examination</th>
                                                                    <tr>
                                                                        <td class="detail" style="font-weight: bold;text-align:center">ICD-10</td>
                                                                        <td class="detail" style="font-weight: bold;text-align:center">Case Type</td>
                                                                        <td class="detail" style="font-weight: bold;text-align:center">Diagnostic Type</td>
                                                                    </tr>
                                                                    @foreach ($data['icd10'] as $item)
                                                                        <tr>
                                                                            <td class="detail" style="text-align:center">{{$item['icd10_name']}}</td>
                                                                            <td class="detail" style="text-align:center">{{$item['case_type']}}</td>
                                                                            <td class="detail" style="text-align:center">{{$item['diagnostic_type']}}</td>
                                                                        </tr>
                                                                    @endforeach
                                                                    </table>
                                                            </td>
                                                        </tr>
                                                        @endif
                                                        <tr>
                                                            <td class="td-table">
                                                                <p style="color:#5E6C84;display:block;padding-top:8px;font-family:sans-serif;font-size:14px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                    We remind you to always consult your doctor if you experience any side effects or problems in using the medication.
                                                                </p>
                                                                <p style="color:#5E6C84;display:block;padding-top:8px;font-family:sans-serif;font-size:14px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                    We hope you recover quickly and feel better soon. Please feel free to contact us with any questions or problems in accessing the telemedicine system or arranging your next appointment.
                                                                </p>
                                                                <p style="color:#5E6C84;display:block;padding-top:8px;font-family:sans-serif;font-size:14px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                    Thank you for your trust in our telemedicine system and we look forward to providing the best service for you.
                                                                </p>
                                                                <p style="color:#5E6C84;display:block;padding-top:10px;font-family:sans-serif;font-size:12px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                    Best regards,
                                                                </p>
                                                                <p style="color:#5E6C84;display:block;padding-top:10px;font-family:sans-serif;font-size:12px;font-style:normal;font-weight:normal;letter-spacing:normal;line-height:15px;margin:0;text-align:left">
                                                                    <b>Medika Plaza</b>
                                                                </p>
                                                            </td>
                                                        </tr>
                                                       
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>