<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/picnic">


<table class="primary">
    <thead>
        <th>TRX</th>
        <th>Endpoint</th>
        <th>IsSuccess</th>
        <th>Timestamp</th>
        <th>Action</th>
        <th>Request</th>
        <th>Response</th>
    </thead>
    <tbody>
        @foreach($rows as $r)
        <tr>
        <td>{{$r->trx_no}}</td>
        <td>{{$r->endpoint}}</td>
        <td>{{$r->is_success ? 'Sukses' : 'Gagal'}}</td>
        <td>{{$r->created_at}}</td>
        <td>
            <a href="{{url('mpone-log/trigger?id='.$r->getKey().'&trx='.$r->trx_no)}}" class="button">
                Trigger
            </a>


            <a href="{{url('mpone-log/decline?id='.'&trx='.$r->trx_no)}}" class="button dangerous">
                DECLINE GL
            </a>
        </td>
        <td class="code">
            {{-- <pre> --}}
                {{json_encode($r->request)}}
            {{-- </pre> --}}
        </td>
        <td class="code">
            {{-- <pre> --}}
                {{json_encode($r->response)}}
            {{-- </pre> --}}
        </td>
        </tr>
        @endforeach
    </tbody>
</table>

<script>
Object.prototype.prettyPrint = function(){
    var jsonLine = /^( *)("[\w]+": )?("[^"]*"|[\w.+-]*)?([,[{])?$/mg;
    var replacer = function(match, pIndent, pKey, pVal, pEnd) {
        var key = '<span class="json-key" style="color: brown">',
            val = '<span class="json-value" style="color: navy">',
            str = '<span class="json-string" style="color: olive">',
            r = pIndent || '';
        if (pKey)
            r = r + key + pKey.replace(/[": ]/g, '') + '</span>: ';
        if (pVal)
            r = r + (pVal[0] == '"' ? str : val) + pVal + '</span>';
        return r + (pEnd || '');
    };

    return JSON.stringify(this, null, 3)
               .replace(/&/g, '&amp;').replace(/\\"/g, '&quot;')
               .replace(/</g, '&lt;').replace(/>/g, '&gt;')
               .replace(jsonLine, replacer);
}

document.querySelectorAll('.code').forEach(function(r) {
    //r.innerHTML = r.innerHTML.prettyPrint()
})
</script>