<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTableTelmed extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('trx_history_telmed', function (Blueprint $table) {
            $table->string('trx_no_med', 25)->nullable();
            $table->string('status_redeem')->default('pending'); //pending, process, done, cancel
            $table->dateTime('time_redeem')->nullable();
        });
        Schema::table('payment_telmed', function (Blueprint $table) {
            $table->string('type_payment')->default('telemedicine'); //telemedicine / prescription
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trx_history_telmed', function (Blueprint $table) {
            $table->dropColumn([
                'trx_no_med',
                'status_redeem',
                'time_redeem',
            ]);
        });
        Schema::table('payment_telmed', function (Blueprint $table) {
            $table->dropColumn(['type_payment']);
        });
    }
}
