<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMigrationProdsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mpone_log', function (Blueprint $table) {
		$table->id();
	$table->string('trx_no');
	$table->string('endpoint');
	$table->text('request');
	$table->text('response');
	$table->boolean('is_success');
	$table->timestamps();
	});

        Schema::create('geo_regency', function (Blueprint $table) {
		$table->id();
$table->integer('id_city');
	$table->string('code');
	$table->string('name');
	});

        Schema::create('geo_mapping_regency_warehouse', function (Blueprint $table) {
		$table->id();
$table->integer('id_city');
$table->integer('id_warehouse');
	});

        Schema::create('geo_coord_warehouse', function (Blueprint $table) {
		$table->id();
$table->integer('id_warehouse');
$table->float('lat');
$table->integer('lon');
	});

        Schema::create('app_setting', function (Blueprint $table) {
	$table->string('key');
	$table->string('value');
		$table->timestamp('last_update');
	});

        Schema::create('app_faspay_channel', function (Blueprint $table) {
            $table->id();
	$table->string('channel_code');
	$table->string('name');
	$table->string('method');
	$table->string('guide');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
