<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTableTrxHistoryTelmed1506 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('trx_history_telmed', function (Blueprint $table) {
            $table->tinyInteger('is_reminder')->default(0)->comment('0 = not reminder, 1 = reminder 10 menit, 2 = reminder 30 menit');
            $table->string('card_number', 50)->nullable();
        });
        Schema::table('recipe_telmed', function (Blueprint $table) {
            $table->string('signa')->nullable();
            $table->string('remarks', 50)->nullable();
            $table->tinyInteger('taken')->nullable();
        });
        Schema::table('soap_telmed', function (Blueprint $table) {
            $table->string('alergi')->nullable();
            $table->enum('status_hamil',["ya","tidak"])->default("tidak");
            $table->enum('status_menyusui',["ya","tidak"])->default("tidak");
            $table->tinyInteger('usia_kehamilan')->default(0);
        });
        Schema::create('attachment_telmed', function (Blueprint $table) {
            $table->id();
            $table->string('trx_no', 20);
            $table->string('filename')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('trx_history_telmed', function (Blueprint $table) {
            $table->dropColumn([
                'is_reminder',
                'card_number',
            ]);
        });
        Schema::table('recipe_telmed', function (Blueprint $table) {
            $table->dropColumn([
                'signa',
                'remarks',
                'taken',
            ]);
        });
        Schema::table('soap_telmed', function (Blueprint $table) {
            $table->dropColumn([
                'alergi',
                'status_hamil',
                'status_menyusui',
                'usia_kehamilan',
            ]);
        });
        Schema::table('attachment_telmed', function (Blueprint $table) {
            $table->dropColumn([
                'trx_no',
                'filename',
            ]);
        });
    }
}
