<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTableIcd10 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('icd10_telmed', function (Blueprint $table) {
            $table->enum('case_type',['new','old'])->nullable();
            $table->enum('diagnostic_type',['primer','sekunder'])->nullable();
        });
        Schema::table('recipe_telmed', function (Blueprint $table) {
            $table->dropColumn(['qty_taken','one_hand','uom','price','sub_total','fix_total','sigma','tunjangan']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('icd10_telmed', function (Blueprint $table) {
            $table->dropColumn(['case_type','diagnostic_type']);
        });
    }
}
