<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIcd10TelmedsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('icd10_telmed', function (Blueprint $table) {
            $table->id();
            $table->string('trx_no', 20);
            $table->json('icd10_id');
            $table->timestamps();
        });
        
        Schema::table('recipe_telmed', function (Blueprint $table) {
            $table->integer('product_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('icd10_telmed');
        Schema::table('recipe_telmed', function (Blueprint $table) {
            $table->dropColumn(['product_id']);
        });
    }
}
