<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRecipeTelmedsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('recipe_telmed', function (Blueprint $table) {
            $table->id();
            $table->string('trx_no', 20);
            $table->string('medicine_name')->nullable();
            $table->string('description')->nullable();
            $table->integer('qty');
            $table->integer('qty_taken')->nullable();
            $table->string('one_hand', 150)->nullable();
            $table->string('uom', 50)->nullable();
            $table->integer('price')->nullable();
            $table->integer('sub_total')->nullable();
            $table->integer('fix_total')->nullable();
            $table->string('sigma')->nullable();
            $table->tinyInteger('tunjangan')->default(0)->comment('0 = false, 1 = true');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('recipe_telmed');
    }
}
