<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentTelmedsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_telmed', function (Blueprint $table) {
            $table->id();
            $table->string('trx_no', 20)->nullable();
            $table->string('invoice_no', 30)->nullable();
            $table->string('pay_method', 20)->nullable();
            $table->dateTime('pay_date')->nullable();
            $table->dateTime('pay_exp_date')->nullable();
            $table->integer('pay_amount')->nullable();
            $table->string('pay_status', 20)->nullable();
            $table->string('pay_message', 50)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_telmed');
    }
}
