<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWebUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('web_user', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('phone', 15)->nullable();
            $table->string('nik', 50)->nullable();
            $table->string('group', 4)->default('1000')->nullable()->comment('1000 = admin, 2000 = dokter');
            $table->string('photo', 60)->nullable();
            $table->string('conf_code', 150)->nullable();
            $table->string('reset_pass_code', 50)->nullable();
            $table->tinyInteger('conf_email_status')->default(0)->nullable()->comment('0 = need email confirmation, 1 = email confirmed');
            $table->timestamp('email_verified_at')->nullable();
            $table->tinyInteger('status')->default(1)->comment('0 = inactive, 1 = active, 2 = Need Approval');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('web_user');
    }
}
