<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class TrxHistory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trx_history_telmed', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_user')->nullable();
            $table->unsignedBigInteger('id_dokter')->nullable();
            $table->string('trx_no', 20)->nullable();
            $table->string('service', 20)->nullable();
            $table->string('company_name', 100)->nullable();
            $table->string('cust_name', 60)->nullable();
            $table->string('patient_type', 60)->nullable();
            $table->date('birth_date')->nullable();
            $table->string('phone', 15)->nullable();
            $table->string('email')->nullable();
            $table->enum('gender',['male','female'])->nullable();
            $table->string('nik', 50)->nullable();
            $table->text('address')->nullable();
            $table->date('date_consul')->nullable();
            $table->time('time_consul')->nullable();
            $table->dateTime('trx_date')->nullable();
            $table->dateTime('trx_expired')->nullable();
            $table->integer('trx_amount')->nullable();
            $table->string('trx_status', 50)->nullable();
            $table->string('trx_status_code', 2)->nullable();
            $table->string('pay_method', 20)->nullable();
            $table->string('link_meet', 150)->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
            $table->index('trx_no');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trx_history_telmed');
    }
}
