<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAppDevicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('app_device', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_user')->default(0);
            $table->string('app_buildnumber');
            $table->string('app_version');
            $table->string('app_platform', 150);
            $table->string('app_device');
            $table->timestamps();
        });

        Schema::create('app_version', function (Blueprint $table) {
            $table->id();
            $table->string('app_version', 150);
            $table->unsignedBigInteger('app_buildnumber')->default(0);
            $table->string('status_update')->default('soft');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('app_device');
        Schema::dropIfExists('app_version');
    }
}
