<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTableUser extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('app_user', function (Blueprint $table) {
            $table->string('card_number', 50)->after('member_no')->nullable();
            $table->string('relationship', 5)->after('card_number')->nullable();
            $table->tinyInteger('member_type')->after('relationship')->nullable();
            $table->tinyInteger('conf_email_status')->default(0)->after('token_device')->nullable()->comment('0 = need email confirmation, 1 = email confirmed');
            $table->string('photo', 60)->nullable();
            $table->renameColumn('email_conf', 'conf_code');
            $table->string('reset_pass_code', 50)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('app_user', function (Blueprint $table) {
            $table->dropColumn(['card_number']);
            $table->dropColumn(['relationship']);
            $table->dropColumn(['member_type']);
            $table->dropColumn(['conf_email_status']);
            $table->dropColumn(['photo']);
            $table->dropColumn(['conf_code']);
        });
    }
}
