<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],
    'maps' => env('KEYMAPS', 'AIzaSyB-YxjqE4xnthgW2ehFVuh674vleGcx1yY'),

    'medikaplaza' => [
        'web_telmed'=> rtrim(env('URLMPDASH', 'https://devmptelmed.medikaplaza.com'), '/'),
        'api'       => rtrim(env('URLMPAPI', 'https://mp-onestaging-mobile.medikaplaza.com'), '/'),
        'webfront'  => rtrim(env('URLMP', 'https://mp-one.medikaplaza.com'), '/'),
        'ecard'     => env('URLMPECARD', 'https://mp-one.medikaplaza.com/api/memberCard'),
        'hospital'  => env('URLMPHOSPITAL', 'https://mp-one.medikaplaza.com/api/hospital/appointment'),
        'reimburs'  => env('URLMPREIMBURS', 'https://mp-one.medikaplaza.com/api/reimbursement'),
        'reupload'  => env('URLMPREUPLOAD', 'https://mp-one.medikaplaza.com/api/reimbursement/reupload'),
        'attach'    => env('URLMPATTACH', 'https://mp-one.medikaplaza.com/mobile-apps/medikaplaza?model=ir.attachment&field=datas&id='),
        'buku-saku' => env('URLMPBUKUSAKU', 'https://mp-one.medikaplaza.com/api/buku-saku'),
        'claim'     => env('URLCLAIM', 'https://platform.medikaplaza.com/api/merchant/promotion/claim_voucher'),
        'redeem'    => env('URLREDEEM', 'https://platform.medikaplaza.com/api/merchant/promotion/redeem_voucher'),
        'promotion' => rtrim(env('URLPROMOTION', 'https://platform.medikaplaza.com'), '/'),
        'qiscus'    => "https://multichannel.qiscus.com/whatsapp/v1/".env('QISCUS_APP_ID')."/".env('QISCUS_CHANNEL_ID')."/messages",
        'jitsi'     => env('JITSI_APPID'),
        "telemedicine_mode" => env('TELMED_MODE', 'staging'),
        "telemedicine" => [
            'obat'                  => env('URLMPOBAT', 'https://mp-onestaging.medikaplaza.com/api/list/obat/telemedicine'),
            'create_gl'             => env('URLMPCREATEGL', 'https://mp-onestaging.medikaplaza.com/api/create/gl/telemedicine'),
            'reschedule_gl'         => env('URLMPRESCHEDULEGL', 'https://mp-onestaging.medikaplaza.com/api/reschedule/gl/telemedicine'),
            'decline_gl'            => env('URLMPDECLINEGL', 'https://mp-onestaging.medikaplaza.com/api/decline/gl/telemedicine'),
            'assign_result_nonself' => env('URLMPRESNONSELF', 'https://mp-onestaging.medikaplaza.com/api/update/result/telemedicine'),
            'assign_result_self'    => env('URLMPRESSELF', 'https://mp-onestaging.medikaplaza.com/api/create/result/telemedicine'),
            'report_gl'             => env('URLMPREPORTGL', 'https://mp-onestaging.medikaplaza.com/api/report/gl/telemedicine'),
            'report_invoice'        => env('URLMPREPORTINV', 'https://mp-onestaging.medikaplaza.com/api/report/invoice/telemedicine'),
            'report_obat'           => env('URLMPREPORTOBAT', 'https://mp-onestaging.medikaplaza.com/api/report/resep/telemedicine'),
            'report_mr'             => env('URLMPREPORTMR', 'https://mp-onestaging.medikaplaza.com/api/report/mr/telemedicine'),
            'payment'               => env('URLMPFASPAY', 'https://mp-onestaging.medikaplaza.com/api/payment/telemedicine'),
        ],
    ],
    'faspay' => [
        'username' => env('FASPAY_USERNAME'),
        'password' => env('FASPAY_PASSWORD'),
        'endpoint' => env('FASPAY_ENDPOINT'),
        "postData" => [
            'DEVELOPMENT'    => "https://debit-sandbox.faspay.co.id/cvr/300011/10",
            'PRODUCTION'     => "https://web.faspay.co.id/cvr/300011/10",
        ],
        "channel" => [
            'DEVELOPMENT'    => "https://debit-sandbox.faspay.co.id/cvr/100001/10",
            'PRODUCTION'     => "https://web.faspay.co.id/cvr/100001/10",
        ],
        "inquiryStatus" => [
            'DEVELOPMENT'    => "https://debit-sandbox.faspay.co.id/cvr/100004/10",
            'PRODUCTION'     => "https://web.faspay.co.id/cvr/100004/10",
        ]
    ],

];
