<?php

namespace App\Services\Validator;

use Helper;
use App\Exceptions\GeneralException;
use App\Exceptions\ValidateException;
use App\Exceptions\UnauthorizedException;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Facades\JWTAuth as JWTAuth;
use App\Services\Validator\EmailAlreadyTakenException;

class ValidatorManager implements ValidatorManagerInterface
{
    public function validateJSON($request, $rule)
    {
        $validator = \Validator::make($request->only(array_keys($rule)), $rule);
        
        if ($validator->fails()) {
            $validatorResult = Helper::mapErrorsValidator($validator->errors()->toArray());

            throw new ValidateException($validatorResult);
        }
    }
    public function emailIsAlreadyTaken($user)
    {
        if ($user === 1) {
            throw new EmailAlreadyTakenException();
        }
    }
    public function validateRequest($function, $request, $rule, $customMessage=[])
    {
        $email      = '';
        $validator  = \Validator::make($request->only(array_keys($rule)), $rule, $customMessage);

        if ($validator->fails()) {
            // Helper::Log('warning', $function." Request Validator", $validator->errors()->first());
            throw new GeneralException($validator->errors()->first(), ['requestData' => $request->all()], 422);
        }
    }
    public function ValidationResponseError($response)
    {
        // return $response;
        if ($response) {
            throw new UnauthorizedException($response, 400);
        }
    }
}
