<?php
namespace App\Services\Mail;

use Helper;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller as BaseController;

class SendMail extends BaseController
{
    public function __construct() {
        
    }

    public function sendEmail($email_arr, $data){
        $more_users = false;
        $email = $email_arr;
        if(is_array($email_arr)){
            $email          = $email_arr[0];
            $more_users     = array_slice($email_arr, 1);
        }

        try {
            $mail = Mail::to($email);
            if(!!$more_users)
                $mail->cc($more_users);

            $mail->send($data);

            $return = [
                'status' => true,
                'data'   => $data
            ];
    
            Helper::Log('info','Send Email', $return);
            return $return;

        } catch (\Exception $e) {
            $return = [
                'status' => false,
                'message' =>  $e->getMessage()
            ];
            Helper::Log('error','Send Email', $return);
        }
        
    }
}
