<?php

namespace App\Services;

use Exception;
use Illuminate\Support\Str;
use App\Models\User as UserMobile;
use App\Models\Web_user as UserWeb;
use App\Models\User_uuid as UserUUID;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class Jitsi 
{
    protected static function headerJwt() {
        return [
            "alg" => "RS256",
            "kid" => config('services.medikaplaza.jitsi') . '/' . 'b0560a',
            "typ" => "JWT",
        ];
    }

    protected static function getUUID($primaryKey, $instance)
    {
        $checkExist = UserUUID::where('id_user', $primaryKey)->where('type', $instance)->first();
        if (! is_null($checkExist)) {
            return $checkExist->uuid;
        }

        $createNew = UserUUID::create([
            'id_user' => $primaryKey,
            'type' => $instance,
            'uuid' => (string) Str::orderedUuid(),
        ]);

        return $createNew->uuid;
    }


    protected static function bodyJwt($user) {
        $feature = [
            "transcription" => true
        ];

        $name = '';
        $avatar = url('mp.png');
        $email = '';
        $moderator = false;
        if ($user instanceof UserMobile) {
            $name = $user->name;
            $email = $user->email;
            $uuid = self::getUUID($user->getKey(), 'mobile');
        } else if ($user instanceof UserWeb) {
            $name = $user->name;
            $email = $user->email;
            $uuid = self::getUUID($user->getKey(), 'web');
            $moderator = true;
            $feature['recording'] = true;
        } else { // guest mode
            $name = 'Guest';
            $email = 'guest@medikaplaza.com';
            $uuid = self::getUUID(99999, 'system');
            // throw new \Exception('Invalid user instance');
        }

        return [
            "aud" => "jitsi",
            "context" => [
              "user" => [
                "id" => $uuid,
                "name" => $name,
                "avatar" => $avatar,
                "email" => $email,
                "moderator" => $moderator
              ],
              "features" => $feature,
              "room" => [
                "regex" => false
              ],
            ],
            "admin" => $moderator, // for 
            "exp" => time() + (1 * 60 * 60 * 24), // 24 hours
            "iss" => "chat",
            "nbf" => time(),
            "room" => "*",
            "sub" => config('services.medikaplaza.jitsi')
        ];
    }

    public static function generateJwt($user)
    {
        $key = 'example_key';
        $payload = self::bodyJwt($user);
        $headers = self::headerJwt();
        $jwt = JWT::encode($payload, self::privKey(), 'RS256', null, $headers);

        return $jwt;
    }

    private static function pubKey()
    {
        $publicKey = <<<EOD
-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDfE/rIHocYimCgEMxY/7UZWalj
EL8S3hh3G0LhDnh0y9Ky0FZreh3pK/gB/ujbzU0y2IAJy4NrvzUBc4ubl4st+3qk
PStSmNkQm+hvAg7zp60ZcXp3dlB0x0ex6QHF5yKt1yKj8OMOWbiUSs7cRL2/bWWM
AbBTPTjHzfjPOA1dKQIDAQAB
-----END PUBLIC KEY-----
EOD;

        return $publicKey;
    }

    private static function privKey()
    {
        $privateKey = <<<EOD
-----BEGIN ENCRYPTED PRIVATE KEY-----
MIICzzBJBgkqhkiG9w0BBQ0wPDAbBgkqhkiG9w0BBQwwDgQICy0tA3iSuRgCAggA
MB0GCWCGSAFlAwQBKgQQWg8lR9cDBPh9T6Sf1GB41QSCAoDIO4LqQpcKogQg4CDu
Z+o/O+ltooaSVm35zVPJyo+GGAnBinDmIHc9ntkl79u+peMB/BfJhilCEAbLGqlU
JN5Rydlw+55TuQci6+rLCptn0kJLO7dEs03DwFlHTqv7N8VWYV6HVUGP6ULVBMQm
pe/b23D5uVGPr3NsdFvDtxM8zZvA4cKKWa5GfrPZDvy0Qkw84Rsg4lwJV/Zts6t3
ecwgQnoOn/B9ZKHvDYW3pGjZwjT7j3j6ecXBPUcNTmiPjtzKMgtwsvqw9etRcp7c
wwH0usfuV0EIzRrgtE6c+WiIA+p/Vie9VOPfsKSXvZWbxgO0qIFPmxcuhYfMDeVr
PDWBe4VV5EwNm6VDtnMv3b4wv3R+Wtvqr3L1ngzlIRrwHu9LpsLlh2CszFDU2iCa
QbeM3MV3oFskcIWA/lrTClsfcFjEg59xxA+SFAKInUmXDuswXuroVQW0CAUgK1n5
FzueRmY3euaGtpYO3DVrVDvHaQ75JwRbqqBXk+6VLQVCbsDxpB6ofXE/FiBAD2kB
ybx72+O1U8cobVu6l3BZZF4OIyxeVfI6hRYG9/NKKZzGHFv7tTFNVPu3h5lrfl0G
0Y8An5psawhe0zSRT7hbhSNf98shS8i1G58qkAOZbc5BHvTR06gtSVRf8ipfkohq
cOheYdrtvv2mTHGmZ9EDYRBTWZttgNyyHeoyQMsc3Ah6XQQOrqgSsvaurxKQjVR+
d/9qI8gKkvvgXLee5vQZPp56EPq4Fl0NEl8BhxGkvc/MKUwghZ5ufUOoIdCCdymz
BCMom5ZI26gGDYvX014nK6neCPslvOjyUkI0YdsbF4vo0xzfnK0FUfKQzmVMQxYZ
TK+q
-----END ENCRYPTED PRIVATE KEY-----
EOD;

        $res = openssl_pkey_get_private(
        $privateKey,
        'MPOneMobile#123'
        );

        return $res;

        return $privateKey;
    }
}
