<?php

namespace App\Services;

use Helper;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Google\Cloud\Storage\StorageClient;
use Google\Cloud\Core\Exception\ServiceException;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class Geo
{
    public static function getNearbyWarehouse($regencyId, $originLat, $originLon)
    {
        $q = "SELECT m.id_warehouse, c.lat, c.lon
        FROM geo_mapping_regency_warehouse m
        LEFT JOIN geo_coord_warehouse c ON m.id_warehouse = c.id_warehouse
        WHERE id_city = %d";
        $q = sprintf($q, $regencyId);
        $warehouses = DB::connection('pgsql')->select($q);
        if (count($warehouses) == 0) {
            // not found, fallback to Apotek BOP
            return 6;
        }
        if (count($warehouses) == 1) {
            // only found 1, send first result
            return $warehouses[0]->id_warehouse;
        }

        // fallback to find nearby based on location
        $q = "SELECT
        m.id_warehouse,
        c.lat,
        c.lon,
        6371 * acos(cos(radians(%f)) * cos(radians(c.lat)) 
        * cos(radians(c.lon) - radians(%f)) 
        + sin(radians(%f)) 
        * sin(radians(c.lat))) AS jarak                        
        FROM geo_mapping_regency_warehouse m
        LEFT JOIN geo_coord_warehouse c ON m.id_warehouse = c.id_warehouse
        WHERE id_city = %d
        ORDER BY jarak";
        $q = sprintf($q, $originLat, $originLon, $originLat, $regencyId);
        $warehousesNearby = DB::connection('pgsql')->select($q);

        return $warehousesNearby[0]->id_warehouse;
    }

    public static function getRegionalId($placeCode)
    {
        $q = "SELECT id_city
        FROM geo_regency
        WHERE code = '%s'
        LIMIT 1";
        $q = sprintf($q, $placeCode);
        $r = DB::connection('pgsql')->select($q);
        if (count($r) == 0) return null;

        return $r[0]->id_city;
    }

    // https://maps.googleapis.com/maps/api/geocode/json?latlng=-6.3870855616967805,106.8549550637923&key=AIzaSyB-YxjqE4xnthgW2ehFVuh674vleGcx1yY&language=id
    public static function callReverseService(string $coord)
    {
        $url = sprintf('https://maps.googleapis.com/maps/api/geocode/json?latlng=%s&key=%s&language=id', $coord, config('services.maps'));
        $request = Http::withHeaders([
            'Accept' => 'application/json',
            'Content-Type' => 'application/json'
        ])->get($url);
        $response = json_decode($request->body());
        
        // err checker
        if ($response === null && json_last_error() !== JSON_ERROR_NONE) {
            Helper::Log("info", "reversegeozero", ['coord' => $coord, 'response' => $request->body()]);

            return null;
        }

        // found
        if (isset($response->results)
            && count($response->results)) {
            $found = false;
            $placeId = null;
            $placeName = null;

            foreach ($response->results as $r) {
                if(in_array('administrative_area_level_2', $r->types)) {
                    $found = true;
                    $placeId = $r->place_id;
                    $placeName = $r->formatted_address;
                    break;
                }
            }

            if (! $found) return null;

            return $placeId;
        } else {
            Helper::Log("info", "reversegeozero", ['coord' => $coord, 'response' => $request->body()]);
            return null;
        }
    }
}
