<?php

namespace App\Services;

use Helper;
use Exception;
use App\Models\User;
use App\Models\Notifikasi;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\ApnsConfig;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Kreait\Firebase\Messaging\AndroidConfig;

class Firebase 
{
    protected $firebase;
    public $me;

    public function __construct()
    {
        $path = database_path('medikaplaza-2bbf9-7a444d2a1400.json');
        $this->firebase = (new Factory)->withServiceAccount($path);
        $this->me          = auth()->user();
    }
    public function getUserToken($id=null){
        try{
            if (!isset($this->me->id)) {
                $id_user = $id;
            }else{
                $id_user = $this->me->id;
            }
            $user = User::select(['user_token.token_device','app_user.id'])
                    ->where('app_user.id', $id_user)
                    ->leftJoin('user_token','user_token.id_user','=','app_user.id')
                    ->get();
            return $user;
        }catch(Exception $e){
            Helper::Log('error', 'Get User Token Failed', $e->getMessage());
            return collect([]);
        }
    }
    public function pushNotif($data){
		if(!is_array($data)){
			return false;
		}
		$label 	        = $data['label'] ?? '';
		$text  	        = $data['text'] ?? '';
		$type	        = $data['type'] ?? '';
		$user	        = $data['user'] ?? [];
		$id_admission	= $data['id_admission'] ?? null;
		$id_promotion	= $data['id_promotion'] ?? null;
		$id_user	    = $data['id_user'] ?? $this->me->id;
		$this->fcm($label,$text,$user);
		$this->pushNotifDb($id_user, $label,$type, $text, $id_admission, $id_promotion);
	}
    public function fcm($label, $text, $user){
        if(!isset($user) || !$user){
			return false;
		}
        try{
            $token_device = [];
            $token_device = collect($user)->map(function($r) {
                try {
                    Helper::Log("info", "Token Device", ['token'=>$r['token_device']]);
                    return $r['token_device'];
                } catch (\Exception $e) {
                    return [];
                }
                })->filter(function($r) {
                    return $r != null;
                })->toArray();
            $messaging = $this->firebase->createMessaging();
            $message = CloudMessage::new();
    
            $message = $message->withNotification(Notification::create($label, $text));
            // Android
            $config = AndroidConfig::fromArray([
				'priority' => 'high',
				'notification' => [
					'notification_priority' => "PRIORITY_HIGH",
					'default_vibrate_timings' => true,
					'default_sound' => true,
					'sound' => 'default',
					'icon' => 'ic_launcher'
				],
			]);
            $message = $message->withAndroidConfig($config);
            // IOS
            $config = ApnsConfig::fromArray([
                'headers' => [
                    'apns-priority' => '10',
                ],
                'payload' => [
                    'aps' => [
                        'alert' => [
                            'title' => $label,
                            'body' => $text,
                        ],
                        'badge' => 42,
                    ],
                ],
            ]);
            
            $message = $message->withApnsConfig($config);
            $report = $messaging->sendMulticast($message, $token_device);
            
            if ($report->hasFailures()) {
                foreach ($report->failures()->getItems() as $failure) {
                    Helper::Log('error', "Failed push notification firebase", [$failure->error()->getMessage()]);
                    return Helper::generalResponse(false, 'Error.', $failure->error()->getMessage(), 500);
                }
            }
            return true;
        }catch (\Exception $e){
            Helper::Log('error', 'Error on push notification firebase', $e->getMessage(), $e);
			return false;
        }
    }
    public  function pushNotifDb($id_user, $label, $type, $text, $id_admission, $id_promotion){
        try{
            $arr = [
				'id_user'       => $id_user,
				'id_admission'  => $id_admission,
				'id_promotion'  => $id_promotion,
				'label'         => $label,
				'type'          => $type,
				'text'          => $text,
            ];
            Notifikasi::create($arr);
        }catch(Exception $e){
            Helper::Log('error', 'Insert Notifikasi Failed', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage());
        }
    }
}
