<?php

namespace App\Repository;

use Helper;
use Library;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Faspay_log;
use Illuminate\Http\Request;
use App\Models\Payment_telmed;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Exceptions\JWTException;
use App\Http\Controllers\Controller as BaseController;

class FaspayManager extends BaseController
{
    public $URL;
    public $URL_CHANNEL;
    public $conn;
    public $REPO;
    
    public function __construct()
    {  
        $this->REPO         = new TelemedicineManager();
        if(config('services.medikaplaza.telemedicine_mode') == 'production'){
            $this->URL         = config('services.faspay.postData.PRODUCTION');
            $this->URL_CHANNEL = config('services.faspay.channel.PRODUCTION');
            $this->conn        = DB::connection('pgsql');
        }else{
            $this->URL         = config('services.faspay.postData.DEVELOPMENT');
            $this->URL_CHANNEL = config('services.faspay.channel.DEVELOPMENT');
            $this->conn        = DB::connection('stag_medika');
        }
    }

    // bayar telmed
    public function postData($data, $request)
    {
        $now            = Carbon::now();
        // $expired_date   = Carbon::now()->addDays(1);
        $expired_date   = $now->addMinutes(15);
        $expired_date_string    = $expired_date->toDateTimeString();
        $signature = self::generateSignature($data->trx_no);

        $inv_number = strtoupper("INV-".date('ymd')."-".Helper::codeGenerator(10));

        $item =  [[
            "product" => "Invoice No. $inv_number",
            "qty" => "1",
            "amount" => $data->trx_amount,
            "payment_plan" => "1",
            "merchant_id" => env('FASPAY_MERCHANT_ID'),
            "tenor" => "00"
        ]];

        $request = [
            "request"   => "Post Data Transaction", 
            "merchant_id"   => env('FASPAY_MERCHANT_ID'), 
            "merchant"  => env('FASPAY_MERCHANT_NAME'), 
            "bill_no"   => $data->trx_no, 
            "bill_reff" => $inv_number, 
            "bill_date" => $now, 
            "bill_expired"  => $expired_date_string, 
            "bill_desc" => "Pembayaran $data->trx_no", 
            "bill_currency" => "IDR", 
            "bill_gross"    => "0", 
            "bill_miscfee"  => "0", 
            "bill_total"    => ((string) $data->trx_amount) . '00', 
            "cust_no"   => "123456", 
            "cust_name" => $data->cust_name, 
            "payment_channel"   => $request->pay_channel_code, 
            "pay_type"  => "1", 
            "msisdn"    => $data->phone, 
            "email" => $data->email??"", 
            "terminal"  => "10", 
            "item"  => $item,
            "signature" => $signature
        ];
        $payload = json_encode($request);

        $response = Http::withBody(
            $payload, 'application/json'
            )->post($this->URL);
        $res = json_decode($response);
        Helper::LogFaspay('info', 'FASPAY', ['request' => $payload, 'response' => $response]);
        if (!isset($res) || is_null($res) ) {
            Helper::LogFaspay('info', 'faspay-err-create', ['response' => $response, 'request' => $request]);
            throw new \Exception("Post data to faspay Failed");
        }else{
            // Insert log
            $post_data = [
               'trx_no'                => $data->trx_no,
               'invoice_no'            => $inv_number,
               'pay_method'            => $request['payment_channel']??"-",
               'pay_date'              => $now,
               'pay_exp_date'          => $expired_date_string,
               'pay_amount'            => $data->trx_amount,
               'pay_status'            => Payment_telmed::STS_CODE_PENDING,
               'pay_message'           => Payment_telmed::STS_PENDING,
               'post_data_response'    => $res??"",
           ];
           
           $ins_payment = self::insertPostData($post_data);
           // add response
           $res->invoice_no = $inv_number;
        }
        return $res;
    }

    // tebus obat
    public function postDataRetail(Trx_history_telmed $data, $request)
    {
        $now            = Carbon::now();
        $expired_date   = $now->addMinutes(15);
        $expired_date_string    = $expired_date->toDateTimeString();
        $trx_no = $data->trx_no."-MED";
        $signature = self::generateSignature($trx_no);

        $inv_number = strtoupper("INV-".date('ymd')."-".Helper::codeGenerator(10));
        $trx_amount = self::getAmount($data);
        if($trx_amount == 0){
            throw new Exception("Invalid amount Post data to faspay");
        }


        $mpOneLib    = new MPOneManager();
        $biayaEkspedisi = $mpOneLib->getBiayaEkspedisi($data);
        $trx_amount = $trx_amount + $biayaEkspedisi['price'];

        $item =  [[
            "product" => "Invoice No. $inv_number",
            "qty" => "1",
            "amount" => $trx_amount,
            "payment_plan" => "1",
            "merchant_id" => env('FASPAY_MERCHANT_ID'),
            "tenor" => "00"
        ]];

        $request = [
            "request"   => "Post Data Transaction", 
            "merchant_id"   => env('FASPAY_MERCHANT_ID'), 
            "merchant"  => env('FASPAY_MERCHANT_NAME'), 
            "bill_no"   => $trx_no, 
            "bill_reff" => $inv_number, 
            "bill_date" => $now, 
            "bill_expired"  => $expired_date_string, 
            "bill_desc" => "Pembayaran $trx_no", 
            "bill_currency" => "IDR", 
            "bill_gross"    => "0", 
            "bill_miscfee"  => "0", 
            "bill_total"    => ((string) $trx_amount) . '00', 
            "cust_no"   => "123456", 
            "cust_name" => $data->cust_name, 
            "payment_channel"   => $request->pay_channel_code, 
            "pay_type"  => "1", 
            "msisdn"    => $data->phone, 
            "email" => $data->email??"", 
            "terminal"  => "10", 
            "item"  => $item,
            "signature" => $signature
        ];
        $payload = json_encode($request);

        $response = Http::withBody(
            $payload, 'application/json'
            )->post($this->URL);
        $res = json_decode($response);
        Helper::LogFaspay('info', 'FASPAY', ['request' => $payload, 'response' => $response]);
        if (!isset($res) || is_null($res) ) {
            Helper::LogFaspay('info', 'faspay-err-create', ['response' => $response, 'request' => $request]);
            throw new \Exception("Post data to faspay Failed");
        }else{
            // Insert log
            $post_data = [
               'trx_no'                => $trx_no,
               'invoice_no'            => $inv_number,
               'pay_method'            => $request['payment_channel']??"-",
               'pay_date'              => $now,
               'pay_exp_date'          => $expired_date_string,
               'pay_amount'            => $trx_amount,
               'pay_status'            => Payment_telmed::STS_CODE_PENDING,
               'pay_message'           => Payment_telmed::STS_PENDING,
               'post_data_response'    => $res??"",
               'type_payment'          => Payment_telmed::TYPE_PRESCRIPTION,
           ];
           
           $ins_payment = self::insertPostData($post_data);
           // add response
           $res->invoice_no = $inv_number;
        }
        return $res;
    }
    public function getAmount($data)
    {
        if (!$data->relationLoaded('recipe')) {
            $data->load('recipe');
        }
        $recipes = $data->recipe;
        $total_amount = 0;
        if(count($recipes)>0){
            $id_dokter = $data->id_dokter??0;
            $get_amount = collect($recipes)->map(function ($res) use ($id_dokter){
                $sql = "SELECT 
                            rp.id,
                            rp.faskes_id,
                            sw.id as id_warehouse  
                        FROM res_partner rp
                        LEFT JOIN stock_warehouse sw ON
                            rp.faskes_id = sw.faskes_id
                        WHERE 
                            rp.id = %d LIMIT 1";
                        $sql = sprintf($sql, $id_dokter);
                $cekFaskes = $this->conn->select(DB::raw($sql));
    
                $idFaskes = 0;
                if (count($cekFaskes)) {
                    $idFaskes = $cekFaskes[0]->faskes_id;
                }
                $where = " AND cp.product_tmpl_id = $res->producttemp_id AND cp.faskes_id = $idFaskes ";
                $get_price = $this->REPO->priceObat($where);
                $price = (int)$get_price->first()->price??0;
                $map = [
                    "producttemp_id"    => $res->producttemp_id,
                    "qty"               => $res->qty,
                    "price"             => $price,
                    "total_amount"      => (int)$res->qty * $price,
                ];
                return $map;
            });
            $total_amount = collect($get_amount)->sum('total_amount')??0;
        }
        return (int)$total_amount;
    }

    public function inquiryStatus($trxId)
    {
        /*
        $now            = Carbon::now();
        $expired_date   = Carbon::now()->addDays(1);
        $expired_date_string    = $expired_date->toDateTimeString();
        $signature = self::generateSignature($data->trx_no);

        $inv_number = strtoupper("INV-".date('ymd')."-".Helper::codeGenerator(10));

        $item =  [[
            "product" => "Invoice No. $inv_number",
            "qty" => "1",
            "amount" => $data->trx_amount,
            "payment_plan" => "1",
            "merchant_id" => env('FASPAY_MERCHANT_ID'),
            "tenor" => "00"
        ]];

        $request = [
            "request"   => "Post Data Transaction", 
            "merchant_id"   => env('FASPAY_MERCHANT_ID'), 
            "merchant"  => env('FASPAY_MERCHANT_NAME'), 
            "bill_no"   => $data->trx_no, 
            "bill_reff" => $inv_number, 
            "bill_date" => $now, 
            "bill_expired"  => $expired_date_string, 
            "bill_desc" => "Pembayaran $data->trx_no", 
            "bill_currency" => "IDR", 
            "bill_gross"    => "0", 
            "bill_miscfee"  => "0", 
            "bill_total"    => (string) $data->trx_amount, 
            "cust_no"   => "123456", 
            "cust_name" => $data->cust_name, 
            "payment_channel"   => $request->pay_channel_code, 
            "pay_type"  => "1", 
            "msisdn"    => $data->phone, 
            "email" => $data->email??"", 
            "terminal"  => "10", 
            "item"  => $item,
            "signature" => $signature
        ];
        $payload = json_encode($request);

        $response = Http::withBody(
            $payload, 'application/json'
            )->post($this->URL);
        $res = json_decode($response);
        if (!isset($res) || is_null($res) ) {
            Helper::LogFaspay('info', 'faspay-err-create', ['response' => $response, 'request' => $request]);
            throw new \Exception("Post data to faspay Failed");
        }else{
            // Insert log
            $post_data = [
               'trx_no'                => $data->trx_no,
               'invoice_no'            => $inv_number,
               'pay_method'            => $request['payment_channel']??"-",
               'pay_date'              => $now,
               'pay_exp_date'          => $expired_date_string,
               'pay_amount'            => $data->trx_amount,
               'pay_status'            => Payment_telmed::STS_CODE_PAID,
               'pay_message'           => Payment_telmed::STS_PAID,
               'post_data_response'    => $res??"",
           ];
           
           $ins_payment = self::insertPostData($post_data);
           // add response
           $res->invoice_no = $inv_number;
        }
        return $res;
        */
    }
    public function getChannelFaspay(){
        try{
            $signature = self::generateSignature();
            $request = [
                "request"   => "Request List of Payment Gateway", 
                "merchant_id"   => env('FASPAY_MERCHANT_ID'), 
                "merchant"  => env('FASPAY_MERCHANT_NAME'), 
                "signature" => $signature
            ];
            $payload = json_encode($request);
    
            $response = Http::withBody(
                $payload, 'application/json'
                )->post($this->URL_CHANNEL);
            $res = json_decode($response);
            Helper::LogFaspay('info', 'FASPAY', ['request' => $payload, 'response' => $response]);
            if (!isset($res) || is_null($res) ) {
                Helper::LogFaspay('info', 'faspay-err-getpaymentchannel', ['response' => $response, 'request' => $request]);
                throw new \Exception("Get Payment Channel to faspay Failed");
            }
            return $res;
        }catch(Exception $e){
            report($e);
            Helper::LogFaspay('error','Error Get Payment Channel Faspay', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
        
    }

    public function paymentNotification(Request $request)
    {
	    Helper::LogFaspay('info', 'FASPAY : payload', ['headers' => $request->header(), 'req' => $request->all()]);
   
        $request_data = $request->getContent();
        if(!Helper::isJson($request_data)){
            Helper::LogFaspay('info', 'FASPAY : The request is not in a JSON format.', $request_data);
            return Helper::generalResponse(false,  'The request is not in a JSON format.', [], 401);
        }
        $faspay_request = json_decode($request_data, true);
        // Insert faspay request
        $log = [
            "trx_no"    => $faspay_request['bill_no'],
            "request"    => $faspay_request,
        ];
        $faspay_log = self::insertFaspayLog($log);
        // Check Transaction
        $bill_no = explode("-",$faspay_request['bill_no']);
        $trxno = $bill_no[0]??$faspay_request['bill_no'];

        $trx = Trx_history_telmed::where('trx_no', $trxno)->first();
        if(is_null($trx)){
            Helper::LogFaspay('error', 'Transaction not found', []);
            return self::showResponse("14", $faspay_request);
        }
        $signature = self::generateSignaturePayment($faspay_request['bill_no'], $faspay_request['payment_status_code']);

        if($faspay_request['signature'] != $signature){
            Helper::LogFaspay('error', 'Invalid Signature', $faspay_request);
            return self::showResponse("96", $faspay_request);
        }
        if($faspay_request['payment_status_code'] != '2'){
            Helper::LogFaspay('error', 'Format Error', $faspay_request);
            return self::showResponse("30", $faspay_request);
        }
        if(! isset($faspay_request['signature'])){
            Helper::LogFaspay('error', 'Format Error', $faspay_request);
            return self::showResponse("30", $faspay_request);
        }
        //if($request->header('x-real-ip') != '147.139.192.98'){
        //    Helper::LogFaspay('error', 'Security Violation', $faspay_request);
        //    return self::showResponse("56", $faspay_request);
        //}
        if($faspay_request['merchant_id'] != env('FASPAY_MERCHANT_ID')){
            Helper::LogFaspay('error', 'Invalid Merchant', $faspay_request);
            return self::showResponse("03", $faspay_request);
        }
        if($trx->patient_type == 'retail'){
            $payment = Payment_telmed::where('trx_no', $faspay_request['bill_no'])->latest()->first();
            if(is_null($payment)){
                Helper::LogFaspay('error', 'Payment Medicine not found', $faspay_request);
                return self::showResponse("13", $faspay_request);
            }
            if($faspay_request['payment_total'] != $payment->pay_amount){
                Helper::LogFaspay('error', 'Invalid Amount', $faspay_request);
                return self::showResponse("13", $faspay_request);
            }
            // Cek payment status faspay
            if($trx->status_redeem == Trx_history_telmed::STS_TEBUS_PROCESS){
                if($faspay_request['payment_status_code']==2){
                    // Update status trx
                    $trx->status_redeem     = Trx_history_telmed::STS_TEBUS_DONE;
                    $trx->save();
                    // Send result
                    $call_artisan = Artisan::call("send:result");
                }
            }else{
                // Update status trx
                $trx->trx_status_code   = Trx_history_telmed::STS_CODE_WAIT_CONFIRMATION;
                $trx->trx_status        = Trx_history_telmed::STS_WAIT_CONFIRMATION;
                $trx->save();
            }
            
        }else{
            if($faspay_request['payment_total'] != $trx->trx_amount){
                Helper::LogFaspay('error', 'Invalid Amount', $faspay_request);
                return self::showResponse("13", $faspay_request);
            }
            // Update status trx
            $trx->trx_status_code   = Trx_history_telmed::STS_CODE_WAIT_CONFIRMATION;
            $trx->trx_status        = Trx_history_telmed::STS_WAIT_CONFIRMATION;
            $trx->save();
        }
        // Update payment
        $update_status = Payment_telmed::where('trx_no', $faspay_request['bill_no'])
                    ->update([
                        'pay_status'    => ($faspay_request['payment_status_code']==2)?Payment_telmed::STS_CODE_PAID:$faspay_request['payment_status_code'], 
                        'pay_message'   => ($faspay_request['payment_status_code']==2)?Payment_telmed::STS_PAID:$faspay_request['payment_status_desc']
                    ]);
        return self::showResponse("00", $faspay_request);
    }
    public function showResponse($response_code, $request){
        $data = [
            "response"=>"Payment Notification",
            "trx_id"=> $request['trx_id'],
            "merchant_id"=> $request['merchant_id'],
            "merchant"=> $request['merchant'],
            "bill_no"=> $request['bill_no'],
            "response_code"=> $response_code,
            "response_desc"=> $request['payment_status_desc'],
            "response_date"=> date('Y-m-d H:i:s')
        ];
        $response = json_encode($data);
        Helper::LogFaspay('info', 'faspay-hook-response', $response);
        return $response;
    }
    public function insertFaspayLog($request){
        return Faspay_log::Create($request);
    }
    public function insertPostData($request){
        return Payment_telmed::Create($request);
    }
    public function getPaymentChannel(){
        // disable payment method va
        //return [];
        $result = [];
        $channel = self::getChannelFaspay();
        if(!isset($channel->response_code) || !isset($channel->payment_channel) || $channel->response_code != '00'){
            throw new Exception("Failed get channel list to faspay");
        }
        $payment_channel = collect($channel->payment_channel);
        foreach (self::paymentChannelList() as $key => $val) {
            $chnl = $payment_channel->where('pg_code', $key);
            if(!$chnl->isEmpty()){
                $result[] = [
                    "code"  => $key,
                    "name"  => $val['label'],
                    "image" => $val['image'],
                ];
            }
        }
		return $result;
    }
    public function getInstruction($code){
        $result = [];
        $result = collect($this->instructionList())->get($code);
        if(is_null($result)){
            throw new Exception("Payment Channel is not list");
        }
		return $result;

    }
    public function generateSignature($bill_no=""){
		$user_id = env('FASPAY_USERNAME');
		$password = env('FASPAY_PASSWORD');
		$signature = sha1(md5($user_id.$password.$bill_no));
		return $signature;
	}
    public function generateSignaturePayment($bill_no, $status){
		$user_id = env('FASPAY_USERNAME');
		$password = env('FASPAY_PASSWORD');
		$signature = sha1(md5($user_id.$password.$bill_no.$status));
		return $signature;
	}
    public static function paymentStatus($code)
    {
        $arr = [
            "0" => "Unprocessed",
            "1" => "In Process",
            "2" => "Payment Success",
            "3" => "Payment Failed",
            "4" => "Payment Reversal",
            "5" => "No bills found",
            "7" => "Payment Expired",
            "8" => "Payment Cancelled",
            "9" => "Unknown",
        ];
        return ($arr[$code])??"-";
    }
    public static function responseCode($code)
    {
        $arr = [
            "00" => "Success",
            "03" => "Invalid Merchant",
            "13" => "Invalid Amount",
            "14" => "Invalid Order",
            "17" => "Order Cancelled by Merchant/Customer",
            "18" => "Invalid Customer or MSISDN is not found",
            "21" => "Subscription is Expired",
            "30" => "Format Error",
            "40" => "Requested Function not Supported",
            "54" => "Order is Expired",
            "55" => "Incorrect User/Password",
            "56" => "Security Violation (from unknown IP-Address)",
            "63" => "Not Active / Suspended",
            "66" => "Internal Error",
            "80" => "Payment Was Reversal",
            "81" => "Already Been Paid",
            "82" => "Unregistered Entity",
            "83" => "Parameter is mandatory",
            "84" => "Unregistered Parameters",
            "85" => "Insufficient Paramaters",
            "96" => "System Malfunction",
        ];
        return ($arr[$code])??"-";
    }
    public function instructionList (){
        $sql = "SELECT
            channel_code::varchar(3) code,
            CASE
                WHEN method = 'ATM' THEN 'atm'
                WHEN method = 'Mobile Banking' THEN 'mobile'
                WHEN method = 'Internet Banking' THEN 'internet'
                ELSE ''
            END method,
            guide content
        FROM app_faspay_channel";
	    return collect($this->conn->select(DB::raw($sql)))
		    ->groupBy('code')->mapWithKeys(function($v, $k) {
            return [$k => $v];
        })->toArray();

        //deprecated
        $data = [
            // permata
            "402"   => [
                [
                    "method" => "atm",
                    "content" => "Input kartu ATM dan PIN Anda \n Pilih Menu Transaksi Lainnya \n Pilih Pembayaran \n Pilih Pembayaran Lain-lain \n Pilih Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX \n Select Benar \n Select Ya \n Ambil bukti bayar anda \n Selesai",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login Mobile Banking \n Pilih Pembayaran Tagihan \n Pilih Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX sebagai No. Virtual Account \n Input Nominal misal. 10000 \n Klik Kirim \n Input Token \n Klik Kirim \n Bukti bayar akan ditampilkan \n Selesai",
                ],
                [
                    "method" => "internet",
                    "content" => "Login Internet Banking \n Pilih Pembayaran Tagihan \n Pilih Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX sebagai No. Virtual Account \n Input Nominal misal. 10000 \n Klik Kirim \n Input Token \n Klik Kirim \n Bukti bayar akan ditampilkan \n Selesai",
                ],
            ],
            // maybank
            "408"   => [
                [
                    "method" => "atm",
                    "content" => "Masukkan PIN ATM Anda \n Pilih Menu Pembayaran/ Top Up Pulsa \n Pilih Menu Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX \n Pilih Benar \n Pilih Ya \n Ambil Bukti Bayar Anda \n Transaksi Selesai",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login Aplikasi M2U Menggunakan Fingerprint Atau Masukkan Password \n Pilih Transfer \n Pilih Virtual Account \n Pilih Sumber Tabungan \n Masukkan Nomor Virtual Account misal. 35359XXXXXXX, Klik Lanjut \n Masukkan Jumlah Transfer, Klik Proses \n Klik Konfirmasi & Minta TAC \n Masukkan SMS Token/TAC \n Klik OK \n Transaksi Selesai",
                ],
                [
                    "method" => "internet",
                    "content" => "Login Internet Banking \n Pilih Rekening dan Transaksi \n Pilih Maybank Virtual Account \n Pilih Sumber Tabungan \n Input Nomor Virtual Account, misal. 35359XXXXXXX \n Input Nominal, misal. 10000 \n Klik Submit \n Input SMS Token \n Bukti bayar ditampilkan",
                ],
            ],
            // bca
            "702"   => [
                [
                    "method" => "atm",
                    "content" => "Input kartu ATM dan PIN Anda \n Pilih Menu Transaksi Lainnya \n Pilih Transfer \n Pilih Ke rekening BCA Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX \n Pilih Benar \n Pilih Ya \n Ambil bukti bayar Anda \n Selesai",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login Mobile Banking \n Pilih m-Transfer \n Pilih BCA Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX sebagai No. Virtual Account \n Klik Send \n Informasi Virtual Account akan ditampilkan \n Klik OK \n Input PIN Mobile Banking \n Bukti bayar ditampilkan \n Selesai",
                ],
                [
                    "method" => "internet",
                    "content" => "Login Internet Banking \n Pilih Transaksi Dana \n Pilih Transfer Ke BCA Virtual Account \n Input Nomor Virtual Account, misal. 35359XXXXXXX sebagai No. Virtual Account \n Klik Lanjutkan \n Input Respon KeyBCA Appli 1 \n Klik Kirim \n Bukti bayar ditampilkan \n Selesai",
                ],
            ],
            // danamon
            "708"   => [
                [
                    "method" => "atm",
                    "content" => "Input PIN ATM Anda \n Pilih Menu Pembayaran >>> Virtual Account \n Masukan nomor Virtual Account, misal. 35359XXXXXXX \n Masukkan Nominal \n Pada layar konfirmasi pembayaran, pastikan transaksi sudah benar -> pilih Ya untuk memproses transaksi",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login pada Aplikasi D-Mobile \n Pilih menu Virtual Account \n Masukan 16 digit nomor virtual account, misal. 35359XXXXXXX \n Masukan Nominal \n Pada layar konfirmasi pembayaran, pastikan transaksi sudah benar -> pilih Ya untuk memproses transaksi.",
                ],
                [
                    "method" => "internet",
                    "content" => "Masuk ke menu transfer ke bank lain \n Pilih transfer online \n Pilih Bank tujuan, Bank Danamon \n Masukkan 16 digit nomor Virtual Account, misal. 35359XXXXXXX \n Masukkan nominal pembayaran \n Pada layar konfirmasi pembayaran, harap pastikan nama tujuan dan nominal transaksi sudah tepat \n Konfirmasi pembayaran",
                ],
            ],
            // bri
            "800"   => [
                [
                    "method" => "atm",
                    "content" => "Input kartu ATM dan PIN Anda \n Pilih Menu Transaksi Lain \n Pilih Menu Pembayaran \n Pilih Menu Lain-lain \n Pilih Menu BRIVA \n Masukkan Nomor Virtual Account, misal. 35359XXXXXXXXXXX \n Pilih Ya \n Ambil bukti bayar anda \n Selesai",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login BRI Mobile \n Pilih Mobile Banking BRI \n Pilih Menu Pembayaran \n Pilih Menu BRIVA \n Masukkan Nomor Virtual Account, misal. 35359XXXXXXXXXXX \n Masukkan Nominal misal. 10000 \n Klik Kirim \n Masukkan PIN Mobile \n Klik Kirim \n Bukti bayar akan dikirim melalui sms \n Selesai",
                ],
                [
                    "method" => "internet",
                    "content" => "Login Internet Banking \n Pilih Pembayaran \n Pilih BRIVA \n Masukkan Nomor Virtual Account, misal. 35359XXXXXXXXXXX \n Klik Kirim \n Masukkan Password \n Masukkan mToken \n Klik Kirim \n Bukti bayar akan ditampilkan \n Selesai",
                ],
            ],
            // bni
            "801"   => [
                [
                    "method" => "atm",
                    "content" => "Masukkan Kartu Anda. \n Pilih Bahasa \n Masukkan PIN ATM Anda. \n Pilih 'Menu Lainnya'. \n Pilih 'Transfer'. \n Pilih Jenis rekening yang akan Anda gunakan (Contoh; 'Dari Rekening Tabungan'). \n Pilih 'Virtual Account Billing' \n Masukkan Nomor Virtual Account Anda (contoh: 35359XXXXXXXXXXX).  \n Tagihan yang harus dibayarkan akan muncul pada layar konfirmasi. \n Konfirmasi, apabila telah sesuai, lanjutkan transaksi. \n Transaksi Anda telah selesai.",
                ],
                [
                    "method" => "mobile",
                    "content" => "Akses BNI Mobile Banking dari handphone kemudian masukkan user ID dan password. \n Pilih menu “Transfer”. \n Pilih menu “Virtual Account Billing” kemudian pilih rekening debet. \n Masukkan Nomor Virtual Account Anda (contoh: 35359XXXXXXXXXXX) pada menu “input baru”. \n Tagihan yang harus dibayarkan akan muncul pada layar konfirmasi. \n Konfirmasi transaksi dan masukkan Password Transaksi. \n Pembayaran Anda Telah Berhasil",
                ],
                [
                    "method" => "internet",
                    "content" => "Ketik alamat https://ibank.bni.co.id kemudian klik “Enter”. \n Masukkan User ID dan Password. \n Pilih menu “Transfer”. \n Pilih “Virtual Account Billing”. \n Kemudian masukan Nomor Virtual Account Anda (contoh: 35359XXXXXXXXXXX) yang hendak dibayarkan. Lalu pilih rekening debet yang akan digunakan. Kemudian tekan ‘’lanjut’’. \n Kemudin tagihan yang harus dibayarkan akan muncul pada layar konfirmasi. \n Masukkan Kode Otentikasi Token. \n Pembayaran Anda telah berhasil",
                ],
            ],
            // mandiri
            "802"   => [
                [
                    "method" => "atm",
                    "content" => "Input Kartu ATM dan PIN Anda \n Pilih Menu Bayar/Beli \n Pilih Multi Payment \n Input 35359 sebagai Kode biller \n Input Nomor Virtual Account, Misal. 35359XXXXXXXXXXX sebagai Kode Bayar \n Pilih Benar \n Layar akan menampilkan Kode Bayar dan Data Pembayaran, kemudian tekan '1' Jika data telah sesuai \n Klik Ya untuk melakukan pembayaran \n Selesai",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login New Livin by Mandiri \n Pilih Menu Bayar \n Pilih E-Commerce \n Cari NICEPAY sebagai Penyedia Jasa \n Input Nomor Virtual Account, Misal. 35359XXXXXXXXXXX sebagai Kode Bayar \n Pilih Lanjut \n Layar akan menampilkan Kode Bayar dan Data Pembayaran Jika data telah sesuai \n Input MPIN New Livin, Klik OK \n Selesai",
                ],
                [
                    "method" => "internet",
                    "content" => "Login Internet Banking \n Pilih Pembayaran \n Pilih Multi Payment \n Input NICEPAY sebagai Penyedia Jasa \n Input Nomor Virtual Account, misal. 35359XXXXXXXXXXX \n Klik Tambah Sebagai Nomor Baru \n Input Nominal \n Pilih pada kolom jumlah \n Klik Konfirmasi \n Input Kode Challenge yang dikirim ke ponsel anda ke dalam 'Token' \n Klik OK \n Bukti bayar ditampilkan \n Selesai",
                ],
            ],
            // cimb
            "825"   => [
                [
                    "method" => "atm",
                    "content" => "Input kartu ATM dan PIN Anda \n Pilih Menu Pembayaran \n Pilih Menu Lanjut \n Pilih Menu Virtual Account \n Masukkan Nomor Virtual Account, misal. 35359XXXXXXXXXXX \n Pilih Proses \n Data Virtual Account akan ditampilkan \n Pilih Proses \n Ambil bukti bayar anda \n Selesai",
                ],
                [
                    "method" => "mobile",
                    "content" => "Login OCTO Mobile \n Pilih Menu Transfer \n Pilih Menu Transfer ke CIMB Niaga Lain \n Pilih Sumber Dana yang akan digunakan \n Masukkan Nomor Virtual Account, misal. 35359XXXXXXXXXXX \n Masukkan Nominal misal. 10000 \n Klik Lanjut \n Data Virtual Account akan ditampilkan \n Masukkan PIN Mobile \n Klik Konfirmasi \n Bukti bayar akan dikirim melalui sms \n Selesai",
                ],
                [
                    "method" => "internet",
                    "content" => "Login Internet Banking \n Pilih Bayar Tagihan \n Rekening Sumber - Pilih yang akan Anda digunakan \n Jenis Pembayaran - Pilih Virtual Account \n Untuk Pembayaran - Pilih Masukkan Nomor Virtual Account \n Nomor Rekening Virtual, misal. 35359XXXXXXXXXXX \n Isi Remark Jika diperlukan \n Klik Lanjut \n Data Virtual Account akan ditampilkan \n Masukkan mPIN \n Klik Kirim \n Bukti bayar akan ditampilkan \n Masukkan mPIN \n Klik Kirim \n Bukti bayar akan ditampil",
                ],
            ],
        ];
        return $data;

    }
    public static function paymentChannelList (){
        $data = [
            "402"   => [
                "label" => "Permata Virtual Account / PermataNet",
                "image" => url('assets/img/permata.png'),
            ],
            "408"   => [
                "label" => "Maybank Virtual Account",
                "image" => url('assets/img/maybank.png'),
            ],
            "702"   => [
                "label" => "BCA Virtual Account",
                "image" => url('assets/img/bca.png'),
            ],
            "708"   => [
                "label" => "Danamon Virtual Account",
                "image" => url('assets/img/danamon.png'),
            ],
            "800"   => [
                "label" => "BRI Virtual Account",
                "image" => url('assets/img/bri.png'),
            ],
            "801"   => [
                "label" => "BNI Virtual Account",
                "image" => url('assets/img/bni.jpg'),
            ],
            "802"   => [
                "label" => "Mandiri Virtual Account",
                "image" => url('assets/img/mandiri.png'),
            ],
            "825"   => [
                "label" => "CIMB Virtual Account",
                "image" => url('assets/img/cimb.png'),
            ],
        ];
        return $data;

    }
    
        // "virtual_account" => [
            
            // "718"   => "BC Virtual Account",
            // "818"   => "Sinarmas Virtual Account",
        // ],
        /*
        "internet_banking" => [
            "402"   => "PermataNet",
            "405"   => "BCA KlikPay",
            "700"   => "Octo Clicks",
            "701"   => "Danamon Online Banking",
        ],
        "online_debit" => [
            "810"   => "B-Secure",
            "714"   => "BRI Direct Debit",
        ],
        "online_credit" => [
            "709"   => "Kredivo",
            "721"   => "BRI Ceria",
            "807"   => "Akulaku",
            "820"   => "Indodana",
        ],
        "emoney" => [
            "302"  => "LinkAja",
            "716"  => "LinkAja AppLink",
            "704"  => "Sakuku",
            "711"  => "ShopeePay QRIS",
            "713"  => "ShopeePay Jump App",
            "720"  => "OVO Tokenize",
            "722"  => "DANA Subscription",
            "812"  => "OVO",
            "819"  => "DANA",
        ],
        "retail" => [
            "706"   => "Indomaret Payment point",
            "707"   => "Alfagroup",
        ]
        */
    // ];
}
