<?php

namespace App\Repository;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller as BaseController;
use App\Models\User;
use Exception;
use Helper;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Library;
use Tymon\JWTAuth\Exceptions\JWTException;

class AuthManager extends BaseController
{
    public function me()
    {
        try {
            if(!$user = auth()->user()){
                $result = ["status"=>false,  "message" => 'Failed to get user data.'];
                return $result;
            }
        } catch (JWTException $e) {
            $result = ["status"=>false,  "message" => $e->getMessage()];
            return $result;
        }
        $result = ["status"=>true,  "message" => 'Success.', "data" => $user];
        return $result;
    }
    public function logout()
    {
        auth()->logout();
    }
    public function refresh()
    {
        try {
            if (!$token = auth()->refresh()) {
                $result = ["status"=>false,  "message" => 'Failed to create new token, please try again.'];
                return $result;
            }
        } catch (JWTException $e) {
            $result = ["status"=>false,  "message" => $e->getMessage()];
            return $result;
        }
        $result = ["status"=> true,"message" => [], "token"=>$token];
        return $result;
    }   

    public function getVersionSupport($platform, $version)
    {
        $sql = "SELECT status_update
        FROM app_version av
        WHERE app_platform = '%s' AND app_version = '%s'
        LIMIT 1";
        $sql = sprintf($sql, $platform, $version);

	try {
		$version = DB::connection('pgsql')->select($sql);
	} catch (\Exception $e) {
		// something err happen, just skip it
		return 'support';
	}

        // version is not registered yet
        if (count($version) == 0) return null;

        // version is not support anymore
        if ($version[0]->status_update == 'disabled') return null;

        // version is deprecated, skip it
        // if ($version[0]->status_update == 'deprecated') return null;

        return 'support';
    }
}
