<?php

namespace App\Providers;

use Validator;
use Illuminate\Routing\UrlGenerator;
use Illuminate\Support\ServiceProvider;
use App\Services\Validator\ValidatorManager;
use App\Services\Validator\ValidatorManagerInterface;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(ValidatorManagerInterface::class, function () {
            return new ValidatorManager;
        });
        $this->app->singleton(UserManagerInterface::class, function () {
            return new ValidatorManager;
        });

        if (env('APP_ENV', 'local') == 'production') {
            $this->app['request']->server->set('HTTPS', true);
        }
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(UrlGenerator $url)
    {
        Validator::extendImplicit('single_array', function($attribute, $value) {
            if (is_array($value) === false) {
                return false;
            }

            foreach($value as $v) {
                if (is_array($v)) {
                    return false;
                }
            }
            
            return true;
        }, 'the value is must single array or empty array');

        if (env('APP_ENV', 'local') == 'production') {
            $url->formatScheme('https');
        }
        
        config(['app.locale' => 'id']);
        \Carbon\Carbon::setLocale('id');
    }
}
