<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trx_history_telmed extends Model
{
    use HasFactory;
    const STS_PENDING               = 'pending';
    const STS_WAIT_PAYMENT          = 'waiting_payment';
    const STS_WAIT_CONFIRMATION     = 'waiting_confirmation';
    const STS_WAIT_APPOINTMNET      = 'waiting_appointment';
    const STS_ONGOING               = 'ongoing';
    const STS_REJECT                = 'reject';
    const STS_RESCHEDULE            = 'rescheduled';
    const STS_DONE                  = 'done';
    const STS_CANCEL                = 'cancel';
    const STS_REFUND                = 'refund';

    const STS_TEBUS_PENDING         = 'pending';
    const STS_TEBUS_PROCESS         = 'process';
    const STS_TEBUS_DONE            = 'done';
    const STS_TEBUS_CANCEL          = 'cancel';

    
    const STS_CODE_DONE                 = '00';
    const STS_CODE_PENDING              = '01';
    const STS_CODE_WAIT_PAYMENT         = '02';
    const STS_CODE_WAIT_CONFIRMATION    = '03';
    const STS_CODE_WAIT_APPOINTMNET     = '04';
    const STS_CODE_ONGOING              = '05';
    const STS_CODE_REJECT               = '06';
    const STS_CODE_RESCHEDULE           = '07';
    const STS_CODE_CANCEL               = '08';
    const STS_CODE_REFUND               = '09';

    protected $connection= 'pgsql';
    protected $table = "trx_history_telmed";
    protected $fillable = [
        'id_user',
        'id_dokter',
        'trx_no',
        'service',
        'company_name',
        'card_number',
        'cust_name',
        'patient_type',
        'birth_date',
        'phone',
        'email',
        'gender',
        'nik',
        'address',
        'date_consul',
        'time_consul',
        'trx_date',
        'trx_expired',
        'trx_amount',
        'trx_status',
        'trx_status_code',
        'pay_method',
        'link_meet',
        'note',
        'location_lat',
        'location_lon',
        'meta_trx_data',
        'is_reminder',
        'is_send_result',

        'taken',
        'ekspedisi',
        'no_resi',
        'link_tracking',

        'regency_id',
        'apotek_id',

        'trx_no_med',
        'status_redeem',
        'time_redeem',
        'meta_result',

        'is_send_faspay_telmed',
        'is_send_faspay_prescription',
    ];

    public function soap()
    {
        return $this->hasOne(Soap_telmed::class, 'trx_no', 'trx_no');
    }

    public function icd10()
    {
        return $this->hasMany(Icd10_telmed::class, 'trx_no', 'trx_no');
    }

    public function recipe()
    {
        return $this->hasMany(Recipe_telmed::class, 'trx_no', 'trx_no');
    }
    public function payment()
    {
        return $this->hasOne(Payment_telmed::class, 'trx_no', 'trx_no')->latestOfMany();
    }
    public function paymentMedicine()
    {
        return $this->hasOne(Payment_telmed::class, 'trx_no', 'trx_no_med')->latestOfMany();
    }
    public function attachment()
    {
        return $this->hasMany(Attachment_telmed::class, 'trx_no', 'trx_no');
    }
}
