<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment_telmed extends Model
{
    use HasFactory;
    const STS_PAID             = 'paid';
    const STS_PENDING          = 'pending';
    const STS_CANCEL           = 'cancel';

    const STS_CODE_PAID          = '00';
    const STS_CODE_PENDING       = '01';
    const STS_CODE_CANCEL        = '02';

    const TYPE_TELEMEDICINE         = 'telemedicine'; //default
    const TYPE_PRESCRIPTION         = 'prescription';
    
    protected $connection= 'pgsql';
    protected $table = "payment_telmed";
    protected $fillable = [
        'trx_no',
        'invoice_no',
        'pay_method',
        'pay_date',
        'pay_exp_date',
        'pay_amount',
        'pay_status',
        'pay_message',
        'post_data_response',
        'type_payment',
    ];
    protected $casts = [
        'post_data_response' => 'json',
    ];
}
