<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendEcard extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($user, $data)
    {
        $this->user = $user;
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $this->subject('Kartu Digital Medika Plaza')
                    ->view('mail.sendEcard', ['user' => $this->user, 'data' => $this->data]);
        $this->attach($this->data['ecard']);
        // foreach ($this->data['file'] as $file){
        // }
        return $this;
    }
}
