<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ForgotPasswordWeb extends Mailable
{
    use Queueable, SerializesModels;
    protected $link;
    protected $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($link, $data)
    {
        $this->link = $link;
        $this->data = $data;
    }
    

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Medika Plaza - Reset Password')
                    ->view('mail.forgotWeb', ['link' => $this->link, 'user' => $this->data]);
    }
}
