<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Helper;
use Illuminate\Queue\SerializesModels;

class FinishAppointment extends Mailable
{
    use Queueable, SerializesModels;
    protected $link;
    protected $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {  
        Helper::LogDashboard("warning", "Send email request", ["subject" =>$this->data['subject'], "data" => $this->data]);
        $email = $this->subject($this->data['subject'])
                    ->view('mail.appointmentFinish', ['data' => $this->data]);
        if(isset($this->data['report']) || !is_null($this->data['report']) || $this->data['report'] != false || $this->data['report'] != 0){
            Helper::LogDashboard("warning", "Report result", ["report" =>$this->data['report']]);
            $email->attachFromStorageDisk('report', $this->data['report']);
        }            
        return $email;            
    }
}
