<?php

namespace App\Jobs;

use Exception;
use Carbon\Carbon;
use App\Models\Notifikasi;
use App\Models\Notifikasi_web;
use App\Services\Firebase;
use Illuminate\Bus\Queueable;
use App\Repository\QiscusManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use App\Repository\TelemedicineManager;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobTelmedReminder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $row;
    public $firebase;
    public $REPO;
    public $qiscus;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try{
            date_default_timezone_set("Asia/Jakarta");
            $row = $this->row;
            $this->firebase    = new Firebase();
            $this->REPO         = new TelemedicineManager();
            $this->qiscus       = new QiscusManager();
            
            $time_now   =  Carbon::now()->toTimeString();
            $now = date("Y-m-d");
            $status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
            $trx = Trx_history_telmed::whereDate('date_consul', '=' , $now)
                    ->where('trx_status', $status)->first();
            if(is_null($trx)){
                throw new Exception("Transaction not found");
            }

            $time_consul_30 = Carbon::parse($row->time_consul)->subMinutes(30)->toTimeString();
            $time_consul_10 = Carbon::parse($row->time_consul)->subMinutes(10)->toTimeString();
            $reminder = $row->is_reminder == 0 || $row->is_reminder == 2;
            if($time_now >= $time_consul_10 && $reminder){
                Log::channel('schedule_trx')->info("Transaction $row->trx_no to set reminder 10 minutes");
                // Send notif
                try{
                    $reminder  = 10;
                    $update_status = Trx_history_telmed::where('trx_no', $row->trx_no)->update(['is_reminder' => 1]);
                    
                    self:: pushNotification($row,$reminder);
                }catch(Exception $e){
                    Log::channel('schedule_trx')->info("$row->trx_no Appointment reminder 10 menit failed send notification");
                }
                
            }else {
                $reminder = $row->is_reminder == 0;
                // Set reminder 30 menit
                if($time_now >= $time_consul_30 && $reminder){
                    Log::channel('schedule_trx')->info("Transaction $row->trx_no to set reminder 30 minutes");
                    // Send notif
                    try{
                        $reminder  = 30;
                        $update_status = Trx_history_telmed::where('trx_no', $row->trx_no)->update(['is_reminder' => 2]);
                        self:: pushNotification($row,$reminder);
                    }catch(Exception $e){
                        Log::channel('schedule_trx')->info("$row->trx_no Appointment reminder 30 menit failed send notification");
                    }
                }
            }
        }catch(Exception $e){
            report($e);
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
    public function pushNotification($data, $reminder){
        
        $where ="";
        $base_url = config('services.medikaplaza.web_telmed');

        $where .= "AND p.id = '" . $data->id_dokter . "'";
        $get_doktor  = $this->REPO->listDokter($where);

        $doktor = (isset($get_doktor[0]->name))?$get_doktor[0]->name:"-";
        $message = "Appointment $data->trx_no with $doktor Will Be Started in $reminder Minutes";
        $message_doktor = "Appointment $data->trx_no with $data->cust_name Will Be Started in $reminder Minutes";

        // Send notif wa
        self::sendNotifWaReminder($data, $doktor);

        if(!is_null($data->id_user)){
            $user = $this->firebase->getUserToken($data->id_user);
            $notif = [
                'id_user'       => $data->id_user,
                'user'          => $user,
                'label'         => 'reminder',
                'type'          => 'appointment',
                'text'          => $message,
            ];
            // //**Push notification */
            if(!!$notif){
                $this->firebase->pushNotif($notif);
            }
        }
        // insert notif web
        $arr = [
			'id_user'       => $data->id_user,
			'id_dokter'     => $data->id_dokter,
			'label'         => 'reminder',
			'type'          => 'appointment',
			'text'          => $message_doktor,
        ];
        Notifikasi_web::create($arr);
        // notif email
        if(!is_null($data->email)){
            $to = $data->email;
            $url = sprintf('%s/%s', $base_url, "guest/landing?c=".$data->trx_no);
            $data = [
                'id_user'           => $data->id_user,
                'type'              => "reminder",
                'reminder'          => $reminder,
                'subject'           => "Appointment Will Be Started in $reminder Minutes",
                'cust_name'         => $data->cust_name,
                'dokter_name'       => $doktor,
                'url'               => $url,
            ];
            $send_email = $this->REPO->sendEmail($to, $data, $data['type']);
            Log::channel('schedule_trx')->info("$data->trx_no Appointment Will Be Started in $reminder Minutes");
        }

    }
    public function sendNotifWaReminder($data, $dokter_name){
        $headers = [
            "Qiscus-App-Id"     => env('QISCUS_APP_ID'),
            "Qiscus-Secret-Key" => env('QISCUS_SECRET_KEY'),
            "Content-Type"      => 'application/json'
        ];
        $to = $data->phone;
        $cust_name = $data->cust_name;
        $dokter_name = $dokter_name;
        $date_consul = $data->date_consul;
        $time_consul = $data->time_consul;

        $base_url = config('services.medikaplaza.web_telmed');
        $url = sprintf('%s/%s', $base_url, "guest/landing?c=".$data->trx_no);
        $request = [];
        // Cek patient type
        if($data->patient_type == 'non_member'){
            $template = "telemedicine_linkconsul";
            $parameters = [
                [
                    "type"  => "text",
                    "text"  => $dokter_name,
                ],[
                    "type"  => "text",
                    "text"  => $date_consul,
                ],[
                    "type"  => "text",
                    "text"  => $time_consul,
                ],[
                    "type"  => "text",
                    "text"  => $url,
                ]
            ];
            // Parameter header
            $parameter_header = [
                [
                    "type"  => "text",
                    "text"  => $cust_name,
                ]
            ];
            
            $request = [
                "to"    => $to,
                "type"    => "template",
                "template"    => [
                    "namespace" => "0759bbc6_df4f_4bbb_a533_94beea4fb86c",
                    "name"      => $template,
                    "language"  => [
                        "policy"  => "deterministic",
                        "code"    => "id",
                    ],
                    "components"    => [
                        [
                            "type"          => "header",
                            "parameters"    => $parameter_header,
                        ],
                        [
                            "type"          => "body",
                            "parameters"    => $parameters,
                        ]
                    ]
                ]
            ];

        }
        else{
            $template = "reminder_telemedicine";
            $parameters = [
                [
                    "type"  => "text",
                    "text"  => $cust_name,
                ],[
                    "type"  => "text",
                    "text"  => $dokter_name,
                ],[
                    "type"  => "text",
                    "text"  => $date_consul,
                ],[
                    "type"  => "text",
                    "text"  => $time_consul,
                ]
            ];
            
            $request = [
                "to"    => $to,
                "type"    => "template",
                "template"    => [
                    "namespace" => "0759bbc6_df4f_4bbb_a533_94beea4fb86c",
                    "name"      => $template,
                    "language"  => [
                        "policy"  => "deterministic",
                        "code"    => "id",
                    ],
                    "components"    => [
                        [
                            "type"          => "body",
                            "parameters"    => $parameters,
                    ]
                    ]
                ]
            ];
        }
        $payload = json_encode($request, true);
        $res = $this->qiscus->qiscus($headers,$payload);
        Log::channel('schedule_trx')->info("$data->trx_no Appointment reminder Success send Wa notification");
        return $res;
    }
}
