<?php

namespace App\Jobs;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobTelmedOngoing implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $row;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $row = $this->row;
        $now = date("Y-m-d");

        $status_ongoing = Trx_history_telmed::STS_ONGOING;
        $status_code_ongoing = Trx_history_telmed::STS_CODE_ONGOING;
        $time_now   =  Carbon::now()->toTimeString();

        $time_consul_10 = Carbon::parse($row->time_consul)->subHours(1)->toTimeString();
        // Set link generate 1 jam sebelum
        if($time_now >= $time_consul_10 && is_null($row->link_meet)){
            Log::channel('schedule_trx')->info("$row->trx_no set to link generate");
            $update_status = Trx_history_telmed::where('trx_no', $row->trx_no)
                                ->where('date_consul', '=' , $now)
                                ->where('trx_status', Trx_history_telmed::STS_WAIT_APPOINTMNET)
                                ->update([
                                    'link_meet'     => str_replace(' ', '', date('Ymd')."-".$row->trx_no)
                                ]);
        }
        if($time_now >= $row->time_consul){
            Log::channel('schedule_trx')->info("$row->trx_no set to transaction ongoing");
            $update_status = Trx_history_telmed::where('trx_no', $row->trx_no)
                                ->where('date_consul', '=' , $now)
                                ->where('trx_status', Trx_history_telmed::STS_WAIT_APPOINTMNET)
                                ->update([
                                    'trx_status' => $status_ongoing, 
                                    'trx_status_code' => $status_code_ongoing,
                                ]);
        }
    }
}
