<?php

namespace App\Jobs;

use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobTelmedDone implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $row;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $row = $this->row;

        $status_done = Trx_history_telmed::STS_DONE;
        $status_code_done = Trx_history_telmed::STS_CODE_DONE;
        $now = date("Y-m-d");
        $time_now   =  Carbon::now()->toTimeString();
        Log::channel('schedule_trx')->info("$row->trx_no set to done job request");

        $time_consule   = Carbon::parse($row->time_consul)->addMinutes(15)->toTimeString();
        if($time_now >= $time_consule){
            Log::channel('schedule_trx')->info("$row->trx_no set to transaction done send to queue");
            $update_status = Trx_history_telmed::where('trx_no', $row->trx_no)
                        ->where('date_consul', '=' , $now)
                        ->where('trx_status', Trx_history_telmed::STS_ONGOING)
                        ->update(['trx_status' => $status_done, 'trx_status_code' => $status_code_done]);
            if($update_status){
                Log::channel('schedule_trx')->info("$row->trx_no set to done job finish");
            }
        }
        
    }
}
