<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use App\Models\Trx_history_telmed;
use App\Repository\MPOneManager;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobTelmedCancel implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $row;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");

        $trx_no = $this->row->trx_no;

        $now = date("Y-m-d H:i:s");
        $status_cancel = Trx_history_telmed::STS_CANCEL;
        $status_code_cancel = Trx_history_telmed::STS_CODE_CANCEL;
        Log::channel('schedule_trx')->info("$trx_no set to cancel job request");

        $update_status = Trx_history_telmed::where('trx_no', $trx_no)
                        ->where('trx_expired', '<=' , $now)
                        ->where('trx_status', Trx_history_telmed::STS_PENDING)
                        ->update(['trx_status' => $status_cancel, 'trx_status_code' => $status_code_cancel]);
        if($update_status){
            // try to cancel at mpone
            $trx = Trx_history_telmed::where('trx_no', $trx_no)->first();
            if ($trx->patient_type == 'member') {
                $repoMpOne    = new MPOneManager();
                $repoMpOne->declineGlV2($trx);
                Log::channel('schedule_trx')->info("$trx_no set to decline gl");
            }
            Log::channel('schedule_trx')->info("$trx_no set to cancel job finish");
        }
    }
}
