<?php

namespace App\Jobs;

use Exception;
use Carbon\Carbon;
use Illuminate\Bus\Queueable;
use App\Repository\MPOneManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use App\Repository\TelemedicineManager;
use Illuminate\Support\Facades\Storage;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobSendResultEmail implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $row;
    public $telmed;
    public $repoMpOne;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try{
            $row = $this->row;
            $this->telmed = new TelemedicineManager();
            $this->repoMpOne    = new MPOneManager();
            
            $trx = Trx_history_telmed::where('is_send_result', '=' , false)
                    ->where('trx_no', $row->trx_no)
                    ->where('trx_status', Trx_history_telmed::STS_DONE)
                    ->first();
            if(is_null($trx)){
                throw new Exception("Transaction not found");
            }
            
            $to = (!is_null($row->email))?$row->email:"";
            if(!is_null($to)){
                $icd10 = [];
                $recipe = [];
                $where = "AND p.id = '" . $row->id_dokter . "'";
                $dokter  = $this->telmed->listDokter($where);
                // Get recipe
                $recipes = $row->recipe;
                if(count($recipes)>0){
                    $recipe = collect($recipes)->map(function ($res){
                        $medicine_name = $this->telmed->listObat(" AND pt.id = $res->producttemp_id");
                        $map = [
                            "product_id"    => $res->product_id,
                            "medicine_name" => $medicine_name->first()->obat_name??"-",
                            "signa"         => $res->signa??"-",
                            "remarks"       => $res->remarks??"-",
                            "qty"           => $res->qty,
                        ];
                        return $map;
                    })->values()->toArray();
                }
                $icd = $row->icd10;
                // Get Icd10
                $icd10 = collect($icd)->map(function ($res){
                    $where = "AND dd.id = $res->icd10_id";
                    $icd10_name = $this->telmed->getIcd($where);
                    $map = [
                        "icd10_id" => $res->icd10_id,
                        "icd10_name" => $icd10_name->first()->name??"-",
                        "case_type" => $res->case_type,
                        "diagnostic_type" => $res->diagnostic_type
                    ];
                    return $map;
                })->values()->toArray();
                $report = self::getReport($row->trx_no);
                $data = [
                    'type'              => "finish",
                    'subject'           => "Appointment Finished",
                    'soap'              => $row->soap->toArray(),
                    'icd10'             => $icd10,
                    'recipe'            => $recipe,
                    'report'            => (isset($report))?$report:null,
                    'cust_name'         => $row->cust_name,
                    'dokter_name'       => $dokter->first()->name??"-",
                ];
                $d = json_encode($data);
                Log::channel('schedule_trx')->info("$row->trx_no data request send email - [$d]");
                try{
                    if($report == false ){
                        Log::channel('schedule_trx')->info("$row->trx_no Send email result is empty");
                        return ;
                    }
                    Log::channel('schedule_trx')->info("$row->trx_no Send email result request");
                    $send_email = $this->telmed->sendEmail($to, $data, $data['type']);
                    if($send_email){
                        $update_status = Trx_history_telmed::where('trx_no', $row->trx_no)->update(['is_send_result' => true]);
                        Log::channel('schedule_trx')->info("$row->trx_no Success send email result");
                    }
                }catch(Exception $e){
                    Log::channel('schedule_trx')->error($e->getMessage());
                }
            }
        }catch(Exception $e){
            report($e);
            Log::channel('schedule_trx')->error($e->getMessage());
            return false;
        }
        
    }
    public function getReport($trx_no){
        try{
            $trx = Trx_history_telmed::where('trx_no',$trx_no)->first();
            if(is_null($trx)){
                Log::channel('schedule_trx')->info("$trx_no Report Transaction tidak ditemukan");
                return false;
            }
            $res = false;
            $file_name = "report_resep_".$trx_no.'.pdf';
            $result  = $this->repoMpOne->reportObatV2($trx);
            if(isset($result->ReportCopyResepTelemedicineResponse) && $result->ReportCopyResepTelemedicineResponse->response_code == '00'){
                $base64encodedstring = $result->ReportCopyResepTelemedicineResponse->base64;
                $store = Storage::disk('report')->put($file_name,base64_decode($base64encodedstring));
                if($store){
                    $res = $file_name;
                }
            }
            return $res;
        }catch(Exception $e){
            report($e);
            Log::channel('schedule_trx')->error($e->getMessage());
            return false;
        }
    }
}
