<?php

namespace App\Jobs;

use Exception;
use Carbon\Carbon;
use App\Models\Recipe_telmed;
use Illuminate\Bus\Queueable;
use App\Repository\MPOneManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobSendResult implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $row;
    public $repoMpOne;
    public $conn;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try{
            $row = $this->row;
            $this->repoMpOne   = new MPOneManager();
            if(config('services.medikaplaza.telemedicine_mode') == 'production'){
                $this->conn        = DB::connection('pgsql');
            }else{
                $this->conn        = DB::connection('stag_medika');
            }
            $status_done = Trx_history_telmed::STS_DONE;
            $trx = Trx_history_telmed::where('trx_status', $status_done)->where('trx_no', $row->trx_no)->first();
            if(is_null($trx)){
                throw new Exception("Transaction not found");
            }

            $time_now   =  Carbon::now()->toDateTimeString();
            $date_time_consul = $row->date_consul.' '.$row->time_consul ;
            if($row->patient_type == 'member' || $row->patient_type == 'retail'){
                $time_window   = Carbon::parse($date_time_consul)->addMinutes(40)->toDateTimeString();
            }else{
                $time_window   = Carbon::parse($date_time_consul)->addMinutes(25)->toDateTimeString();
            }
            
            if($time_now > $time_window){
                $sql = "SELECT mpone_log.trx_no,
                            mpone_log.is_success
                        FROM mpone_log
                        WHERE mpone_log.trx_no = '$row->trx_no' AND 
                            (
                                right(mpone_log.endpoint::text, 26) = 'update/result/telemedicine'::text OR 
                                right(mpone_log.endpoint::text, 26) = 'create/result/telemedicine'::text 
                            )
                            AND trx_no = '$row->trx_no'
                        ORDER BY mpone_log.id DESC
                        LIMIT 1";
                $data = $this->conn->select(DB::raw($sql));
                $result = collect($data);
                if($result->isEmpty()){
                    Log::channel('schedule_trx')->info("CRON | $row->trx_no send result to MPONE START");
                    if(is_null($row->id_user) || $row->id_user == ''){
                        // Via MPONE
                        $data = Trx_history_telmed::find($row->id);
                        $data->taken = 0;
                        $data->save();
                        $create_result = $this->repoMpOne->assignResultNonselfV2($data);
                        if(isset($create_result->CreateResultTelemedicineResponse->response_code) && $create_result->CreateResultTelemedicineResponse->response_code == '00'){
                            $recipe = Recipe_telmed::where('trx_no',$row->trx_no)->update(['taken' => 0]);
                        }
                        Log::channel('schedule_trx')->info("CRON | $row->trx_no send result non self payment to MPONE FINISH");
                    }else{
                        // Via Mobile
                        $data = Trx_history_telmed::find($row->id);
                        $data->taken = 0;
                        $data->save();
                        if($trx->status_redeem == Trx_history_telmed::STS_TEBUS_PROCESS){
                            $skip_row = true;
                            $add_time_redeem   = Carbon::parse($row->time_redeem)->addMinutes(15)->toDateTimeString();
                            if($time_now >= $add_time_redeem){
                                $skip_row = false;
                                $trx->status_redeem     = Trx_history_telmed::STS_TEBUS_CANCEL;
                                $trx->save();
                            }
                            if($skip_row){
                                return;
                            }

                        }
                        $create_result = $this->repoMpOne->assignResultSelfV2($data);
                        if(isset($create_result->CreateResultTelemedicineViaMobileResponse->response_code) && $create_result->CreateResultTelemedicineViaMobileResponse->response_code == '00'){
                            $recipe = Recipe_telmed::where('trx_no',$row->trx_no)->update(['taken' => 0]);
                            // $create_payment = $this->repoMpOne->faspay($data);
                        }
                        Log::channel('schedule_trx')->info("CRON | $row->trx_no send result self payment to MPONE FINISH");
                    }
                }
                
            }
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
        }
    }
}
