<?php

namespace App\Jobs;

use Exception;
use Carbon\Carbon;
use App\Models\Recipe_telmed;
use Illuminate\Bus\Queueable;
use App\Repository\MPOneManager;
use App\Models\Trx_history_telmed;
use App\Models\Payment_telmed;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

class JobSendFaspayMpone implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $row;
    public $repoMpOne;
    public $conn;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Trx_history_telmed $row)
    {
        $this->row = $row;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try{
            $row = $this->row;
            Log::channel('schedule_trx')->info("$row->trx_no send faspay mpone to queue");
            $this->repoMpOne   = new MPOneManager();
            if(config('services.medikaplaza.telemedicine_mode') == 'production'){
                $this->conn        = DB::connection('pgsql');
            }else{
                $this->conn        = DB::connection('stag_medika');
            }
            $status_done = Trx_history_telmed::STS_DONE;
            $trx = Trx_history_telmed::where('trx_status', $status_done)
                    ->whereIn('patient_type',['member','retail'])
                    ->where('trx_no', $row->trx_no)
                    ->whereNotNull('taken')
                    ->first();
            if(is_null($trx)){
                throw new Exception("Transaction not found");
            }

            $time_now   =  Carbon::now()->toDateTimeString();
            $date_time_consul = $row->date_consul.' '.$row->time_consul ;
            $time_window   = Carbon::parse($date_time_consul)->addMinutes(40)->toDateTimeString();

            // Cek api faspay
            $sql = "SELECT mpone_log.trx_no,
                            mpone_log.is_success
                        FROM mpone_log
                        WHERE 
                            mpone_log.trx_no = '$row->trx_no' 
                            AND right(mpone_log.endpoint::text, 20) = 'payment/telemedicine'::text
                        ORDER BY mpone_log.id DESC
                        LIMIT 1";
                    $data = $this->conn->select(DB::raw($sql));
                    $result = collect($data);

            if($result->isEmpty()){
                Log::channel('schedule_trx')->info("CRON | $row->trx_no send faspay to MPONE START");
                if(is_null($row->is_send_faspay_telmed) || $row->is_send_faspay_telmed == false){
                    $pay = Payment_telmed::where('trx_no', $row->trx_no)
                                    ->where('pay_message', Payment_telmed::STS_PAID)
                                    ->first();
                    if(!is_null($pay)){
                        $data = Trx_history_telmed::find($row->id);
                        if($row->taken == 0){
                            $create_payment = $this->repoMpOne->faspay($data);
                            // update faspay
                            $data->is_send_faspay_telmed = 1;
                            $data->save();
                            Log::channel('schedule_trx')->info("CRON | $row->trx_no send faspay to MPONE with taken $row->taken FINISH");
                        }
                        if($row->taken == 1){
                            if($time_now > $time_window){
                                $create_payment = $this->repoMpOne->faspay($data);
                                // update faspay
                                $data->is_send_faspay_telmed = 1;
                                $data->save();
                                Log::channel('schedule_trx')->info("CRON | $row->trx_no send faspay to MPONE with taken $row->taken FINISH");
                            }else{
                                return; 
                            }
                        }
                    }
                }
                
            }else{
                // prescription
                if(is_null($row->is_send_faspay_prescription) || $row->is_send_faspay_prescription == false){
                    $pay_medicine = Payment_telmed::where('trx_no', $row->trx_no.'-MED')
                            ->where('pay_message', Payment_telmed::STS_PAID)
                            ->first();
                    if(!is_null($pay_medicine)){
                        $data = Trx_history_telmed::find($row->id);
                        if($row->taken == 0){
                            $create_payment = $this->repoMpOne->faspay($data);
                            // update faspay
                            $data->is_send_faspay_prescription = 1;
                            $data->save();
                            Log::channel('schedule_trx')->info("CRON | $row->trx_no send faspay prescription to MPONE with taken $row->taken FINISH");
                        }
                        if($row->taken == 1){
                            if($time_now > $time_window){
                                $create_payment = $this->repoMpOne->faspay($data);
                                // update faspay
                                $data->is_send_faspay_prescription = 1;
                                $data->save();
                                Log::channel('schedule_trx')->info("CRON | $row->trx_no send faspay prescription to MPONE with taken $row->taken FINISH");
                            }
                        }
                    }
                }else{
                    return;
                }
            }

        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
        }
    }
}
