<?php

namespace App\Http\Middleware;

use Closure;
use Helper;
use Illuminate\Http\Request;
use Illuminate\Contracts\Auth\Factory as Auth;
use Tymon\JWTAuth\Facades\JWTAuth as JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

class jwtApiAuthentication
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            $user = JWTAuth::parseToken()->authenticate();
            return $next($request);
        } catch (JWTException $e) {
            Helper::Log("error", "JWT Auth Failed", ["message" => $e->getMessage()]);
            if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenExpiredException) {
                return Helper::generalResponse(false, 'Token is Expired, please Relogin', [], 401) ;
            } else if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenInvalidException) {
                return Helper::generalResponse(false, 'Token is Invalid', [], 403) ;
            } else {
                return Helper::generalResponse(false, 'Authorization Token not found', [], 404) ;
            }
        }

    }
}
