<?php

namespace App\Http\Controllers\Web\Telemedicine;

use Helper;
use Library;
use Exception;
use TrxHistory;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Web_user;
use App\Models\Notifikasi;
use App\Services\Firebase;
use App\Models\Soap_telmed;
use Illuminate\Support\Str;
use App\Models\Icd10_telmed;
use Illuminate\Http\Request;
use App\Models\Mobile_status;
use App\Models\Recipe_telmed;
use App\Models\Notifikasi_web;
use App\Models\Payment_telmed;
use App\Repository\MPOneManager;
use App\Models\Attachment_telmed;
use App\Repository\QiscusManager;
use App\Exports\AppointmentExport;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use App\Repository\TelemedicineManager;
use Illuminate\Support\Facades\Storage;
use App\Services\Validator\ValidatorManagerInterface;

class TelemedicineWebController extends Controller
{
    public $me;
    public $firebase;
    public $REPO;
    public $conn;
    public $qiscus;
    public $repoMpOne;

    public function __construct()
    {
        $this->me           = auth()->guard('web_users')->user();
        $this->firebase     = new Firebase();
        $this->REPO         = new TelemedicineManager();
        $this->repoMpOne    = new MPOneManager();
        if(config('services.medikaplaza.telemedicine_mode') == 'production'){
            $this->conn        = DB::connection('pgsql');
        }else{
            $this->conn        = DB::connection('stag_medika');
        }
        $this->qiscus       = new QiscusManager();
    }
    public function meetAppointment(Request $request)
    {
        $rule = [
            'trx_no'      => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            // Cek transaction
            $time_now = Carbon::now();
            $trx = Trx_history_telmed::where('date_consul', '=' , $time_now)
                    ->where('trx_no',$request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            $date_time_consul = $trx->date_consul.' '.$trx->time_consul ;
            $time_window   = Carbon::parse($date_time_consul);
            if($time_window->toTimeString() >= $time_now->toTimeString()){
                throw new Exception("Sorry, Appointment not yet started");
            }
            $result =[];
            $get_doktor  = $this->REPO->listDokter("AND p.id = '" . $trx->id_dokter . "'");

            $doktor = (isset($get_doktor[0]->name))?$get_doktor[0]->name:"-";

            if(!is_null($trx->link_meet)){
                $result =[
                    "domain"        => "8x8.vc",
                    "room"          => sprintf("%s/%s", config('services.medikaplaza.jitsi'), urlencode($trx->link_meet)),
                    "jwt"           => \App\Services\Jitsi::generateJwt(""),
                    "cust_name"     => $trx->cust_name,
                    "email"         => $trx->email,
                    "doktor"        => $doktor,
                    "date_consul"   => $trx->date_consul,
                    "time_consul"   => $trx->time_consul,
                    "status"        => $trx->trx_status
                ];
            }else{
                $result =[
                    "cust_name"     => $trx->cust_name,
                    "email"         => $trx->email,
                    "doktor"        => $doktor,
                    "date_consul"   => $trx->date_consul,
                    "time_consul"   => $trx->time_consul,
                    "status"        => $trx->trx_status
                ];
            }
           
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Appointment meet Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function checkStatus(Request $request)
    {
        $rule = [
            'trx_no'      => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            // Cek transaction
            $trx = Trx_history_telmed::where('trx_no',$request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            $result =[];
            $result =[
                "status"        => $trx->trx_status
            ];

            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Check Status Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function listAppointment(Request $request)
    {
        $rule = [
            'date_start'      => 'nullable|date_format:Y-m-d',
            'date_stop'       => 'nullable|date_format:Y-m-d',
            'gender'          => 'nullable|in:male,female',
            'type'            => 'nullable|in:member,non_member,retail',
            'status'          => 'nullable|in:pending,confirm,reject,rescheduled,ongoing,done',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where = [];
            $limit = 10;
            
            if ($request->has('limit')) {
                $limit = $request->limit;
            } 
            if (!is_null($request->query('gender'))) {
                $where[] = "AND trx.gender = '" . $request->query('gender') . "'";
            }
            if (!is_null($request->query('patient_type'))) {
                $where[] = "AND trx.patient_type = '" . $request->query('patient_type') . "'";
            }
            if (!is_null($request->query('type'))) {
                $where[] = "AND trx.patient_type = '" . $request->query('type') . "'";
            }
            if (!is_null($request->query('status'))) {
                $where[] = "AND trx.trx_status = '" . $request->query('status') . "'";
            }
            if (!is_null($request->query('search')) && $request->query('search')) {
                $where[] = "AND (trx.trx_no ILIKE '%".$request->query('search')."%' OR trx.cust_name ILIKE '%".$request->query('search')."%')";
            }
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.created_at) >= '" . $from . "' AND date(trx.created_at) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.created_at > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $result  = $this->REPO->listApointment($where_str);

            $result = Helper::setPaginate(Helper::arrayPaginator($result,$request, $limit));
           
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Appointment Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function listObat(Request $request)
    {
        Helper::LogDashboard("info", "List Obat Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $rule = [
            'trx_no'       => 'required',
            'apotek_id'    => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where = [];
            if (!is_null($request->get('product_name'))) {
                $where[] = "AND (lower(pt.name) ILIKE '%".strtolower($request->get('product_name'))."%' OR lower(pt.default_code) ILIKE '%".strtolower($request->get('product_name'))."%')";
            }
            $check = Trx_history_telmed::where('trx_no', $request->get('trx_no'))->first();
            if(is_null($check)){
                throw new \Exception("List Obat Failed");
            }
            $apotek_id = $request->get('apotek_id');
            $where[] = "AND sq.warehouse_id = $apotek_id"; 
            $where_str = implode(" ", $where);
            
            $data  = $this->REPO->listObat($where_str);
            $result = collect($data)->map(function ($res) {
                $map = [
                    "product_id"            => $res->product_template_id??"",
                    "product_name"          => sprintf('%s %s', $res->default_code, $res->obat_name),
                    "warehouse_id"          => $res->warehouse_id??"",
                    "warehouse_name"        => $res->warehouse_name??"",
                    "quantity"              => $res->quantity,
                ];
                return $map;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Get data obat Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function listObatOld(Request $request)
    {
        Helper::LogDashboard("info", "List Obat Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $url = config('services.medikaplaza.telemedicine.obat');
        $rule = [
            'id_faskes'       => 'required|integer',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $id_faskes    = $request->id_faskes;
            $payload = sprintf('{
                "ListObatTelemedicine": { 
                    "id_faskes": "%d"
                    }
                }', $id_faskes);
            Helper::LogDashboard("info", "List Obat Payload", [$payload]);
            $response = Http::withBody(
                        $payload, 'application/json'
                        )->post($url);
            $res = json_decode($response);
            if (!isset($res) || is_null($res) || !isset($res->ListObatTelemedicineResponse) || $res->ListObatTelemedicineResponse->response_code != "00") {
                throw new \Exception("List Obat Failed");
            }
            $data = $res->ListObatTelemedicineResponse->list_obat;
            $product_name = $request->product_name;
            $result = collect($data)->map(function ($res) {
                $map = [
                    "id"                => $res->id,
                    "product_id"        => $res->product_id[0]??"",
                    "product_name"      => $res->product_id[1]??"",
                    "price"             => $res->price??0,
                    "warehouse_id"      => $res->warehouse_id[0]??"",
                    "warehouse_name"    => $res->warehouse_id[1]??"",
                    "quantity"          => $res->quantity,
                ];
                return $map;
            })->filter(function($item) use ($product_name) {
                if(isset($product_name)){
                    return stripos(strtolower($item['product_name']),strtolower($product_name)) !== false;
                }
                return true;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Get data obat Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function listPlan(Request $request)
    {
        try{
            $where = "";
            if (!is_null($request->query('name'))) {
                $where .= "AND lower(bm.name) ILIKE '%".strtolower($request->query('name'))."%'";
            }
            if (!is_null($request->query('id'))) {
                $where .= "AND bm.id = '" . $request->query('id') . "'";
            }
            $result  = $this->REPO->getPlan($where);

            Helper::LogDashboard("info", "Success", $result);
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Get plan Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function listApotek(Request $request)
    {
        $rule = [
            'trx_no'       => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where = "";
            if (!is_null($request->query('name'))) {
                $where .= " AND lower(w.name) ILIKE '%".strtolower($request->query('name'))."%'";
            }
            if (!is_null($request->query('id'))) {
                $where .= " AND w.id = '" . $request->query('id') . "'";
            }
            $trx = Trx_history_telmed::where('trx_no',$request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            $whereModif = $where;
            if (!is_null($trx)) {
                $whereModif .= " AND rp.id = '" . $trx->id_dokter . "'";
            }
            
            $result  = $this->REPO->getApotek($whereModif);
            // fallback to all apotek
            if ($result->isEmpty()) {
                $result  = $this->REPO->getApotek($where);
            }

            Helper::LogDashboard("info", "Success", $result);
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Get apotek Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function listIcd(Request $request)
    {
        try{
            $where = "";
            if (!is_null($request->query('name'))) {
                $where .= "AND (lower(dd.name) ILIKE '%".strtolower($request->query('name'))."%' OR lower(dd.diagnosis_code) ILIKE '%".strtolower($request->query('name'))."%')";
            }
            $result  = $this->REPO->getIcd($where);
            $res  = $result->map(function($res){
                $map = [
                    "id"                => $res->id,
                    "name"              => sprintf('%s %s', $res->diagnosis_code, $res->name),
                    "diagnosis_code"    => $res->diagnosis_code,
                    "get_name"          => $res->get_name,
                ];
                return $map;
            });

            return Helper::generalResponse(true, 'Success', $res);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Get icd Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    // todo
    public function exportAppointment(Request $request)
    {
        $rule = [
            'date_start'      => 'nullable|date_format:Y-m-d',
            'date_stop'       => 'nullable|date_format:Y-m-d',
            'gender'          => 'nullable|in:male,female',
            'type'            => 'nullable|in:member,non_member,retail',
            'status'          => 'nullable|in:pending,confirm,reject,reschedule,ongoing,done',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where = [];
            $limit = 10;
            
            if ($request->has('limit')) {
                $limit = $request->limit;
            } 
            if (!is_null($request->query('gender'))) {
                $where[] = "AND trx.gender = '" . $request->query('gender') . "'";
            }
            if (!is_null($request->query('patient_type'))) {
                $where[] = "AND trx.patient_type = '" . $request->query('patient_type') . "'";
            }
            if (!is_null($request->query('type'))) {
                $where[] = "AND trx.patient_type = '" . $request->query('type') . "'";
            }
            if (!is_null($request->query('status'))) {
                $where[] = "AND trx.trx_status = '" . $request->query('status') . "'";
            }
            if (!is_null($request->query('search'))) {
                $where[] = "AND (trx.trx_no ILIKE '%".$request->query('search')."%' OR trx.cust_name ILIKE '%".$request->query('search')."%')";
            }
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.created_at) >= '" . $from . "' AND date(trx.created_at) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.created_at > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $result  = $this->REPO->listApointment($where_str);
            return (new AppointmentExport($result))->download("ReportAppointmentTransaction_" . date('YmdHis') . ".xlsx");

        }catch(\Exception $e){
            Helper::LogDashboard('error','Export Appointment Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function detailAppointment(Request $request)
    {
        $rule = [
            'trx_no'      => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $data = Trx_history_telmed::where('trx_no', $request->query('trx_no'))
                    ->with('soap')
                    ->with('icd10')
                    ->with('recipe')
                    ->with('payment')
                    ->with('attachment')
                    ->limit(1)
                    ->get();
            
            $collect = collect($data);
            if($collect->isEmpty()){
                Helper::LogDashboard('error', 'Appointment detail not found', []);
                return Helper::generalResponse(false, 'Appointment detail not found', [], 400);
            }
            $result = $collect->map(function ($res){
                $telmed_link = null;
                $recipe = null;
                $icd10 = null;
                $payment = null;
                $attachment = null;

                if(isset($res->link_meet)){
                    $telmed_link =[
                            "domain"    => "8x8.vc",
                            "room"      => sprintf("%s/%s", config('services.medikaplaza.jitsi'), urlencode($res->link_meet)),
                            "jwt"       => \App\Services\Jitsi::generateJwt(auth()->guard('web_users')->user()),
                        ];
                }
                // Get Icd10
                if(count($res->icd10)>0){
                    $icd10 = collect($res->icd10)->map(function ($res){
                        $where = "AND dd.id = $res->icd10_id";
                        $icd10_name = $this->REPO->getIcd($where);
                        $res->icd10_name = $icd10_name->first()->name??"-";
                        return $res;
                    });
                }
                // Get recipe
                if(count($res->recipe)>0){
                    $recipe = collect($res->recipe)->map(function ($res){
                        $where = " AND pt.id = $res->producttemp_id";
                        $medicine_name = $this->REPO->listObat($where);
                        $res->medicine_name = $medicine_name->first()->obat_name??"-";
                        $res->stock = $medicine_name->first()->quantity??0;
                        return $res;
                    });
                }
                // Get payment
                if(!is_null($res->payment)){
                    $res->payment->pay_method = Library::getPaymentChannel($res->payment->pay_method);
                    $payment = $res->payment;
                }
                // Get attachment
                if(count($res->attachment)>0){
                    $attachment = collect($res->attachment)->map(function ($res){
                        $file =  "";
                        $storage = storage_path('app/attachment/'.$res->filename);
                        if (!is_null($res->filename) && $storage){
                            $file =  env('APP_URL').'attachment/'.$res->filename;
                        }
                        
                        $size = Storage::disk('attachment')->size($res->filename)??0;
                        $fileSize = Helper::humanFileSize($size);
                        
                        $fileType = Storage::disk('attachment')->mimeType($res->filename)??"";
                        $res->file_url = $file;
                        $res->filesize = $fileSize;
                        $res->filetype = $fileType;
                        return $res;
                    });
                }
                // dokter
                if(!is_null($res->id_dokter)){
                    $where = "AND p.id = $res->id_dokter";
                    $dokter  = $this->REPO->listDokter($where);
                }
                // get_apotek
                $q = "SELECT name FROM stock_warehouse WHERE id = %d LIMIT 1";
                $q = sprintf($q, $res->apotek_id);
                $apotek = $this->conn->select($q);

                $res->apotek = (isset($apotek[0]->name)?$apotek[0]->name:"-");
                $res->date_time_consul = $res->date_consul.' '.$res->time_consul ;
                $time_now   =  Carbon::now()->toDateTimeString();
                $time_window   = Carbon::parse($res->date_time_consul)->addMinutes(25)->toDateTimeString();
                $editable = true;
                if($time_now >= $time_window){
                    $editable = false;
                }
                if(! is_null($res->taken)){
                    $editable = false;
                }
                $res->editable = $editable;
                $res->telmed_link = $telmed_link;
                $res->soap = (!is_null($res->soap))?$res->soap:null;
                $res->recipe = $recipe;
                $res->icd10 = $icd10;
                $res->payment = $payment;
                $res->dokter = $dokter[0]??null;
                $res->attachment = $attachment;
                return $res;
            });
            
            return Helper::generalResponse(true, 'Success', $result->first());
        }catch(\Exception $e){
            report($e);
            Helper::LogDashboard('error','Appointment detail Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function approval(Request $request){
        Helper::LogDashboard("info", "Approval telmed Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $rule = [
            'status'    => 'required|in:confirm,reject',
            'trx_no'    => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            // Cek transaction
            $trx = Trx_history_telmed::where('trx_no',$request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            $to ="";
            $note ="";
           
            if ($request->status == 'confirm'){
                $type = 'confirm';
                $subject = "Confirm Appointment Success";
                
                $trx_status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
                $trx_status_code = Trx_history_telmed::STS_CODE_WAIT_APPOINTMNET;
            }else if($request->status == 'reject'){
                $type = 'reject';
                $subject = "Appointment Has Been Rejected";

                $trx_status         = Trx_history_telmed::STS_REJECT;
                $trx_status_code    = Trx_history_telmed::STS_CODE_REJECT;
                $note               = $request->note;
            }
            $trx->trx_status        = $trx_status;
            $trx->note              = $note;
            $trx->trx_status_code   = $trx_status_code;
            $trx->save();

            // Decline GL
            if ($request->status == 'reject' && $trx->patient_type == 'non_member') {
                // if non_member send declie to notify mpone
                $decline = $this->repoMpOne->declineGlV2($trx);
            }

            // notification
            try{
                self::pushNotification($trx,$type,$subject);
            }catch(Exception $e){
                Helper::LogDashboard('error','Approval Failed send notification', $e->getMessage());
            }
            return Helper::generalResponse(true, 'Success', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Approval Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function pushNotification($data, $type, $subject){
        
        $where ="";
        $to="";
        if(isset($data->email)){
            $to = (!is_null($data->email))?$data->email:"";
        }
        $where .= "AND p.id = '" . $data->id_dokter . "'";
        $get_doktor  = $this->REPO->listDokter($where);

        $doktor = (isset($get_doktor[0]->name))?$get_doktor[0]->name:"-";
        $message = "";
        $message_doktor = "";
        if($type == 'confirm'){
            $message = "Appointment $data->trx_no with $doktor has been confirm ";
            $message_doktor = "Appointment $data->trx_no with $data->cust_name has been confirm ";
        }else{
            $message = "Appointment $data->trx_no with $doktor has been reject ";
            $message_doktor = "Appointment $data->trx_no with $data->cust_name has been reject ";
        }
        // Send notif wa
        self::sendNotifWa($data, $type,$doktor);

        if(!is_null($data->id_user)){
            $user = $this->firebase->getUserToken($data->id_user);
            $notif = [
                'id_user'       => $data->id_user,
                'user'          => $user,
                'label'         => $type,
                'type'          => 'appointment',
                'text'          => $message,
            ];
            // //**Push notification */
            if(!!$notif){
                $this->firebase->pushNotif($notif);
            }
        }
        // insert notif web
        $arr = [
			'id_user'       => $data->id_user,
			'id_dokter'     => $data->id_dokter,
			'label'         => 'reminder',
			'type'          => 'appointment',
			'text'          => $message_doktor,
        ];
        Notifikasi_web::create($arr);
        // Send email
        $base_url = config('services.medikaplaza.web_telmed');
        $url = sprintf('%s/%s', $base_url, "guest/landing?c=".$data->trx_no);
        $data = [
            'type'          => $type,
            'id_user'       => $data->id_user??"",
            'subject'       => $subject,
            'doktor_name'   => $doktor,
            'pasien'        => $data->cust_name,
            'url'           => $url??"",
            'date_consul'   => Carbon::parse($data->date_consul)->isoFormat('D MMMM YYYY')??"-",
            'time_consul'   => Carbon::parse($data->time_consul)->isoFormat('HH:mm')??"-",
        ];
    
        if(!is_null($to)){
            $this->REPO->sendEmail($to, $data, $type);
        }

    }
    public function sendNotifWa($data, $type, $dokter_name){
        $headers = [
            "Qiscus-App-Id"     => env('QISCUS_APP_ID'),
            "Qiscus-Secret-Key" => env('QISCUS_SECRET_KEY'),
            "Content-Type"      => 'application/json'
        ];
        $to = $data->phone;
        $cust_name = $data->cust_name;
        $dokter_name = $dokter_name;
        $date_consul = $data->date_consul;
        $time_consul = $data->time_consul;
        if($type == 'confirm'){
            $template = "approved_telemedicine";
            $parameters = [
                [
                    "type"  => "text",
                    "text"  => $cust_name,
                ],[
                    "type"  => "text",
                    "text"  => $dokter_name,
                ],[
                    "type"  => "text",
                    "text"  => $date_consul,
                ],[
                    "type"  => "text",
                    "text"  => $time_consul,
                ]
            ];
        }else{
            $template = "rejected_telemedicine";
            $parameters = [
                [
                    "type"  => "text",
                    "text"  => $cust_name,
                ],[
                    "type"  => "text",
                    "text"  => $dokter_name,
                ]
            ];
        }
        $request = [
            "to"    => $to,
            "type"    => "template",
            "template"    => [
                "namespace" => "0759bbc6_df4f_4bbb_a533_94beea4fb86c",
                "name"      => $template,
                "language"  => [
                    "policy"  => "deterministic",
                    "code"    => "id",
                ],
                "components"    => [
                    [
                        "type"          => "body",
                        "parameters"    => $parameters,
                ]
                ]
            ]
        ];
        $payload = json_encode($request, true);
        Helper::Log("info", "Send message Payload", [$payload]);
        $res = $this->qiscus->qiscus($headers,$payload);
        return $res;
    }
    public function addResult(Request $request){
        $rule = [
            'trx_no'      => 'required',
            'subjektif'   => 'required',
            'objektif'    => 'required',
            'assessment'  => 'required',
            'plan'        => 'required',
            'icd10'       => 'required',
            'recipe'      => 'required',
            'apotek_id'   => 'required',
            // 'attachment' => 'nullable|array',
            // 'attachment.*' => 'nullable|file',
	    ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        $connName = (new Soap_telmed())->getConnectionName();
        DB::connection($connName)->beginTransaction();
        try{
            $apotek_id              = $request->get('apotek_id');
            $request_data_icd10     = $request->get('icd10');
            $request_data_recipe    = $request->get('recipe');
            if(!Helper::isJson($request_data_icd10)){
                Helper::LogDashboard('info', 'FASPAY : The request icd10 is not in a JSON format.', $request_data_icd10);
                return Helper::generalResponse(false,  'The request icd10 is not in a JSON format.', [], 401);
            }
            if(!Helper::isJson($request_data_recipe)){
                Helper::LogDashboard('info', 'FASPAY : The request recipe is not in a JSON format.', $request_data_recipe);
                return Helper::generalResponse(false,  'The request recipe is not in a JSON format.', [], 401);
            }
            // Cek transaction
            $trx = Trx_history_telmed::where('trx_no',$request->trx_no)
                ->whereIn('trx_status', [Trx_history_telmed::STS_ONGOING,Trx_history_telmed::STS_DONE])
                ->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            if (!is_null($request->get('apotek_id')) && $request->get('apotek_id') && $request->get('apotek_id') != '') {
                $where = " AND w.id = '" . $request->get('apotek_id') . "'";
                $get_apotek  = $this->REPO->getApotek($where);
                if($get_apotek->isEmpty()){
                    Helper::LogDashboard('error', 'Apotek tidak ditemukan', []);
                    return Helper::generalResponse(false, 'Apotek tidak ditemukan', [], 400);
                }
            }

            $icd10  = json_decode($request_data_icd10, true);
            $recipe = json_decode($request_data_recipe, true);
            // Add SOAP
            $data = Soap_telmed::firstOrCreate([
                'trx_no'        => $request->get('trx_no'),
                'subjektif'     => $request->get('subjektif')??"",
                'objektif'      => $request->get('objektif')??"",
                'assessment'    => $request->get('assessment')??"",
                'plan'          => $request->get('plan')??"",
                'alergi'        => $request->get('alergi')??"",
                'status_hamil'    => $request->get('status_hamil')??"no",
                'status_menyusui' => $request->get('status_menyusui')??"no",
                'usia_kehamilan'  => $request->get('usia_kehamilan')??0,
            ]);
            // Add Examination
            if (isset($icd10) && is_array($icd10) && count($icd10)>0){
                foreach($icd10 as $key => $val){
                    $icd10 = Icd10_telmed::create([
                        'trx_no'       => $request->trx_no,
                        'icd10_id'     => $val['icd10_id']??"",
                        'case_type'     => $val['case_type']??"",
                        'diagnostic_type'     => $val['diagnostic_type']??"",
                    ]);
                }
            }
            // Add Recipe
            if(isset($recipe) && is_array($recipe) && count($recipe)>0){
                foreach($recipe as $key =>$val){
                    $q = "SELECT id FROM product_product WHERE product_tmpl_id = %d LIMIT 1";
                    $q = sprintf($q, $val['product_id']);
                    $prodTempl = $this->conn->select($q);
	
                    // product template not found
                    if (count($prodTempl) == 0) continue;
		    
                    $data = Recipe_telmed::create([
                        'trx_no'          => $request->trx_no,
                        'product_id'      => $prodTempl[0]->id,
                        'medicine_name'   => $val['medicine_name']??"",
                        'qty'             => $val['qty']??"",
                        'signa'           => $val['signa']??"",
                        'remarks'         => $val['remarks']??"",
                        'producttemp_id'  => $val['product_id'],
                    ]);
                }
            }
            
            // upload attachment
            if ($request->hasFile('attachment')) {
                self::attachment_file($request);
            }
            // save apotek id 
            $trx->apotek_id = $apotek_id;
            $trx->save();
            DB::connection($connName)->commit();
            return Helper::generalResponse(true, 'Success add result', []);
        }catch(Exception $e){
            DB::connection($connName)->rollback();
            Helper::LogDashboard('error','Add Result telmed Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function editResult(Request $request){
        $rule = [
            'id_soap'       => 'required',
            'trx_no'        => 'required',
            // 'attachment[]'  => 'file',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        $connName = (new Soap_telmed())->getConnectionName();
        DB::connection($connName)->beginTransaction();
        try{
            $request_data_icd10 = $request->get('icd10');
            $request_data_recipe = $request->get('recipe');
            if(!Helper::isJson($request_data_icd10)){
                Helper::LogDashboard('info', 'FASPAY : The request icd10 is not in a JSON format.', $request_data_icd10);
                return Helper::generalResponse(false,  'The request icd10 is not in a JSON format.', [], 401);
            }
            if(!Helper::isJson($request_data_recipe)){
                Helper::LogDashboard('info', 'FASPAY : The request recipe is not in a JSON format.', $request_data_recipe);
                return Helper::generalResponse(false,  'The request recipe is not in a JSON format.', [], 401);
            }
            // Cek transaction
            $trx = Trx_history_telmed::where('trx_no', $request->get('trx_no'))->first();
            if(is_null($trx)){
                throw new Exception("Transaction tidak ditemukan: ".$request->get('trx_no'));
            }
            $trx->date_time_consul = $trx->date_consul.' '.$trx->time_consul ;
            $time_now   =  Carbon::now()->toDateTimeString();
            $time_window   = Carbon::parse($trx->date_time_consul)->addMinutes(25)->toDateTimeString();
            if($time_now >= $time_window){
                throw new Exception("Edit result not accept");
            }
            if(! is_null($trx->taken)){
                throw new Exception("Edit result not accept");
            }

            $soap = Soap_telmed::where('id',$request->id_soap)->where('trx_no',$request->trx_no)->first();
            if(is_null($soap)){
                Helper::LogDashboard('error', 'Soap tidak ditemukan', []);
                return Helper::generalResponse(false, 'Soap tidak ditemukan', [], 400);
            }
            $icd10  = json_decode($request_data_icd10, true);
            $recipe = json_decode($request_data_recipe, true);

            //update soap
            $soap->subjektif    = $request->get('subjektif')??$soap->subjektif; 
            $soap->objektif     = $request->get('objektif')??$soap->objektif; 
            $soap->assessment   = $request->get('assessment')??$soap->assessment; 
            $soap->plan         = $request->get('plan')??$soap->plan; 
            $soap->alergi         = $request->get('alergi')??$soap->alergi; 
            $soap->status_hamil        = $request->get('status_hamil')??$soap->status_hamil; 
            $soap->status_menyusui     = $request->get('status_menyusui')??$soap->status_menyusui; 
            $soap->usia_kehamilan     = $request->get('usia_kehamilan')??$soap->usia_kehamilan; 
            $soap->save();

           // Update Examination
            if (isset($icd10) && is_array($icd10) && count($icd10)>0){
                $delete = Icd10_telmed::where('trx_no', $request->trx_no)->delete();
                foreach($icd10 as $key => $val){
                    $icd10 = Icd10_telmed::create([
                        'trx_no'       => $request->trx_no,
                        'icd10_id'     => $val['icd10_id']??"",
                        'case_type'     => $val['case_type']??"",
                        'diagnostic_type'     => $val['diagnostic_type']??"",
                    ]);
                }
            }
            // update Recipe
            if(isset($recipe) && is_array($recipe) && count($recipe)>0){
                $delete = Recipe_telmed::where('trx_no', $request->trx_no)->delete();
                foreach($recipe as $key =>$val){
                    $q = "SELECT id FROM product_product WHERE product_tmpl_id = %d LIMIT 1";
                    $q = sprintf($q, $val['product_id']);
                    $prodTempl = $this->conn->select($q);
                    // product template not found
                    if (count($prodTempl) == 0) continue;
                    $data = Recipe_telmed::create([
                        'trx_no'          => $request->trx_no,
                        'product_id'      => $prodTempl[0]->id,
                        'medicine_name'   => $val['medicine_name']??"",
                        'qty'             => $val['qty']??"",
                        'signa'           => $val['signa']??"",
                        'remarks'         => $val['remarks']??"",
                        'producttemp_id'  => $val['product_id'],
                    ]);
                    
                }
            }
             // upload attachment
             if ($request->hasFile('attachment')) {
                self::attachment_file($request);
            }
            DB::connection($connName)->commit();
            return Helper::generalResponse(true, 'Success Edit Result', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Edit Result telmed Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function attachment_file($request){
        try{
            $now = date('ymdHis');
            if($request->hasFile('attachment')){
                $files = $request->file('attachment');
                foreach ($files as $file) {
                    $file_name = $now.'-'.$file->getClientOriginalName();
                    $store = $file->move(storage_path('app/attachment'), $file_name);
                    if(!$store){
                        Helper::LogDashboard('error','Upload attachment Failed', []);
                    }else{
                        $ins = Attachment_telmed::create([
                            'trx_no'    => $request->trx_no,
                            'filename'  => $file_name,
                        ]);
                    }
                }
            }
        }catch(Exception $e){
            Helper::LogDashboard('error','Upload attachment Failed', $e->getMessage());
        }
    }
    public function deleteAttachment(Request $request){
        $rule = [
            'id_attachment' => 'required',
            'trx_no'        => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $attach = Attachment_telmed::where('id', $request->id_attachment)->where('trx_no', $request->trx_no)->first();
            if(is_null($attach)){
                Helper::LogDashboard('error', 'Attachment tidak ditemukan', []);
                return Helper::generalResponse(false, 'Attachment tidak ditemukan', [], 400);
            }
            $delete = Attachment_telmed::where('id', $request->id_attachment)->where('trx_no', $request->trx_no)->delete();
            $del = Storage::delete('attachment/'. $attach->filename);
            return Helper::generalResponse(true, 'Success Delete Attachment', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Delete attachment Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);

        }
    }
    public function editSoapOld(Request $request){
        $rule = [
            'id_soap'      => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        
        try{
            // Cek transaction
            $soap = Soap_telmed::where('id',$request->id_soap)->first();
            if(is_null($soap)){
                Helper::LogDashboard('error', 'Soap tidak ditemukan', []);
                return Helper::generalResponse(false, 'Soap tidak ditemukan', [], 400);
            }
            $soap->subjektif    = $request->get('subjektif')??$soap->subjektif; 
            $soap->objektif     = $request->get('objektif')??$soap->objektif; 
            $soap->assessment   = $request->get('assessment')??$soap->assessment; 
            $soap->plan         = $request->get('plan')??$soap->plan; 
            $soap->alergi         = $request->get('alergi')??$soap->alergi; 
            $soap->status_hamil        = $request->get('status_hamil')??$soap->status_hamil; 
            $soap->status_menyusui     = $request->get('status_menyusui')??$soap->status_menyusui; 
            $soap->save();
            return Helper::generalResponse(true, 'Success Edit Soap', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Edit Soap telmed Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function setDone(Request $request){
        $rule = [
            'trx_no'    => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            // Cek transaction
            $trx = Trx_history_telmed::where('trx_no',$request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            $trx->trx_status        = Trx_history_telmed::STS_DONE;
            $trx->trx_status_code   = Trx_history_telmed::STS_CODE_DONE;
            $trx->save();
         
            return Helper::generalResponse(true, 'Success', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Appointment set done Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function rescheduleTelmed(Request $request)
    {
        Helper::LogDashboard("info", "Reschedule telmed Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $rule = [
            'date_consul'      => 'required|date_format:Y-m-d',
            'time_consul'      => 'required|date_format:H:i',
            'trx_no'           => 'required',
            'id_dokter'        => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        
        try{
            // Cek transaction
            $trx = Trx_history_telmed::where('trx_no',$request->trx_no)
                ->whereNotNull('date_consul')
                ->whereNotNull('time_consul')
                ->where('trx_status','=', Trx_history_telmed::STS_REJECT)
                ->first();
            if(is_null($trx)){
                Helper::LogDashboard('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }

            $meta = [
                "reschedule" => [
                    "trx_no"        => $trx->trx_no,
                    "date_consul"   => $trx->date_consul,
                    "time_consul"   => $trx->time_consul,
                ]
            ];
            $trx->meta_trx_data     = $meta;
            $trx->date_consul       = $request->date_consul;
            $trx->time_consul       = $request->time_consul;
            $trx->id_dokter         = $request->id_dokter??$trx->id_dokter;
            $trx->trx_status        = Trx_history_telmed::STS_RESCHEDULE;
            $trx->trx_status_code   = Trx_history_telmed::STS_CODE_RESCHEDULE;
            $trx->save();
           
            // if member / non_member (gl created) execute goes here. api reschedule gl
            if ($trx->patient_type != 'retail') {
            // Reschedule GL
            $reschedule = $this->repoMpOne->rescheduleGlV2($trx);
            if (isset($reschedule->RescheduleTelemedicineResponse)
                && isset($reschedule->RescheduleTelemedicineResponse->response_code)
                && $reschedule->RescheduleTelemedicineResponse->response_code != '00') {
                Helper::Log("info", "Reschedule telmed Request to MPOne fail", ['request'=>$request->all(),'path'=>$request->url()]);
            }
            }

            return Helper::generalResponse(true, 'Success', []);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Reschedule telmed Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    
}
