<?php

namespace App\Http\Controllers\Web\Telemedicine;

use Helper;
use Library;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Web_user;
use App\Services\Firebase;
use Carbon\CarbonImmutable;
use Illuminate\Http\Request;
use App\Models\Schedule_dokter;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use App\Models\Schedule_dokter_holiday;
use App\Repository\TelemedicineManager;
use App\Services\Validator\ValidatorManagerInterface;

class DokterWebController extends Controller
{
    public $me;
    public $firebase;
    public $REPO;
    public $conn;

    public function __construct()
    {
        $this->me           = auth()->guard('web_users')->user();
        $this->firebase     = new Firebase();
        $this->REPO         = new TelemedicineManager();
        if(config('services.medikaplaza.telemedicine_mode') == 'production'){
            $this->conn        = DB::connection('pgsql');
        }else{
            $this->conn        = DB::connection('stag_medika');
        }
    }
    public function listScheduleDokter(Request $request)
    {
        try{
            $where ="";
            $limit = 10;
            
            if ($request->has('limit')) {
                $limit = $request->limit;
            } 
            if (!is_null($request->query('day_code'))) {
                $where .= "AND sd.day_code = '" . $request->query('day_code') . "'";
            }
            if (!is_null($request->query('search'))) {
                $where .= "AND (lower(rp.name) ILIKE '%".strtolower($request->query('search'))."%')";
            }
            if($this->me->group == '2000'){
                $where .= "AND sd.id_dokter = ".$this->me->id_dokter."";
            }
            $data  = $this->REPO->listScheduleDokter($where);
            $result = collect($data)->map(function($res){
                $img_holder = asset('img/no_image.png');
                $res->avatar = (! isset($res->photo) || is_null($res->photo) || $res->photo == '') ? $img_holder : Helper::generateImgUrl('user_web', $res->photo);
                return $res;
            })->values()->toArray();
            
            if(!is_null($request->query('limit'))){
                $result = Helper::setPaginate(Helper::arrayPaginator($result,$request, $limit));
            }else{
                $result = Helper::setData($result);
            }
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Get dokter Schedule list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter Schedule list Failed", [], 500);
        }  
    }
    public function listDokter(Request $request)
    {
        try{
            $where ="";
            $limit = 10;
            
            if ($request->has('limit')) {
                $limit = $request->limit;
            } 
            if (!is_null($request->query('id_specialist'))) {
                $where .= " AND k.id = '" . $request->query('id_specialist') . "'";
            }
            if (!is_null($request->query('id_dokter'))) {
                $where .= " AND p.id = '" . $request->query('id_dokter') . "'";
            }
            if (!is_null($request->query('search'))) {
                $where .= " and lower(p.name) ILIKE '%".strtolower($request->query('search'))."%'";
            }
            // gender
            if (!is_null($request->query('gender'))) {
                $where .= " AND p.gender = '" . $request->query('gender') . "'";
            }
            if($this->me->group == '2000'){
                $where .= " AND p.id = ".$this->me->id_dokter."";
            }
            if (!is_null($request->query('status'))) {
                $where .= " AND COALESCE(wu.status, 0) = '" . $request->query('status') . "'";
            }
            $data  = $this->REPO->listDokter($where);
            $result = collect($data)->map(function($res){
                $res->price = (int) $res->price;
                $img_holder = asset('img/no_image.png');
                $res->avatar = (! isset($res->photo) || is_null($res->photo) || $res->photo == '') ? $img_holder : Helper::generateImgUrl('user_web', $res->photo);
                $res->user_group = Helper::userGroupName($res->group);

                return $res;
            })->values()->toArray();
            
            if(!is_null($request->query('limit'))){
                $result = Helper::setPaginate(Helper::arrayPaginator($result,$request, $limit));
            }else{
                $result = Helper::setData($result);
            }
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Get dokter list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter list Failed", [], 500);
        }  
    }
    public function create(Request $request){
        try{
            $rule = [
                'name'          => 'required|max:150',
                'email'         => 'required|email|unique:web_user',
                // 'phone'         => 'required|max:15',
                'id_dokter'     => 'required',
            ];
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

            $email = strtolower($request->email);

            $existUser = Web_user::where('email', $email)->first();
            if (! is_null($existUser)) {
                return Helper::generalResponse(false, __('validation.unique', ['attribute' => 'email']), [], 400);
            }
            $payload = [
                'name'      => $request->name,
                'email'     => $email,
                'phone'     => $request->phone,
                'id_dokter' => $request->id_dokter,
                'status'    => 1,
                'group'     => 2000,
                'conf_email_status'    => 0,
                'via'       => 'app',
                'conf_code' => Helper::UUID(),
                'reset_pass_code' => Helper::UUID()
            ];
            $data = Web_user::firstOrCreate($payload);
            if(!$data){
                return Helper::generalResponse(false, 'Failed to create new account doktor.', [], 500);
            }
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            report($e);
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function update(Request $request){
        try{
            $rule = [
                'id_user'       => 'required',
                'name'          => 'max:150',
                'email'         => 'email|unique:web_user',
                'phone'         => 'max:15',
            ];
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

            $data = Web_user::where('id', $request->id_user)->first();
            if(is_null($data)){
                return Helper::generalResponse(false, 'User tidak ditemukan.', [], 400);
            }
            $data->name         = $request->name ?? $data->name ;
            $data->email        = $request->email ?? $data->email;
            $data->phone        = $request->phone ?? $data->phone;
            $data->save();
            if(!$data){
                return Helper::generalResponse(false, 'Cannot Update Data', $data, 400);
            }
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Error Update Data Users', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function scheduleAppointmentOld(Request $request){
        try {
            $where = "";
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where .= "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where .= "AND trx.date_consul > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where .= " AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
            $sql = "SELECT 
                        trx.*,
                        rp.name as dokter_name,
                        wu.photo
                    FROM trx_history_telmed trx
                    LEFT JOIN res_partner rp ON
                        trx.id_dokter = rp.id
                    LEFT JOIN web_user wu ON
                        wu.id_dokter = trx.id_dokter
                    WHERE 1=1 $where 
                    AND trx.trx_status = '".$status."'
                    AND trx.id_dokter IS NOT NULL 
                    ORDER BY trx.date_consul ASC";

            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->groupBy('id_dokter')->mapWithKeys(function($val, $key) {
                $res =  collect($val->toArray())->map(function ($map){
                    $img_holder = asset('img/no_image.png');
                    $map->avatar= (! isset($map->photo) || is_null($map->photo) || $map->photo == '') ? $img_holder : Helper::generateImgUrl('user_web', $map->photo);
                    $deskripsi =  $map->time_consul." with ". $map->dokter_name;
                    
                    $map = [
                        "id" => $map->id,
                        "cust_name" => $map->cust_name,
                        "dokter_name" => $map->dokter_name,
                        "avatar" => $map->avatar,
                        "date_consul" => $map->date_consul,
                        "time_consul" => $map->time_consul,
                        "deskripsi" => $deskripsi,
                    ];
                    return $map;
                });
                $where = "AND p.id = '" . $key . "'";
                $dokter  = $this->REPO->listDokter($where);
                
                $map = [
                    $dokter->first()->name??"-" => $res
                ];
                return $map;
            });
            if($result->empty()){
                $result = [
                    "dr. Ummi Chairani Harahap" => [
                        [
                            "id" => 5,
                            "cust_name" => "dummy test",
                            "dokter_name" => "dr. Ummi Chairani Harahap",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-20",
                            "time_consul" => "09:00:00",
                            "end_consul" => "09:30:00",
                            "end_consul" => "09:30:00",
                            "deskripsi" => "09:00:00 with dr. Ummi Chairani Harahap",
                        ],
                        [
                            "id" => 6,
                            "cust_name" => "dummy test1",
                            "dokter_name" => "dr. Ummi Chairani Harahap",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-21",
                            "time_consul" => "10:00:00",
                            "end_consul" => "10:30:00",
                            "deskripsi" => "10:00:00 with dr. Ummi Chairani Harahap",
                        ],
                        [
                            "id" => 7,
                            "cust_name" => "dummy test2",
                            "dokter_name" => "dr. Ummi Chairani Harahap",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-22",
                            "time_consul" => "11:00:00",
                            "end_consul" => "11:30:00",
                            "deskripsi" => "11:00:00 with dr. Ummi Chairani Harahap",
                        ],
                        [
                            "id" => 8,
                            "cust_name" => "dummy test3",
                            "dokter_name" => "dr. Ummi Chairani Harahap",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-23",
                            "time_consul" => "12:00:00",
                            "end_consul" => "12:30:00",
                            "deskripsi" => "12:00:00 with dr. Ummi Chairani Harahap",
                        ]
                    ],
                    "dr. Enjelita" => [
                        [
                            "id" => 10,
                            "cust_name" => "dummy test",
                            "dokter_name" => "dr. Enjelita",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-22",
                            "time_consul" => "09:00:00",
                            "end_consul" => "09:30:00",
                            "deskripsi" => "09:00:00 with dr. Enjelita",
                        ],
                        [
                            "id" => 11,
                            "cust_name" => "dummy test1",
                            "dokter_name" => "dr. Enjelita",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-23",
                            "time_consul" => "15:00:00",
                            "end_consul" => "15:30:00",
                            "deskripsi" => "15:00:00 with dr. Enjelita",
                        ],
                        [
                            "id" => 12,
                            "cust_name" => "dummy test2",
                            "dokter_name" => "dr. Enjelita",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-24",
                            "time_consul" => "14:00:00",
                            "end_consul" => "14:30:00",
                            "deskripsi" => "14:00:00 with dr. Enjelita",
                        ],
                        [
                            "id" => 13,
                            "cust_name" => "dummy test3",
                            "dokter_name" => "dr. Enjelita",
                            "avatar" => "http://medical_plaza.andri/assets/img/no_image.png",
                            "date_consul" => "2023-06-25",
                            "time_consul" => "13:00:00",
                            "end_consul" => "13:30:00",
                            "deskripsi" => "13:00:00 with dr. Enjelita",
                        ]
                    ]
                    
                ];
            }
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List schedule', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function dokterAppointment(Request $request){
        try {
            $where = "";
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where .= "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where .= "AND trx.date_consul > now() - interval '30' day";
            }
            // if($this->me->group == '2000'){
            //     $where .= " AND trx.id_dokter = ".$this->me->id_dokter."";
            // }
            $status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
            $sql = "SELECT 
                        trx.*,
                        rp.name as dokter_name,
                        wu.photo
                    FROM trx_history_telmed trx
                    LEFT JOIN res_partner rp ON
                        trx.id_dokter = rp.id
                    LEFT JOIN web_user wu ON
                        wu.id_dokter = trx.id_dokter
                    WHERE 1=1 $where 
                    -- AND trx.trx_status = '".$status."'
                    AND trx.id_dokter IS NOT NULL 
                    ORDER BY trx.date_consul ASC";

            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->groupBy('id_dokter')->map(function($res) {
                $map = [
                    "id"            => $res->first()->id_dokter,
                    "dokter_name"   => $res->first()->dokter_name,
                ];
                return $map;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List schedule', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function scheduleAppointment(Request $request){
        try {
            $where = [];
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.date_consul > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where[] = " AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            if (!is_null($request->query('status'))) {
                $where[] = " AND trx.trx_status = '" . $request->query('status') . "'";
            }
            
            if (!is_null($request->query('id_dokter'))) {
                if(is_array($request->id_dokter)){
                    $ids = $request->id_dokter;
               } else {
                   if(!$ids = json_decode($request->id_dokter, true)){
                       throw new \Exception("Error id_dokter not valid");
                   }
               }
               $id_dokter = implode(",",$ids);
               $where[] = "AND trx.id_dokter IN($id_dokter)";
            }
            $where_str = implode(" ",$where);
            // $status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
            $sql = "SELECT 
                        trx.*,
                        rp.name as dokter_name,
                        wu.photo
                    FROM trx_history_telmed trx
                    LEFT JOIN res_partner rp ON
                        trx.id_dokter = rp.id
                    LEFT JOIN web_user wu ON
                        wu.id_dokter = trx.id_dokter
                    WHERE 1=1 $where_str 
                    AND trx.id_dokter IS NOT NULL 
                    ORDER BY trx.date_consul ASC";

            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->map(function($res) {
                $title =  $res->dokter_name." with ". $res->cust_name;
                $map = [
                    "id"            => $res->id_dokter,
                    "start"         => Carbon::parse($res->date_consul." ". $res->time_consul)->toDateTimeString()??"-" ,
                    "end"           => Carbon::parse($res->date_consul." ". $res->time_consul)->addMinutes(30)->toDateTimeString()??"-",
                    "title"         => $title,
                    "url"           => "",
                    "trx_status"    => $res->trx_status,
                    "allDay"        => false,
                    "extendedProps" => [
                        "calendar" => $res->dokter_name,
                        "guests"=> [$res->cust_name]
                    ]
                ];
                return $map;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List schedule', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function detailDokter(Request $request)
    {
        $rule = [
            'id_dokter'     => 'required',

        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where ="";
            if (!is_null($request->query('id_dokter'))) {
                $where .= "AND p.id = '" . $request->query('id_dokter') . "'";
            }
            $data  = $this->REPO->listDokter($where);
            $result = collect($data)->map(function($res){
                $res->price = (int) $res->price;
                $res->avatar= Helper::setAvatar($res->name);

                return $res;
            })->values()->toArray();
            
            return Helper::generalResponse(true, 'Success', $result[0]);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Get dokter detail Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter detail Failed", [], 500);
        }  
    }
    public function addSchedule(Request $request)
    {
        $rule = [
            'id_dokter'     => 'required',
            'day_code'      => 'required|in:0,1,2,3,4,5,6',
            'start_time'    => 'required|date_format:H:i',
            'end_time'      => 'required|date_format:H:i|after:start_time',
        ];
        $schedule = Schedule_dokter::where('id_dokter',$request->id_dokter)
                    ->where('day_code',$request->day_code)
                    ->get();
        foreach($schedule as $val){
            $startTime = Carbon::createFromFormat('H:i', $request->get('start_time'));
            $endTime = Carbon::createFromFormat('H:i', $request->get('end_time'));

            $time_start = Carbon::createFromFormat('H:i:s', $val->start_time)->format('H:i');
            $time_end = Carbon::createFromFormat('H:i:s', $val->end_time)->format('H:i');

            $check_start =Carbon::createFromFormat('H:i', $time_start)->between($startTime, $endTime, true);
            $check_end =Carbon::createFromFormat('H:i', $time_end)->between($startTime, $endTime, true);
            if($check_start || $check_end){
                return Helper::generalResponse(false, 'Schedule cannot be between existing schedules ', [], 400);
            }
        }
       
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        
        try{
            $data = Schedule_dokter::firstOrCreate([
                'id_dokter'     => $request->id_dokter,
                'day_code'      => $request->day_code,
                'day'           => Library::getDay($request->day_code),
                'start_time'    => $request->start_time,
                'end_time'      => $request->end_time,
            ]);

            return Helper::generalResponse(true, 'Success', $data);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Add dokter schedule Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter schedule Failed", [], 500);
        }  
    }
    public function addScheduleHoliday(Request $request)
    {
        $rule = [
            'id_dokter'         => 'required',
            'date_holiday'      => 'required|date_format:Y-m-d',
            'date_end_holiday'  => 'required|date_format:Y-m-d|after_or_equal:date_holiday',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        
        try{
            $data = Schedule_dokter_holiday::firstOrCreate([
                'id_dokter'         => $request->id_dokter,
                'date_holiday'      => $request->date_holiday,
                'date_end_holiday'  => $request->date_end_holiday,
            ]);

            return Helper::generalResponse(true, 'Success', $data);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Add dokter schedule holiday Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter schedule holiday Failed", [], 500);
        }  
    }
    public function updateScheduleHoliday(Request $request)
    {
        $rule = [
            'id_schedule'     => 'required',
            'date_holiday'    => 'required|date_format:Y-m-d',
            'date_end_holiday'  => 'required|date_format:Y-m-d|after_or_equal:date_holiday',

        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        $schedule = Schedule_dokter_holiday::where('id',$request->id_schedule)->first();
            if(is_null($schedule)){
                Helper::LogDashboard('error', 'Schedule holiday dokter tidak ditemukan', []);
                return Helper::generalResponse(false, 'Schedule holiday dokter tidak ditemukan', [], 400);
            }
        try{
            $schedule->date_holiday = $request->date_holiday;
            $schedule->date_end_holiday = $request->date_end_holiday;
            $schedule->save();
            Helper::LogDashboard("info", "Update Schedule Holiday Dokter Success", []);
            return Helper::generalResponse(true, 'Success', $schedule);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Update dokter schedule holiday Failed", $e->getMessage());
            return Helper::generalResponse(false, "Update dokter schedule holiday Failed", [], 500);
        }  
    }
    public function deleteScheduleHoliday(Request $request){
        $rule = [
            'id_schedule'        => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        if($this->me->group != '3000'){
            Helper::LogDashboard('warning',"Delete Schedule Holiday Dokter", ["message" => "User not allowed"]);
            return Helper::generalResponse(false, 'User not allowed', []);
        }
        try{
            $schedule = Schedule_dokter_holiday::where('id',$request->id_schedule)->first();
            if(is_null($schedule)){
                Helper::LogDashboard('error', 'Schedule holiday dokter tidak ditemukan', []);
                return Helper::generalResponse(false, 'Schedule holiday dokter tidak ditemukan', [], 400);
            }
            $delete = Schedule_dokter_holiday::where('id', $request->id_schedule)->delete();
            Helper::LogDashboard("info", "Delete Schedule Holiday Dokter Success", []);
            return Helper::generalResponse(true, 'Success Delete Schedule Holiday Dokter', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Delete Schedule Holiday Dokter Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);

        }
    }
    public function deleteScheduleDokter(Request $request){
        $rule = [
            'id_schedule'        => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        if(!in_array($this->me->group,[2001,3000,2002]) ){
            Helper::LogDashboard('warning',"Delete Schedule Dokter", ["message" => "User not allowed"]);
            return Helper::generalResponse(false, 'User not allowed', []);
        }
        try{
            $schedule = Schedule_dokter::where('id',$request->id_schedule)->first();
            if(is_null($schedule)){
                Helper::LogDashboard('error', 'Schedule dokter tidak ditemukan', []);
                return Helper::generalResponse(false, 'Schedule dokter tidak ditemukan', [], 400);
            }
            $delete = Schedule_dokter::where('id', $request->id_schedule)->delete();
            Helper::LogDashboard("info", "Delete Schedule Dokter Success", []);
            return Helper::generalResponse(true, 'Success Delete Schedule Dokter', []);
        }catch(Exception $e){
            Helper::LogDashboard('error','Delete Schedule Dokter Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);

        }
    }
    public function listScheduleDokterHoliday(Request $request)
    {
        try{
            $where = [];
            $limit = 10;
            
            if ($request->has('limit')) {
                $limit = $request->limit;
            } 
             // Filter date
             if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(sd.date_holiday) >= '" . $from . "' AND date(sd.date_holiday) <= '" . $to . "'";
            }
            if (!is_null($request->query('id_dokter'))) {
                $where[] = "AND sd.id_dokter = '" . $request->query('id_dokter') . "'";
            }
            if($this->me->group == '2000'){
                $where[] = "AND sd.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $data  = $this->REPO->listHolidayDokter($where_str);
            $result = collect($data)->map(function($res){
                $img_holder = asset('img/no_image.png');
                $res->avatar = (! isset($res->photo) || is_null($res->photo) || $res->photo == '') ? $img_holder : Helper::generateImgUrl('user_web', $res->photo);
                return $res;
            })->values()->toArray();
            
            if(!is_null($request->query('limit'))){
                $result = Helper::setPaginate(Helper::arrayPaginator($result,$request, $limit));
            }else{
                $result = Helper::setData($result);
            }
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Get dokter Schedule holiday Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter Schedule holiday list Failed", [], 500);
        }  
    }
    public function updateSchedule(Request $request)
    {
        $rule = [
            'id_schedule'   => 'required',
            'day_code'      => 'required|in:0,1,2,3,4,5,6',
            'start_time'    => 'required|date_format:H:i',
            'end_time'      => 'required|date_format:H:i|after:start_time',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

        try{
            $schedule = Schedule_dokter::where('id',$request->id_schedule)->first();
            if(is_null($schedule)){
                Helper::LogDashboard('error', 'Schedule tidak ditemukan', []);
                return Helper::generalResponse(false, 'Schedule tidak ditemukan', [], 400);
            }
            $schedule_check = Schedule_dokter::whereNotIn('id',[$request->id_schedule])
                                ->where('id_dokter',$schedule->id_dokter)
                                ->where('day_code', $schedule->day_code)
                                ->get();
            foreach($schedule_check as $val){
                $startTime = Carbon::createFromFormat('H:i', $request->start_time);
                $endTime = Carbon::createFromFormat('H:i', $request->end_time);
    
                $time_start = Carbon::createFromFormat('H:i:s', $val->start_time)->format('H:i');
                $time_end = Carbon::createFromFormat('H:i:s', $val->end_time)->format('H:i');
    
                $check_start =Carbon::createFromFormat('H:i', $time_start)->between($startTime, $endTime, true);
                $check_end =Carbon::createFromFormat('H:i', $time_end)->between($startTime, $endTime, true);
                if($check_start || $check_end){
                    return Helper::generalResponse(false, 'Schedule cannot be between existing schedules ', [], 400);
                }
            }

            $schedule->day_code     = $request->day_code ;
            $schedule->day          = Library::getDay($request->day_code) ;
            $schedule->start_time   = $request->start_time ;
            $schedule->end_time     = $request->end_time;
            $schedule->save();

            return Helper::generalResponse(true, 'Success', $schedule);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Update schedule dokter Failed", $e->getMessage());
            return Helper::generalResponse(false, "Update schedule dokter Failed", [], 500);
        }  
    }
    public function syncDataDokter()
    {
        try{
            $result  = $this->REPO->syncDataDokter();
            return Helper::generalResponse(true, 'Success', []);
        } catch(Exception $e){
            report($e);
            Helper::LogDashboard("error","Synchronize data dokter Failed", $e->getMessage());
            return Helper::generalResponse(false, "Synchronize data Failed", [], 500);
        }  
    }
    public function status(Request $request){
        $rule = [
            'id_user'      => 'required',
            'status'       => 'required|in:0,1',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $dokter = Web_user::where('id',$request->id_user)->first();
            if(is_null($dokter)){
                Helper::LogDashboard('error', 'Dokter tidak ditemukan', []);
                return Helper::generalResponse(false, 'Dokter tidak ditemukan', [], 400);
            }
            $dokter->status = $request->status;
            $dokter->save();
            return Helper::generalResponse(true, 'Success update status dokter', []);
        } catch(\Exception $e){
            report($e);
            Helper::LogDashboard("error","Update status Dokter failed", $e->getMessage());
            return Helper::generalResponse(false, "Update status Dokter failed", [], 500);
        }
    }
    
}
