<?php

namespace App\Http\Controllers\Web\Telemedicine;

use Helper;
use Library;
use Carbon\Carbon;
use App\Models\User;
use App\Services\Firebase;
use Illuminate\Http\Request;
use App\Models\Mobile_status;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\map_status_notif;
use App\Models\Notifikasi;
use App\Models\Trx_history_telmed;
use App\Repository\TelemedicineManager;
use Illuminate\Support\Facades\Http;
use App\Services\Validator\ValidatorManagerInterface;
use Exception;

class DashboardController extends Controller
{
    public $me;
    public $firebase;
    public $REPO;
    public $conn;

    public function __construct()
    {
        $this->me           = auth()->guard('web_users')->user();
        $this->firebase     = new Firebase();
        $this->REPO         = new TelemedicineManager();
        if(config('services.medikaplaza.telemedicine_mode') == 'production'){
            $this->conn        = DB::connection('pgsql');
        }else{
            $this->conn        = DB::connection('stag_medika');
        }
    }
    public function listApointment(Request $request)
    {
        $rule = [
            'date_start'      => 'nullable|date_format:Y-m-d',
            'date_stop'       => 'nullable|date_format:Y-m-d',
            'gender'          => 'nullable|in:male,female',
            'type'            => 'nullable|in:member,non_member,retail',
            'status'          => 'nullable|in:pending,confirm,reject,reschedule,ongoing,done',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where ="";
            if (!is_null($request->query('gender'))) {
                $where .= "AND trx.gender = '" . $request->query('gender') . "'";
            }
            if (!is_null($request->query('type'))) {
                $where .= "AND trx.patient_type = '" . $request->query('type') . "'";
            }
            if (!is_null($request->query('status'))) {
                $where .= "AND trx.status = '" . $request->query('status') . "'";
            }
            if (!is_null($request->query('search'))) {
                $where .= "AND (trx.trx_no ILIKE '%".$request->query('search')."%' OR trx.cust_name ILIKE '%".$request->query('search')."%')";
            }
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where .= "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where .= "AND trx.date_consul > now() - interval '30' day";
            }
            $result  = $this->REPO->listApointment($where);
            Helper::LogDashboard("info", "Success", $result);
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::LogDashboard('error','Appointment Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function dashboard(Request $request){
        try {
            $where = [];
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.date_consul > now() - interval '30' day";
            }
            $where[] = "AND trx.date_consul > now() - interval '60' day";
            
            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);

            $sql = "SELECT * FROM trx_history_telmed trx WHERE 1=1 $where_str";
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data);

            $pending    = $result->where('trx_status','=', Trx_history_telmed::STS_PENDING)->count();
            $ongoing    = $result->where('trx_status','=', Trx_history_telmed::STS_ONGOING)->count();
            $done       = $result->where('trx_status','=', Trx_history_telmed::STS_DONE)->count();

            $overview = [
                'pending'   => $pending,
                'ongoing'   => $ongoing,
                'done'      => $done
            ];
            $gender = "Male";
            $data_gender = 10;
            $datasets = [
                "label"     => $gender,
                "data"      => $data_gender,
            ];
            $labels = $result->groupBy('date_consul')->map(function ($label){
                return $label->pluck('date_consul');
            })->keys();
            $chart = [
                "labels"    => $labels,
                "datasets"    => $datasets
            ];
            $data = [
                'overview'      => $overview,
                "waiting"       => "1500918",
                "ongoing"       => "1500918",
                "chart"         => $chart,
                "calendar"      => "1500918"
            ];
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List dashboard', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function overview(Request $request){
        try {
            $where = [];
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.date_consul > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $sql = "SELECT * FROM trx_history_telmed trx WHERE 1=1 $where_str";
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data);

            $pending    = $result->where('trx_status','=', Trx_history_telmed::STS_WAIT_CONFIRMATION)->count();
            $ongoing    = $result->where('trx_status','=', Trx_history_telmed::STS_ONGOING)->count();
            $done       = $result->where('trx_status','=', Trx_history_telmed::STS_DONE)->count();

            $data = [
                'pending'   => $pending,
                'ongoing'   => $ongoing,
                'done'      => $done
            ];
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List overview', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function waiting(Request $request){
        try {
            $where = [];
            $limit = 6;
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.date_consul > now() - interval '30' day";
            }
            $status = Trx_history_telmed::STS_WAIT_CONFIRMATION;
            $where[] = " AND trx.trx_status = '".$status."'";

            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);

            $sql = "SELECT * FROM trx_history_telmed trx WHERE 1=1 $where_str ORDER BY trx.created_at DESC LIMIT $limit";
            
            $data = $this->conn->select(DB::raw($sql));

            $result = collect($data)->map(function ($map) {
                return collect($map)
                    ->only(['id','cust_name','email','nik','trx_no','patient_type','date_consul','time_consul','trx_status'])
                    ->all();
            })->values()->toArray();

            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List waiting', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function today(Request $request){
        try {
            $where = [];
            $limit = 6;
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] = "AND date(trx.date_consul) = CURRENT_DATE";
            }
            $status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
            $where[] = " AND trx.trx_status = '".$status."'";

            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $sql = "SELECT * FROM trx_history_telmed trx WHERE 1=1 $where_str ORDER BY trx.created_at DESC LIMIT $limit";
            
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->map(function ($map) {
                return collect($map)
                    ->only(['id','cust_name','email','nik','trx_no','patient_type','date_consul','time_consul','trx_status'])
                    ->all();
            })->values()->toArray();

            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List today', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function finish(Request $request){
        try {
            $where = [];
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] =  "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] =  "AND trx.date_consul > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $sql = "SELECT * FROM trx_history_telmed trx WHERE 1=1 $where_str";
            
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->where('trx_status','=', Trx_history_telmed::STS_DONE);

            $data = $result->groupBy('date_consul')->map(function ($res){
                return $res;
            });

            $datasets = $result->groupBy('gender')->map(function ($item) use ($data) {
                $a = collect($data)->map(function ($res) use ($item){
                    return $res->where('gender',$item->first()->gender)->count() ;
                })->values();

                $map['labels']  = $item->first()->gender;
                $map['data']  = $a ;
                return $map;
                
            })->values()->toArray();

            $result = [
                "labels"    => $data->keys(),
                "datasets"  => $datasets
            ];
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List today', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function schedule(Request $request){
        try {
            $where = [];
            // Filter date
            if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(trx.date_consul) >= '" . $from . "' AND date(trx.date_consul) <= '" . $to . "'";
            } else{
                $where[] = "AND trx.date_consul > now() - interval '30' day";
            }
            if($this->me->group == '2000'){
                $where[] = "AND trx.id_dokter = ".$this->me->id_dokter."";
            }
            $where_str = implode(" ", $where);
            $sql = "SELECT * FROM trx_history_telmed trx WHERE 1=1 $where_str ORDER BY trx.created_at DESC";

            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->map(function ($map) {
                $map->avatar= Helper::setAvatar($map->cust_name);
                return collect($map)
                    ->only(['avatar','id','cust_name','trx_no','patient_type','date_consul','time_consul','trx_status'])
                    ->all();
            })->where('trx_status','=', Trx_history_telmed::STS_WAIT_APPOINTMNET)->sortBy('date_consule')->values()->all();

            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard('error','Error Get data List schedule', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
