<?php

namespace App\Http\Controllers\Web\Notifikasi;

use Helper;
use Library;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Web_user;
use App\Models\Notifikasi;
use App\Services\Firebase;
use Illuminate\Http\Request;
use App\Models\Notifikasi_web;
use App\Models\map_status_notif;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Services\Validator\ValidatorManager;
use App\Services\Validator\ValidatorManagerInterface;

class NotifikasiWebController extends Controller
{
    public $me;
    public function __construct()
    {
        $this->me          = auth()->guard('web_users')->user();
    }
    public function count()
    {
        try {
            $notif = Notifikasi_web::where('status', 0);
            if($this->me->group == '2000'){
                $notif = $notif->where('id_dokter', $this->me->id_dokter);
            }
            $notif = $notif->get()->count();
            return Helper::generalResponse(true, 'Success', $notif);
        } catch (\Exception $e) {
            Helper::LogDashboard("error",'Error Get count Notifikasi web', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }

    public function list(Request $request)
    {
        try {
            $notif = Notifikasi_web::select([
                'id',
                'id_user',
                'id_dokter',
                'label',
                'type',
                'text',
                'status',
                'created_at',
            ])
            ->orderBy('created_at', 'DESC')
            ->limit(20)->get();
            if($this->me->group == '2000'){
                $notif = $notif->where('id_dokter', $this->me->id_dokter);
            }
            // dd($request->get('status'));
            if (!is_null($request->query('status'))) {
                $notif = $notif->where('status', $request->get('status'));
            }else{
                $notif = $notif->where('status', 0);
            }
            $result = collect($notif)->map(function($res){
                $trxNo = '';
                try {
                    $t1 = explode('Appointment ', $res->text);
                    if (count($t1) > 1) {
                        $t2 = explode(' ', $t1[1]);
                        if (count($t2)) {
                            $trxNo = $t2[0];
                        }
                    }
                } catch (\Exception $e) {
                }

                $user = User::where('id',$res->id_user)->first();
                $img_holder = asset('img/no_image.png');
                $res->trx_no = $trxNo;
                $res->avatar = (! isset($user->photo) || is_null($user->photo) || $user->photo == '') ? $img_holder : Helper::generateImgUrl('user_web', $user->photo);
                return $res;
            })->values()->toArray();

            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::LogDashboard("error",'Error Get Notifikasi', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }

    public function status(Request $request){
        $rule = [
            'id'      => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        $ids = [];
        try{
            if(is_array($request->id)){
                 $ids = $request->id;
            } else {
                if(!$ids = json_decode($request->id, true)){
                    throw new \Exception("Error id not valid");
                }
            }
            $data = Notifikasi_web::whereIn("id", $ids)->update(["status" => 1]);
            return Helper::generalResponse(true, 'Success', $data);
        } catch(\Exception $e){
            Helper::LogDashboard("error","Update Status Failed", $e->getMessage());
            return Helper::generalResponse(false, "Gagal update status.", [], 500);
        }
    }
}
