<?php

namespace App\Http\Controllers;

use Helper;
use Library;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Profil;
use App\Mail\VerifyUser;
use App\Models\User_token;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Repository\TelemedicineManager;
use App\Services\Validator\ValidatorManagerInterface;

class UsersController extends Controller
{
    public $me;
    public $TELMED;
    public function __construct()
    {
        $this->me          = auth()->user();
        $this->TELMED      =  new TelemedicineManager();
    }
    public function list(Request $request){
        try {
            $data = User::where('id',$this->me->id);
            if (!is_null($request->query('name'))) {
                $data = $data->where('name', "like", "%" . $request->query('name') . "%");
            }
            if (!is_null($request->query('email'))) {
                $data = $data->where('email', "like", "%" . $request->query('email') . "%");
            }
            if (!is_null($request->query('status'))) {
                $data = $data->where('status', $request->query('status'));
            }
            //Fiter Limit Pagination
            if (!is_null($request->query('limit'))) {
                $data = $data->paginate($request->limit);
                foreach ($data as $val) {
                    $val->photo = Helper::generateImgUrl('user', $val->photo, true);
                }
                $result = Helper::setPagination($data);
            } else {
                $data = $data->get();
                foreach ($data as $val) {
                    $val->photo = Helper::generateImgUrl('user', $val->photo, true);
                    $val->relationship = Library::statusRelationship($val->relationship);
                    $val->member_type = Library::statusMember($val->member_type);
                }
                $result = Helper::setList($data);
            }
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::Log('error','Error Get Users List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function profile(Request $request){
        try {
            $sql = "";
            $sql = "SELECT
                        rp.name,
                        cp.name as company,
                        rp.classification_member,
                        rp.client_branch_id,
                        rp.division,
                        rp.division_id,
                        rp.member_client_id,
                        rp.gender,
                        rp.card_number,
                        rp.nik,
                        rp.birth_date,
                        rp.effective_date,
                        rp.join_date,
                        rp.start_date,
                        rp.end_date,
                        rp.marital_status,
                        rp.relationship,
                        rp.program_id,
                        rp.program_plan_id,
                        au.photo,
                        cpp.mobile_service_type,
                        cpp.service
                    FROM
                        res_partner rp
                    LEFT JOIN client_program cp ON
	                    cp.id = rp.program_id
                    LEFT JOIN client_program_plan cpp ON
	                    cpp.id = rp.program_plan_id
                    LEFT JOIN app_user au on
	                    au.card_number = rp.card_number
                    WHERE
                        rp.card_number = '".$this->me->card_number."'";
            $data = DB::select(DB::raw($sql));
            if(is_null($data) || empty($data)){
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }
            
            foreach ($data as $val) {
                $val->relation_ship_label = Library::statusRelationship($val->relationship);
                $val->gender_label = Library::statusGender($val->gender);
                $val->status_member = Library::statusMember($val->classification_member);
                $end_date           = Carbon::parse($val->end_date);
                $val->masa_berlaku  = $end_date->isoFormat('MMM YYYY');
                $val->photo = Helper::generateImgUrl('user', $val->photo, true);
                
                $reimburs = false;
                $hospital_portal = false;
                $hospital_portal = false;
                // Cek plan telmed
                $plan_telmed = $this->TELMED->checkPlanTelmed($val->card_number);
                if($plan_telmed->isEmpty()){
                    $has_telmed = false;
                }else{
                    $has_telmed = true;
                }
                if($val->mobile_service_type == 'cashless'){
                    $reimburs = false;
                    $hospital_portal = true;
                }else if($val->mobile_service_type == 'both'){
                    $reimburs = true;
                    $hospital_portal = true;
                }else if($val->mobile_service_type == 'reimburse'){
                    $reimburs = true;
                    $hospital_portal = false;
                }else if($val->mobile_service_type == 'no'){
                    $reimburs = false;
                    $hospital_portal = false;
                }else{
                    $reimburs = false;
                    $hospital_portal = false;
                }
                $val->has_reimburse = $reimburs;
                $val->has_hospital_portal = $hospital_portal;
                $val->has_telemedicine    = $has_telmed;
            }
            return Helper::generalResponse(true, 'Success', (object)$data[0]);
        } catch (\Exception $e) {
            Helper::Log('error','Error Get Profil', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function create(Request $request){
        try{
            $rule = self::rule();
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule['rule'],  []);

            $email = strtolower($request->email);

            $existUser = User::where('email', $email)->first();
            if (! is_null($existUser)) {
                return Helper::generalResponse(false, __('validation.unique', ['attribute' => 'email']), [], 400);
            }

            try{
                $payload = [
                    'name'      => $request->name,
                    'email'     => $email,
                    'password'  => Hash::make($request->password),
                    'phone'     => $request->phone,
                    'nik'       => $request->nik,
                    'nik_type'  => $request->nik_type,
                    'status'    => 1,
                    'conf_email_status'    => 0,
                    'conf_code' => Helper::UUID(),
                    'reset_pass_code' => Helper::UUID()
                ];
                $data = User::create($payload);
                if(!$data){
                    return Helper::generalResponse(false, 'Failed to create new account.', [], 500);
                }
                //** SEND EMAIL VERIFICATION */
                $send_mail = self::sendEmailConfirmation($data);
                if(!$send_mail){
                    Helper::Log('error','Error Send email to "'.$data->email.'"', 'Failed to send email confirmation.');
                }
                return Helper::generalResponse(true, 'Success', $data);
            }catch(Exception $e){
                report($e);
            }
        }catch(\Exception $e){
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function sendEmailConfirmation($user)
    {
        $link   = url('account/confirmation')."/$user->conf_code";
        Mail::to($user->email)->send(new VerifyUser($link, $user->toArray()));
        Helper::Log("info","Email Confirmation", ["message" => "Send email to $user->email", "link" => $link]);
        return true;
    }
    public function reSendEmailConfirmation()
    {
        try{
            $user = User::where('id', $this->me->id)->first();
            if(!$user){
                return Helper::generalResponse(false, 'Failed to get user.', [], 500);
            }
            $user->conf_email_status = 0;
            $user->save();
            $link   = url('account/confirmation')."/$user->conf_code";
            Mail::to($user->email)->send(new VerifyUser($link, $user->toArray()));
            Helper::Log("info","Resend Email Confirmation", ["message" => "Resend email to $user->email", "link" => $link]);
            return Helper::generalResponse(true, 'Success Resend Email', []);
        }catch(Exception $e){
            report($e);
        }
    }
    public function confirmation($code, Request $request){
        $data = self::userConfirmation($code);
        return view('pages.confirmation', $data);
    }
    public function update(Request $request){
        try{
            $rule = self::ruleUpdate();
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule['rule'],  []);

            $data = User::where('id', $this->me->id)->first();
            if(is_null($data)){
                return Helper::generalResponse(false, 'User tidak ditemukan.', [], 400);
            }
            $data->name         = $request->name ?? $data->name ;
            $data->email        = $request->email ?? $data->email;
            $data->nik          = $request->nik ?? $data->nik;
            $data->phone        = $request->phone ?? $data->phone;
            $data->save();
            if(!$data){
                return Helper::generalResponse(false, 'Cannot Update Data', $data, 400);
            }
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            Helper::Log('error','Error Update Data Users', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function membershipVerification(Request $request){
        try{
            $rule = ['card_number' => 'required'];
            $birth_date = $request->get('birth_date');
            if ($birth_date) {
                // soon make it required. add compability for old device, that dont have birth date param
                $rule['birth_date'] = 'required|date_format:Y-m-d';
            }
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
            try{
                $sql = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship,
                        DATE(birth_date) birth_date
                    FROM
                        res_partner
                    WHERE
                        card_number = '".$request->card_number."'";
                $member = DB::select(DB::raw($sql));
                if(is_null($member) || empty($member)){
                    return Helper::generalResponse(false, 'Classification Member Anda tidak ditemukan, Silahkan hubungi Medika Plaza.', [], 400);
                }
                if ($birth_date && $birth_date != $member[0]->birth_date) {
                    return Helper::generalResponse(false, 'Tanggal Lahir tidak sesuai.', [], 400);
                }
                try{
                    $data = User::where('id', $this->me->id)->first();
                    if(is_null($data)){
                        return Helper::generalResponse(false, 'User tidak ditemukan.', [], 400);
                    }
                    $data->member_no    = $member[0]->member_number ?? '-' ;
                    $data->card_number    = $member[0]->card_number ?? '-' ;
                    $data->relationship    = $member[0]->relationship ?? '-' ;
                    $data->member_type    = $member[0]->classification_member ?? 0;
                    $data->is_employee    = ($member[0]->relationship == 'E')?1:0;
                    $data->save();
                    if(!$data){
                        return Helper::generalResponse(false, 'Cannot Update Membership Number Data', $data, 400);
                    }
                    return Helper::generalResponse(true, 'Success', $data);
                }catch(Exception $e){
                    report($e);
                }
            }catch(Exception $e){
                report($e);
            }  
        }catch(\Exception $e){
            report($e);
            Helper::Log('error','Error Update Membership Number', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function resetMembership(){
        try{
            $data = User::where('id', $this->me->id)->first();
            if(is_null($data)){
                return Helper::generalResponse(false, 'User tidak ditemukan.', [], 400);
            }
            $data->member_no        = null;
            $data->card_number      = null ;
            $data->relationship     = null ;
            $data->member_type      = 0;
            $data->is_employee      = 0;
            $data->save();
            if(!$data){
                return Helper::generalResponse(false, 'Cannot Update Membership Data', $data, 400);
            }
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            report($e);
            Helper::Log('error','Error Update Membership', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function getMember(Request $request){
        try {
            $sql = "";
            //cek employee
            $is_employee = "";
            if(is_null($this->me->relationship) || is_null($this->me->card_number)|| is_null($this->me->member_no)){
               return Helper::generalResponse(false,  "Member not Verified", [], 500);
            }
            if ($this->me->relationship == 'E' || $this->me->is_employee == 1) {
                $is_employee = "AND member_no = '" . $this->me->member_no . "'";
            } else {
                $is_employee = "AND card_number = '" . $this->me->card_number . "'";
            }
            $sql = "SELECT
                        member_no,
                        card_number,
                        claim_name,
                        claim_relationship
                    FROM
                        v_user_member
                    WHERE
                        user_id = '".$this->me->id."'
                        $is_employee";
            $data = DB::select(DB::raw($sql));
            if(is_null($data) || empty($data)){
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }

        $rows = [];
        foreach($data as $i => $r) {
            $relationship = Library::statusRelationship($r->claim_relationship);
            // if no relation found, case when card number changed
            if ($relationship == null || $relationship == '-') continue;
            $r->claim_relationship = $relationship;
            $rows[] = $r;
        }

            return Helper::generalResponse(true, 'Success', $rows);
        } catch (\Exception $e) {
            Helper::Log('error','Error Get Profil member', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function switchMember(Request $request){
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required'],  []);
            if(is_null($this->me->relationship)){
                return Helper::generalResponse(false,  "Member not Verified", [], 500);
             }
             if ($this->me->relationship != 'E' && $request->card_number != $this->me->card_number && $this->me->is_employee == 0) {
                return Helper::generalResponse(false,  "Member not Allowed", [], 500);
             } 
            $sql = "";
            $sql = "SELECT
                        member_no,
                        card_number,
                        claim_name,
                        claim_relationship
                    FROM
                        v_user_member
                    WHERE
                        user_id = '".$this->me->id."'
                        AND card_number = '".$request->card_number."'";
            $member = DB::select(DB::raw($sql));
            if(is_null($member) || empty($member)){
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }
            $data = User::where('id', $this->me->id)->first();
            if(is_null($data)){
                return Helper::generalResponse(false, 'User tidak ditemukan.', [], 400);
            }
            $data->member_no    = $member[0]->member_no ?? '-' ;
            $data->card_number    = $member[0]->card_number ?? '-' ;
            $data->relationship    = $member[0]->claim_relationship ?? '-' ;
            $data->save();
            if(!$data){
                return Helper::generalResponse(false, 'Cannot Switch Membership', $data, 400);
            }
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            Helper::Log('error','Error Switch Membership Number', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function photo(Request $request){

        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['photo' => 'required'],  []);
        try {
            $user = User::where('id', $this->me->id)->firstOrFail();
            $img = Helper::uploadImg("photo", 'user', 'profile');
            if (!$img) {
                return Helper::generalResponse(false, "Gagal upload foto.", [], 400);
            }
            $user->photo = $img;
            $user->save();
            Helper::Log("info",'Update photo profile success', ['file_name' => $img]);
            return Helper::generalResponse(true, 'Success', $user);
        } catch(\Exception $e){
            Helper::Log("error","Update photo profile failed", $e->getMessage(), $e);
            return Helper::generalResponse(false, "Gagal upload foto.", [], 500);
        }

    }
    public function set_token(Request $request)
    {
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['token_device'=> 'required']);
        try{
            $user = User::where('id', $this->me->id)->first();
            if(!$user){
                return Helper::generalResponse(false, 'Failed to get user.', [], 500);
            }
            $data = User_token::firstOrCreate([
                'id_user'       => $this->me->id,
                'token_device'  => $request->token_device,
            ]);
            if(!$data){
                return Helper::generalResponse(false, 'Failed to create token.', [], 500);
            }
            
            return  Helper::generalResponse(true, "Sukses", []);
        } catch (\Exception $e) {
            Helper::Log('error','Set Token Device Failed', $e->getMessage(), $e);
            return Helper::generalResponse(false, 'Gagal', 'Set Token Device Failed', 500);
        }
    }
    public function unset_token(Request $request)
    {
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['token_device'=> 'required']);
        try{
            $user = User::where('id', $this->me->id)->first();
            if(!$user){
                return Helper::generalResponse(false, 'Failed to get user.', [], 500);
            }
            $data = User_token::where('token_device', $request->token_device)->firstOrFail()->delete();
            if(!$data){
                return Helper::generalResponse(false, 'Failed to delete token.', [], 500);
            }
            Helper::Log('info','Delete Token Device Success', ['id'=>$this->me->id, 'email' => $this->me->email, 'token' => $request->token ]);
            return  Helper::generalResponse(true, "Sukses", []);
        } catch (\Exception $e) {
            Helper::Log('error','Delete Token Device Failed', $e->getMessage(), $e);
            return Helper::generalResponse(false, 'Gagal', 'Delete Token Device Failed', 500);
        }
    }
    public function unset_user(Request $request)
    {
        try{
            $user = User::where('id', $this->me->id)->first();
            if(!$user){
                return Helper::generalResponse(false, 'Failed to get user.', [], 500);
            }
            $user_email = explode("@",$user->email);

            $email = $user_email[0].Helper::codeGenerator(5). "@".$user_email[1];
            $user->email = $email;
            $user->deleted_at = Carbon::now();
            
            $user->save();
            Helper::Log('info','Delete user success', ['id'=>$this->me->id, 'email' => $this->me->email ]);
            return  Helper::generalResponse(true, "Sukses", []);
        } catch (\Exception $e) {
            Helper::Log('error','Delete user Failed', $e->getMessage(), $e);
            return Helper::generalResponse(false, 'Gagal', 'Delete user Failed', 500);
        }
    }
    private static function rule(){
        return $arrayValid = [
            'rule'=>[
                'name'          => 'required|max:150',
                'email'         => 'required|email|unique:app_user',
                'password'      => 'required|min:6',
                'nik_type'      => 'required|in:nik,kitas,pasport,nip',
                'phone'         => 'max:15',
                'phone'         => 'required|max:15',
            ],
            'message'=>[
            ]
        ];
    }
    private static function ruleUpdate(){
        return $arrayValid = [
            'rule'=>[
                'name'          => 'max:150',
                'email'         => 'email|unique:app_user',
                'phone'         => 'max:15',
            ],
            'message'=>[
            ]
        ];
    }
    public function userConfirmation($code)
    {
        $result = [];
        $user = User::where("conf_code", $code)
                    ->where('conf_email_status', 0)
                    ->first();
        if(!$user){
            return [
                'status'    => false,
                'message'   => "Kode konfirmasi sudah tidak berlaku!"
            ];
        }
        try{
            User::where("id", $user->id)
                    ->update([
                        "conf_email_status"     => 1,
                        "conf_code"             => Helper::UUID(),
                        "email_verified_at"     => date('Y-m-d H:i:s')
                    ]);
            return [
                'status'    => true,
                'message'   => "Terima kasih! email anda telah terkonfirmasi."
            ];
        } catch(\Exception $e){
            return [
                'status'    => false,
                'message'   => $e->getMessage()
            ];
        }
    }

}
