<?php

namespace App\Http\Controllers\Telemedicine;

use Helper;
use Library;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Http\Request;
use App\Repository\QiscusManager;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\Otp_log;
use App\Models\Otp_verify;
use Illuminate\Support\Facades\Http;
use App\Services\Validator\ValidatorManagerInterface;

class WhatsappController extends Controller
{
    public $me;
    public $firebase;
    public $qiscus;
    public function __construct()
    {
        $this->me           = auth()->user();
        $this->qiscus       = new QiscusManager();
    }
    public function status(Request $request)
    {
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['msisdn' => 'required'],  []);
        try{
            $data = Otp_verify::where('msisdn',$request->msisdn)->first();
            $message = (!!$data) ? Otp_verify::STS_VERIFIED : Otp_verify::STS_NOTVERIFIED;
            return Helper::generalResponse(true, $message, []);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get status Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get status Failed", [], 500);
        }  
    }
    public function request(Request $request)
    {
        Helper::Log("info", "Send OTP Request", ['request'=>$request->all(),'path'=>$request->url()]);
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['msisdn'   => ['required', 'regex:/^(^\+62|62|^0)(\d{3,4}-?){2}\d{3,4}$/']],  []);
        try{
            $msisdn         = $request->msisdn;
            $otp            = Helper::otpGenerator();
            // Send Otp
            $res = self::sendOtp($msisdn, $otp);
            if (!isset($res) || is_null($res)) {
                throw new \Exception("Send OTP Wa Failed");
            }
            // ** Insert to table otp
            if(!!$res){
                $otp_log = Otp_log::create([
                    'id_user'   => $this->me->id,
                    'msisdn'    => $msisdn,
                    'status'    => Otp_log::STS_PENDING,
                    'code_otp'  => $otp,
                ]);
                Helper::Log("info", "Success", [$res]);
                return Helper::generalResponse(true, 'Success', $otp_log->id);
            }
        }catch(\Exception $e){
            Helper::Log('error','Send OTP Wa Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
   
    public function resend(Request $request)
    {
        Helper::Log("info", "ReSend OTP Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $rule = [
            'msisdn'   => ['required', 'regex:/^(^\+62|62|^0)(\d{3,4}-?){2}\d{3,4}$/'],
            'id'       => 'required'
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $msisdn         = $request->msisdn;
            $id             = $request->id;
            $otp            = Helper::otpGenerator();
            // ReSend Otp
            $res = self::sendOtp($msisdn, $otp);
            if (!isset($res) || is_null($res)) {
                throw new \Exception("ReSend OTP Wa Failed");
            }
            // ** Insert to table otp
            if(!!$res){
                $otp_log = Otp_log::where('id',$id)->where('msisdn', $msisdn)->firstOrFail();
                $otp_log->status = Otp_log::STS_RESEND;
                $otp_log->code_otp = $otp;
                $otp_log->created_at = Carbon::now();
                $otp_log->save();
                Helper::Log("info", "Success", [$res]);
                return Helper::generalResponse(true, 'resend', []);
            }
        }catch(\Exception $e){
            report($e);
            Helper::Log('error','ReSend OTP Wa Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }
    public function submit(Request $request)
    {
        Helper::Log("info", "Submit OTP Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $rule = [
            'id'        => 'required',
            'otp'       => 'required'
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $id             = $request->id;
            $otp            = $request->otp;
            $sql = "SELECT
                        id_user,
                        msisdn,
                        status,
                        code_otp,
                        created_at
                    FROM
                        otp_log
                    WHERE 
                        id_user = '".$this->me->id."'
                        AND id = '".$id."'
                        AND code_otp = '".$otp."'";
            $data = DB::select(DB::raw($sql));
            $result = collect($data)->values()->toArray();
            $message = Otp_log::STS_NOTMATCH;
            if(is_null($result) || empty($result)){
                $message = Otp_log::STS_NOTMATCH;
                return Helper::generalResponse(true, $message, []);
            }
            
            if($result[0]->code_otp == $otp){
                $message = Otp_log::STS_VERIFIED;
            }
            $date_now = Carbon::now();
            $is_expired = $date_now->greaterThan(Carbon::create($result[0]->created_at)->addMinutes(2));
            if($is_expired){
                $message = Otp_log::STS_EXPIRED;
            }
            // ** Insert to table otp verify
            if($message == Otp_log::STS_VERIFIED){
                $otp_verify = Otp_verify::firstOrCreate([
                    'id_user'   => $this->me->id,
                    'msisdn'    => $result[0]->msisdn
                ]);

                // ** update otp log
                $otp_log = Otp_log::where('id',$id)->firstOrFail();
                $otp_log->status = Otp_log::STS_VERIFIED;
                $otp_log->save();
            }
            Helper::Log("info", "Success", [$result]);
            return Helper::generalResponse(true, $message, []);
        }catch(\Exception $e){
            report($e);
            Helper::Log('error','Submit OTP Wa Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        } 
    }
    public function sendOtp($msisdn, $otp){
        $headers = [
            "Qiscus-App-Id"     => env('QISCUS_APP_ID'),
            "Qiscus-Secret-Key" => env('QISCUS_SECRET_KEY'),
            "Content-Type"      => 'application/json'
        ];
        $payload = sprintf('{
            "to": "%s",
            "type": "template",
            "template": {
              "namespace": "0759bbc6_df4f_4bbb_a533_94beea4fb86c",
              "name": "otp_telemedicine",
              "language": {
                "policy": "deterministic",
                "code": "id"
              },
               "components": [
                      {
                          "type" : "body",
                          "parameters": [
                              {
                                  "type": "text",
                                  "text": "%s"
                              }
                         ]
                     }
                  ]
             }
          }', $msisdn, $otp);

        Helper::Log("info", "Send OTP Payload", [$payload]);
        $res = $this->qiscus->qiscus($headers,$payload);
        return $res;
    }
}
