<?php

namespace App\Http\Controllers\Telemedicine;

use Helper;
use Library;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\User;
use App\Services\Firebase;
use Illuminate\Http\Request;
use App\Models\Mobile_status;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\map_status_notif;
use App\Models\Notifikasi;
use App\Models\Trx_history_telmed;
use App\Repository\TelemedicineManager;
use Illuminate\Support\Facades\Http;
use App\Services\Validator\ValidatorManagerInterface;
use Exception;

class DokterController extends Controller
{
    public $me;
    public $firebase;
    public $REPO;

    public function __construct()
    {
        $this->me           = auth()->user();
        $this->firebase     = new Firebase();
        $this->REPO         = new TelemedicineManager();
    }
    public function listSpecialist(Request $request)
    {
        try{
            $result  = $this->REPO->listSpecialistMobile($request);
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get Specialist Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get Specialist Failed: ".$e->getMessage(), [], 500);
        }  
    }
    public function listDokter(Request $request)
    {
        $rule = [
            'id_specialist'      => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where ="";
            if (!is_null($request->query('id_specialist'))) {
                $where .= "AND k.id = '" . $request->query('id_specialist') . "'";
            }
            $data  = $this->REPO->listDokterMobile($where);
            $result = collect($data)->map(function($res){
                $res->price = (int) $res->price;
                $url = config('services.medikaplaza.api');
                if (is_null($res->photo)) {
                    if($res->jenis_kelamin == 'laki'){
                        $res->photo = sprintf('%s/dokter_pria.png', $url);
                    }else if($res->jenis_kelamin == 'perempuan'){
                        $res->photo = sprintf('%s/dokter_wanita.png', $url);
                    }else{
                        $res->photo = sprintf('%s/mp.png', $url);
                    }
                } else {
                    $res->photo = sprintf('%s/img/user_web/%s', $url, $res->photo);
                }

                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get dokter list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter list Failed", [], 500);
        }  
    }
    public function listScheduleDokter(Request $request)
    {
        $rule = [
            'id_dokter'     => 'required',
            'date'          => 'required|date_format:Y-m-d',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $day  = Carbon::parse($request->date)->format('l');

            $where ="";
            if (!is_null($request->query('id_dokter'))) {
                $where .= "AND sd.id_dokter = '" . $request->query('id_dokter') . "'";
            }
            if (!is_null($request->query('date'))) {
                $where .= "AND lower(sd.day) = '" . strtolower($day) . "'";
            }
            $result  = $this->REPO->listScheduleDokter($where);
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get dokter Scedule list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter Schedule list Failed", [], 500);
        }  
    }
    public function listScheduleDokterHoliday(Request $request)
    {
        $rule = [
            'id_dokter'   => 'required',
            'date_start'  => 'date_format:Y-m-d',
            'date_stop'   => 'date_format:Y-m-d',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $where = [];
             // Filter date
             if (!is_null($request->query('date_start'))) {
                $from = date($request->query('date_start'));
                $to = date($request->query('date_stop') ?? $request->query('date_start'));
                $where[] = "AND date(sd.date_holiday) >= '" . $from . "' AND date(sd.date_holiday) <= '" . $to . "'";
            }
            if (!is_null($request->query('id_dokter'))) {
                $where[] = "AND sd.id_dokter = '" . $request->query('id_dokter') . "'";
            }
            $where_str = implode(" ", $where);
            $data  = $this->REPO->listHolidayDokter($where_str);
            $result = collect($data)->map(function($res){
                $img_holder = asset('img/no_image.png');
                $res->avatar = (! isset($res->photo) || is_null($res->photo) || $res->photo == '') ? $img_holder : Helper::generateImgUrl('user_web', $res->photo);
                return $res;
            })->values()->toArray();
            
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get dokter Schedule holiday list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter Schedule holiday list Failed", [], 500);
        }  
    }
    public function listdayDokter(Request $request)
    {
        Helper::Log("info", "Schedule Day dokter Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $rule = [
            'id_dokter' => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $day  = Carbon::parse($request->date)->format('l');

            $where ="";
            if (!is_null($request->query('id_dokter'))) {
                $where .= "AND sd.id_dokter = '" . $request->query('id_dokter') . "'";
            }
            if (!is_null($request->query('date'))) {
                $where .= "AND lower(sd.day) = '" . strtolower($day) . "'";
            }
            $result  = $this->REPO->listScheduleDokter($where);
            $result = $result->groupBy('day_code')->map(function ($label){
                return $label->pluck('day_code');
            })->keys();
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get dokter Schedule Day MP ONE list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter Schedule MP ONE list Failed", [], 500);
        }  
    }

    public function listDateByDokter(Request $request)
    {
        $rule = [
            'id_dokter' => 'required|numeric',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

        $idDokter = $request->get('id_dokter');
        try{
            $dayOpen = $this->REPO->listScheduleDayDokter($idDokter);
            $holidayDate = $this->REPO->listScheduleHolidayDokter($idDokter);

            $today = Carbon::now();
            $futureDate = Carbon::now()->addDays(30);
            $dateRange = [];
            $dates = CarbonPeriod::create($today->format('Y-m-d'), $futureDate->format('Y-m-d'));
            foreach ($dates as $d) {
                $theDay = $d->format('Y-m-d');
                // the day is exist in schedule
                if (in_array((int) $d->format('w'), $dayOpen)) {
                    // the date is not a holiday
                    if (! in_array($theDay, $holidayDate)) {
                        $dateRange[] = $theDay;
                    }
                }
            }

            // todo check for ongoing telmed

            $result = $dateRange;

            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get dokter Schedule Day MP ONE list Failed", $e->getMessage());
            return Helper::generalResponse(true, 'Success', []);
            return Helper::generalResponse(false, "Get dokter Schedule MP ONE list Failed", [], 500);
        }  
    }

    public function listTimeByDokterDate(Request $request)
    {
        $rule = [
            'id_dokter'     => 'required',
            'date'          => 'required|date_format:Y-m-d',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $idDokter = $request->get('id_dokter');
            $dateSelect = $request->get('date');
            $theDay = Carbon::createFromFormat('Y-m-d', $dateSelect);
            $dayOpen = $this->REPO->listScheduleDayDokter($idDokter);
            $holidayDate = $this->REPO->listScheduleHolidayDokter($idDokter);
            $openTelmed = $this->REPO->listOpenTelmed($idDokter, $dateSelect);

            $dayCode = (int) $theDay->format('w');
            if (! in_array($dayCode, $dayOpen)) {
                return Helper::generalResponse(false, "Doctor is not registered for the Date", [], 400);
            }

            if (in_array($theDay->format('Y-m-d'), $holidayDate)) {
                return Helper::generalResponse(false, "Doctor is on Holiday", [], 400);
            }
            // Cek transaction is ongoing
            $trx = Trx_history_telmed::where('id_user',$this->me->id)
                    ->where('trx_status', Trx_history_telmed::STS_ONGOING)
                    ->whereDate('date_consul', $dateSelect)
                    ->first();
            if(!is_null($trx)){
                Helper::LogDashboard('error', 'Schedule appointment is ongoing', []);
                return Helper::generalResponse(false, 'Schedule appointment is ongoing', [], 400);
            }

            $times = [];
            $res_time = [];
            $currentDate = Carbon::now();
            $timeOpen = $this->REPO->listScheduleTimeDayDokter($idDokter, $dayCode);
            foreach ($timeOpen as $time) {
                $start = Carbon::createFromFormat('Y-m-d H:i:s', $dateSelect . ' ' . $time->start_time)->ceilHour();
                $stop = Carbon::createFromFormat('Y-m-d H:i:s', $dateSelect . ' ' . $time->end_time);
                while ($start->lt($stop)) {
                    $times[] = $start->format('H:i');
                    $start->addMinutes(30);
                }
            }

            $res_time = $times;
            if ($theDay->isToday()) {
                // if today, add buffer 30 minutes from now
                $theDay = Carbon::now()->addMinutes(30);

                $res_time = [];
                foreach($times as $time){
                    $t = Carbon::createFromFormat('Y-m-d H:i:s', $dateSelect . ' ' . $time.':00');
                    if($t->gt($theDay)){
                        $res_time[] = $time;
                    }
                }
            }

            $res_time_fix = [];
            foreach ($res_time as $t) {
                if (!in_array($t, $openTelmed)) {
                    $res_time_fix[] = $t;
                }
            }

            $res_time = collect($res_time_fix)->map(function($r) use ($dateSelect) {
                return Carbon::createFromFormat('Y-m-d H:i:s', $dateSelect . ' ' . $r.':00');
            })->sortBy(function($r) {
                return $r->timestamp;
            })
            ->map(function($r) {
                return $r->format('H:i');
            })
            ->unique()
            ->values()
            ->toArray();
            
            $result = $res_time;

            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get dokter Scedule list Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get dokter Schedule list Failed", [], 500);
        }  
    }
}
