<?php

namespace App\Http\Controllers\Reimbursement;

use Helper;
use Library;
use Carbon\Carbon;
use App\Models\Notifikasi;
use App\Services\Firebase;
use Illuminate\Http\Request;
use App\Models\Mobile_status;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\map_status_notif;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\Console\Input\Input;
use App\Services\Validator\ValidatorManagerInterface;
use Exception;

class ReimbursementController extends Controller
{
    public $me;
    public $firebase;
    public function __construct()
    {
        $this->me          = auth()->user();
        $this->firebase    = new Firebase();
    }
    public function reimbursement(Request $request)
    {
        Helper::Log("info", "Reimbursment Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $url = config('services.medikaplaza.reimburs');
        // $conn = DB::connection('stag_medika');

        $sql_check = "SELECT
                    rp.card_number,
                    rp.program_plan_id,
                    cpp.mobile_service_type
                FROM
                    res_partner rp
                LEFT JOIN client_program_plan cpp ON
                    cpp.id = rp.program_plan_id
                WHERE
                    rp.card_number = '".$this->me->card_number."'
                    AND cpp.mobile_service_type = 'no'";
        $check = DB::select(DB::raw($sql_check));
        if ($check) {
            Helper::Log("warning","Error Reimbursment", ["message" => "Reimbursment not allowed"]);
            return Helper::generalResponse(false, 'not allowed', [], 400);
        }

        $rule = [
            'card_number'       => 'required',
            'claim_category'    => 'required',
            'admission_date'    => 'required|date_format:Y-m-d',
            'claim_charge'      => 'required',
            'notes'             => 'required',
            'attachment_1'      => 'required|image', // minimum 1 file
        ];
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

            $card_number    = $request->card_number;
            $claim_category = $request->claim_category;
            $admission_date = $request->admission_date;
            $claim_charge   = $request->claim_charge;
            $notes          = $request->notes;
            $attachment     = (array) $request->file('attachment');
            $attc_file = [];

            foreach(range(1,5) as $ff) {
                if ($request->hasFile('attachment_'.$ff)) {
                    $val            = $request->file('attachment_'.$ff);
                    $file_encode    = base64_encode(file_get_contents($val->path()));
                    $name_file      = $val->getClientOriginalName();
                    $attc_file[]    = [
                                        "name"  => $name_file,
                                        "datas" => $file_encode
                                        ];
                }
            }

            $payload = sprintf('{
                    "params": { 
                        "card_number": "%s",
                        "claim_category": "%s",
                        "admission_date": "%s",
                        "claim_charge": "%s",
                        "notes": "%s",
                        "attachment": %s
                        }
                    }', $card_number, $claim_category, $admission_date, $claim_charge, $notes, json_encode($attc_file) );
            $response = Http::withBody(
                        $payload, 'text/plain'
                        )->post($url);
            $res = json_decode($response);
            
            if (!isset($res)|| is_null($res)) {
                \Log::info('reimbursement', ['res' => $response]);
                throw new \Exception("Reimbursment Failed");
            }
            //**Push notification */
            if(!!$res){
                $user = $this->firebase->getUserToken();
                try{
                    $sql = "SELECT
                                adm.id,
                                adm.claim_source,
                                adm.provider_id,
	                            rp.display_name 
                            FROM
                                mobile_apps_admission adm
                            LEFT JOIN res_partner rp ON 
	                            rp.id = adm.provider_id
                            WHERE 1=1
                                AND adm.card_number = '".$card_number."'
                                AND adm.claim_source = 'reimbursement'
                            ORDER BY adm.id DESC
                            LIMIT 1";
                    $admission = DB::select(DB::raw($sql));
                    if (is_null($admission) || empty($admission)) {
                        Helper::Log('error', 'Reimbursement tidak ditemukan', []);
                    }

                }catch(Exception $e){
                    Helper::Log('error', 'Get reimbursement to database Failed', $e->getMessage());
                }
                try{
                    $getStatus = map_status_notif::where("type","reimbursement")->where("status","requested")->first();
                    $id_admission = $admission[0]->id ?? '';
                    $label  = $getStatus['label']??"Claim Reimburment Requested";
                    $provider = $admission[0]->display_name ?? "";
                    $date_now = Carbon::now()->isoFormat('D-MM-YYYY');
                    $text   = sprintf($getStatus['message']??"Your Claim Reimburment Requested  has been successfully", $provider, $date_now);
    
                    $notif = [
                        'user'          => $user,
                        'id_admission'  => $id_admission,
                        'label'         => $label,
                        'type'          => "reimbursement",
                        'text'          => $text,
                    ];
                    //**notification */
                    $this->firebase->pushNotif($notif);
                }catch(Exception $e){
                    report($e);
                }
            }
            Helper::Log("info", "Success", $res->message);
            return Helper::generalResponse(true, 'Success', $res->message);
        }catch(\Exception $e){
            Helper::Log('error','Reimbursment Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
     public function reUploadReimbursment(Request $request)
    {
        Helper::Log("info", "Reupload reimbursment Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $url = config('services.medikaplaza.reupload');

        $rule = [
            'id_admission'       => 'required',
            'attachment_1'      => 'required|image|max:10240', // minimum 1 file
        ];
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

            $id_admission    = $request->id_admission;
            $attc_file = [];

            foreach(range(1,5) as $ff) {
                if ($request->hasFile('attachment_'.$ff)) {
                    $val            = $request->file('attachment_'.$ff);
                    $file_encode    = base64_encode(file_get_contents($val->path()));
                    $name_file      = $val->getClientOriginalName();
                    $attc_file[]    = [
                                        "name"  => $name_file,
                                        "datas" => $file_encode
                                        ];
                }
            }

            $payload = sprintf('{
                    "params": { 
                        "id_admission": %d,
                        "attachment": %s
                        }
                    }', $id_admission, json_encode($attc_file) );
            $response = Http::withBody(
                        $payload, 'text/plain'
                        )->post($url);
            $res = json_decode($response);
            
            if (!isset($res)|| is_null($res)) {
                \Log::info('reuploadbug', ['res' => $response]);
                throw new \Exception("Reupload file Reimbursment Failed");
            }
            //**Push notification */
            if(!!$res){
                try{
                    $user = $this->firebase->getUserToken();
                    // Cek admission
                    $sql = "";
                    $sql = "SELECT
                                adm.id,
                                adm.claim_source,
                                adm.card_number,
                                adm.provider_id,
                                rp.display_name 
                            FROM
                                mobile_apps_admission adm
                            LEFT JOIN res_partner rp ON 
                                rp.id = adm.provider_id
                            WHERE 1=1
                                AND adm.id = $id_admission";
                    $admission = DB::select(DB::raw($sql));
                    if (is_null($admission) || empty($admission)) {
                        Helper::Log('error', 'Admission tidak ditemukan', []);
                    }
                    $getStatus = map_status_notif::where("type","reimbursement")->where("status","reupload")->first();
                    $label  = $getStatus['label']??"Claim Reimburment Reupload";
                    $provider = $admission[0]->display_name ?? "";
                    $date_now = Carbon::now()->isoFormat('D-MM-YYYY');
                    $text   = sprintf($getStatus['message']??"Your Claim Reimburment has been Reupload", $provider, $date_now);

                    $notif = [
                        'user'          => $user,
                        'id_admission'  => $id_admission,
                        'label'         => $label,
                        'type'          => "reimbursement",
                        'text'          => $text,
                    ];
                    //**notification */
                    $this->firebase->pushNotif($notif);
                }catch(Exception $e){
                    report($e);
                }
            }
            Helper::Log("info", "Success", $res->message);
            return Helper::generalResponse(true, 'Success', $res->message);
        }catch(\Exception $e){
            Helper::Log('error','Reupload file Reimbursment Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function list(Request $request){
        $base_url = config('services.medikaplaza.attach');
        if (is_null($this->me->member_no) || is_null($this->me->card_number) || is_null($this->me->relationship)) {
            return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
        }
        
        try {
            // $conn = DB::connection('stag_medika');
            $sql = "";
            $where = "";
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $this->me->card_number . "'";
            $member = DB::select(DB::raw($cek));

            if ($member[0]->relationship == 'E') {
                $where .= "AND adm.member_number = '" . $this->me->member_no . "'";
            } else {
                $where .= "AND adm.card_number = '" . $this->me->card_number . "'";
            }

		    // $where .= "AND adm.card_number = '" . '2020400724120590' . "'";
            if (!is_null($request->query('id_admission'))) {
                $where .= "AND adm.id = '" . $request->query('id_admission') . "'";
            }
            $sql = "SELECT
                        adm.id,
                        adm.name,
                        gl.claim_number,
                        adm.letter_id,
                        adm.charge,
                        b.NAME as benefit,
                        adm.admission_date,
                        adm.state,
                        adm.claim_source,
                        g.approved_amount,
                        (select sum(fg.cover_amount) from final_gl fg where fg.letter_id= gl.id) as cover_amount,
                        g.real_cover_amount,
                        g.real_excess_amount,
                        cast(g.excess_amount as INT),
                        gl.amount_excess,
                        gl.amount_approved,
                        gl.payment_date as service_date,
                        gl.claim_status,
                        adm.notes
                    FROM
                        mobile_apps_admission adm
                    LEFT JOIN res_partner rp on
                        adm.card_number = rp.card_number
                    LEFT JOIN guarantee_letter gl on 
                        gl.id = adm.letter_id
                    LEFT JOIN lateral (
                        SELECT
                            *
                        FROM
                            final_gl
                        WHERE
                            gl.id = final_gl.letter_id
                        LIMIT 1
                                ) g ON
                        gl.id = g.letter_id
                    LEFT JOIN benefit_master b on
                        adm.benefit_master_id = b.id
                    WHERE 1=1
                        $where
                        AND adm.claim_source = 'reimbursement'
                    ORDER BY adm.id DESC";
            $data = DB::select(DB::raw($sql));
            if (!count($data)) {
                Helper::Log('error', 'Reimbursment Not Found', []);
                return Helper::generalResponse(true, 'Reimbursment Not Found', []);
            }
            $result = collect($data)->map(function($res)  use($base_url){
                $a = [];
                $sql_attach = "SELECT
                                    mobile_apps_admission_id,
                                    ir_attachment_id
                               FROM ir_attachment_mobile_apps_admission_rel
                               WHERE mobile_apps_admission_id = $res->id";
                $meta = collect(DB::select(DB::raw($sql_attach)));
                foreach ($meta as $j) {
                    $url_image = sprintf('%s%s', $base_url, $j->ir_attachment_id);
                    $a[] = $url_image;
                }
                //get detail
                $detail = [];
                if(isset($res->letter_id) || !is_null($res->letter_id)){
                    $detail_claim = "SELECT
                                        l.claim_number,
                                        g.approved_amount as amount_approved,
                                        g.excess_amount,
                                        g.cover_amount as real_cover_amount,
                                        g.charge,
                                        b.name as benefit,
                                        b.description benefit_description
                                    FROM
                                        final_gl g
                                    LEFT JOIN benefit_benefit b on
                                        g.benefit_id = b.id
                                    LEFT JOIN guarantee_letter l on
                                        g.letter_id = l.id
                                    WHERE
                                        g.letter_id = '" . $res->letter_id . "'";
                    $meta_detail = collect(DB::select(DB::raw($detail_claim)));
                    $detail = collect($meta_detail)->map(function($d) {
                        return $d;
                    });
                }
                // get status
                $sql_status = Notifikasi::where('id_admission', $res->id)->where('id_user',$this->me->id)->orderBy('created_at', 'ASC')->get();
                $status = collect($sql_status)->map(function($r){
                    try {
                        $status = [
                            'status'    => $r['label'],
                            'date'      => Carbon::parse($r['created_at'])->format('d-m-Y H:i')??'',
                        ];
                        return $status;
                    } catch (\Exception $e) {
                        return [];
                    }
                })->toArray();
                if($res->state=='cancel'){
                    $claim_status = Library::mapStatus($res->state);
                }else{
                    $claim_status = Library::mapStatus($res->claim_status);
                }
                $res->claim_status = ($claim_status == '' || is_null($claim_status))?'Requested':$claim_status;
                if ($res->state == 'need_confirmation') {
                    $res->claim_status = 'Need confirmation';
                }
                
                $res->detail= $detail;
                $res->attachment= $a;
                $res->status= $status;
                try{
                    $res->admission_date = Carbon::createFromFormat('Y-m-d',$res->admission_date)->format('d-m-Y');
                    $res->service_date = Carbon::createFromFormat('Y-m-d',$res->service_date)->format('d-m-Y')??"";
                }catch(Exception $e){
                    $res->admission_date = $res->admission_date??"";
                    $res->service_date = $res->service_date??"";
                }
                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Reimbursement', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }

    }
    public function detail(Request $request){
        $base_url = config('services.medikaplaza.attach');
        if (is_null($this->me->member_no) || is_null($this->me->card_number) || is_null($this->me->relationship)) {
            return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
        }
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['id_admission' => 'required'],  []);
        try {
            // $conn = DB::connection('stag_medika');
            $sql = "";
            $where = "";
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $this->me->card_number . "'";
            $member = DB::select(DB::raw($cek));
            // if ($member[0]->relationship == 'E') {
            //     $where .= "AND adm.member_number = '" . $this->me->member_no . "'";
            // } else {
            //     $where .= "AND adm.card_number = '" . $this->me->card_number . "'";
            // }
            $sql = "SELECT
                        adm.id,
                        adm.name,
                        gl.claim_number,
                        adm.charge,
                        b.NAME as benefit,
                        adm.admission_date,
                        adm.claim_source,
                        gl.payment_date as service_date,
                        gl.claim_status,
                        adm.notes
                    FROM
                        mobile_apps_admission adm
                    LEFT JOIN res_partner rp on
                        adm.card_number = rp.card_number
                    LEFT JOIN guarantee_letter gl on 
                        gl.id = adm.letter_id
                    LEFT JOIN benefit_master b on
                        gl.benefit_master_id = b.id
                    WHERE 1=1
                        $where
                        AND adm.id = '" . $request->query('id_admission') . "'
                        AND adm.claim_source = 'reimbursement'
                    ORDER BY adm.admission_date DESC";
            $data = DB::select(DB::raw($sql));
            if (!count($data)) {
                Helper::Log('error', 'Reimbursment Not Found', []);
                return Helper::generalResponse(true, 'Reimbursment Not Found', []);
            }
            $result = collect($data)->map(function($res)  use($base_url){
                $a = [];
                $sql_attach = "SELECT
                                    mobile_apps_admission_id,
                                    ir_attachment_id
                               FROM ir_attachment_mobile_apps_admission_rel
                               WHERE mobile_apps_admission_id = $res->id";
                $meta = collect(DB::select(DB::raw($sql_attach)));
                foreach ($meta as $j) {
                    $url_image = sprintf('%s%s', $base_url, $j->ir_attachment_id);
                    $a[] = $url_image;
                }
                $sql_status = Notifikasi::where('id_admission', $res->id)->orderBy('created_at', 'ASC')->get();
                $status = collect($sql_status)->map(function($r){
                    try {
                        $status = [
                            'status'    => $r['label'],
                            'date'      => Carbon::parse($r['created_at'])->format('Y-m-d H:i')??'',
                        ];
                        return $status;
                    } catch (\Exception $e) {
                        return [];
                    }
                })->toArray();
                $res->claim_status = (Library::claimStatus($res->claim_status) == '')?'Requested':Library::claimStatus($res->claim_status);
                $res->service_date = $res->service_date ?? "";
                $res->attachment= $a;
                $res->status= $status;
                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
		    report($e);
            Helper::Log('error', 'Error Get Reimbursement', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }

    }
}
