<?php

namespace App\Http\Controllers\Provider;

use Helper;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Services\Validator\ValidatorManagerInterface;

class ProviderController extends Controller
{
    public $me;
    public function __construct()
    {
        $this->me          = auth()->user();
    }
    public function getNearbyProvider(Request $request)
    {
        $limit = 100;
        $page = 1;
        if ($request->has('limit')) {
            $limit = $request->limit;
        } 
        if ($request->has('page')) {
            $page = $request->page;
        } 
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['lat' => 'required', 'long' => 'required'],  []);
            for ($radius = 100; $radius <= 5000; $radius += 100) {
                $data = self::list($request,$request->query('lat'), $request->query('long'), $radius);
                
                if (!is_null($data))
                    break;
            }
            foreach ($data as $val) {
                $val->distance = number_format($val->jarak,2,'.','');
                $val->hospital_portal = (bool)$val->hospital_portal;
                unset($val->jarak);
            }
            $result = Helper::arrayPaginator($data,$request, $limit);
            return Helper::generalResponse(true, 'Success', $result);
        }catch(\Exception $e){
            Helper::Log('error','Get Provider Nearby Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function list($request, $lat, $lon, $rad){
       
        try {
            $sql = "";
            $name = '';
            $id = '';
            if (!is_null($request->query('id'))) {
		$q = (int) $request->query('id');
                $id = "and p.id = ".$q."";
            }
            if (!is_null($request->query('name'))) {
		$q = strtolower($request->query('name'));
                $name = "and (lower(display_name) ILIKE '%".$q."%' or lower(street) ILIKE '%".$q."%')";
            }
            $sql = "SELECT
			p.id,
                        display_name,
                        name,
                        active,
                        type,
                        street,
                        6371 * acos(cos(radians(" . $lat . ")) * cos(radians(partner_latitude)) 
                        * cos(radians(partner_longitude) - radians(" . $lon . ")) 
                        + sin(radians(" . $lat . ")) 
                        * sin(radians(partner_latitude))) AS jarak,
                        partner_latitude,
                        partner_longitude,
                        is_company,
                        partner_share,
                        commercial_company_name,
                        provider,
                        is_published,
                        map_link,
                        provider_category,
                        provider_sector,
                        street,
                        street2,
                        city,
                        zip,
                        hospital_portal
                    FROM
                        res_partner p
		            LEFT JOIN res_partner_res_partner_category_rel pc ON p.id = pc.partner_id
                    WHERE
                        parent_id is null
                        and provider = true
                        and partner_latitude IS NOT NULL
                        and partner_longitude IS NOT NULL
                        and active = true
                        and provider_type = 'provider'
                        and ( pc.category_id is null OR pc.category_id != 18 )
                        $name
			$id
                    ORDER BY jarak";
            $data = DB::select(DB::raw($sql));
            return $data;
        } catch (\Exception $e) {
            Helper::Log('error','Error Get Provider List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
