<?php

namespace App\Http\Controllers\Promotion;

use Helper;
use Exception;
use Carbon\Carbon;
use App\Services\Firebase;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\map_status_notif;
use Illuminate\Support\Facades\Http;
use App\Services\Validator\ValidatorManagerInterface;

class PromotionController extends Controller
{
    public $me;
    public $firebase;
    public $conn;
    public $base_url;

    public function __construct()
    {
        $this->me          = auth()->user();
        $this->firebase    = new Firebase();
        $this->conn        = DB::connection('prod_promotion');
        $this->base_url     = config('services.medikaplaza.promotion');
    }
    public function getVoucher(){
        $isNewUser = $this->me->created_at->diff(Carbon::now())->days <= 30;

        try{
            $sql = "SELECT
                        ps.id as promotion_id,
                        ps.name as promotion_name,
                        ps.description,
                        ps.start_date,
                        ps.end_date,
                        ps.number_of_quota,
                        ps.count_claim,
                        ps.type_diskon,
                        ps.total_diskon,
                        ps.term_condition,
                        ps.min_transaction,
                        ps.max_diskon,
                        COALESCE(ps.new_user, false) for_new_user
                    FROM 
                        promotion_setup ps
                    LEFT JOIN merchant_setup_promotion_setup_rel msp ON
                        msp.promotion_setup_id = ps.id
                    LEFT JOIN merchant_setup ms ON
                        ms.id = msp.merchant_setup_id
                    WHERE 1=1
                        AND ps.active = true
                        AND DATE(ps.end_date) > NOW()
                        AND ps.id NOT IN (
                            SELECT
                                mv.promotion_ids
                            FROM
                                merchant_voucher mv
                            WHERE
                                mv.user_mobile_id = ".$this->me->id."
                        )
                    GROUP BY ps.id";
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->map(function($res) use ($isNewUser) {
                $res->start_date= Carbon::parse($res->start_date)->isoFormat('MMM DD YYYY')??"-";
                $res->end_date= Carbon::parse($res->end_date)->isoFormat('MMM DD YYYY')??"-";
                $res->description= strip_tags($res->description);

                $url = sprintf('%s/web/image?model=promotion.setup&id=%s&field=image_upload&width=300&height=300', $this->base_url, $res->promotion_id);
                $res->banner = $url;

                $res->is_new_user = $isNewUser;
                $res->term_condition = $this->cleanerHtml($res->term_condition);

                return $res;
            })->where('number_of_quota','>','count_claim')->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get voucher Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get voucher Failed", [], 500);
        }  
    }
    public function getPromotionDetail(Request $request){
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['id' => 'required'],  []);

        $isNewUser = $this->me->created_at->diff(Carbon::now())->days <= 30;

        try{
            $sql = "SELECT
                        ps.id as promotion_id,
                        ps.name as promotion_name,
                        ps.description,
                        ps.start_date,
                        ps.end_date,
                        ps.number_of_quota,
                        ps.count_claim,
                        ps.type_diskon,
                        ps.total_diskon,
                        ps.term_condition,
                        ps.min_transaction,
                        ps.max_diskon,
                        COALESCE(ps.new_user, false) for_new_user
                    FROM 
                        promotion_setup ps
                    WHERE 1=1
                        AND ps.active = true
                        AND DATE(ps.end_date) > NOW()
                        AND ps.id = '" . $request->query('id') . "'";
            $data = $this->conn->select(DB::raw($sql));
            $is_valid = count($data) ? 'valid' : 'notvalid';
            if ($is_valid == 'notvalid') {
                Helper::Log('error', 'Error Get Detail promotion notvalid', []);
                return Helper::generalResponse(true, 'Error Get Claim Detail promotion notvalid', []);
            }
            $result = collect($data)->map(function($res) use ($isNewUser) {
                $res->start_date= Carbon::parse($res->start_date)->isoFormat('MMM DD YYYY')??"-";
                $res->end_date= Carbon::parse($res->end_date)->isoFormat('MMM DD YYYY')??"-";
                $res->description= strip_tags($res->description);

                $url = sprintf('%s/web/image?model=promotion.setup&id=%s&field=image_upload&width=300&height=300', $this->base_url, $res->promotion_id);
                $res->banner = $url;

                $res->is_new_user = $isNewUser;
                $res->term_condition = $this->cleanerHtml($res->term_condition);

                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get Promtion Detail Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get Promtion Detail Failed", [], 500);
        }  
    }
    public function myVoucher(){
        $isNewUser = $this->me->created_at->diff(Carbon::now())->days <= 30;

        try{
            $sql = "SELECT
                        ms.name merchant_name,
                        ps.name as promotion_name,
                        mc.claim_code,
                        ms.pin_merchant,
                        ps.description,
                        mv.voucher_code,
                        mv.start_date,
                        mv.end_date,
                        mv.claim_status,
                        mv.redeem_status,
                        mv.redeem_date,
                        ps.min_transaction,
                        ps.term_condition,
                        ps.max_diskon,
                        COALESCE(ps.new_user, false) for_new_user,
                        ps.type_diskon,
                        ps.total_diskon as diskon,
                        mv.promotion_ids as promotion_id,
                        mc.claim_date,
                        mc.total_transaksi,
                        mc.total_diskon,
                        mc.grand_total,
                        mc.claim_status as status
                        FROM
                            merchant_voucher mv
                        LEFT JOIN merchant_monitoring_claim mc ON
                            mv.id = mc.voucher_id
                        LEFT JOIN promotion_setup ps ON
                            mv.promotion_ids = ps.id
                        LEFT JOIN merchant_setup ms ON
                            mc.merchant_id = ms.id
                    WHERE 1=1
                        AND user_mobile_id IS NOT NULL
                        AND user_mobile_id = ".$this->me->id."";
                        // mmc.userid_mobile = 1";
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data)->map(function($res) use ($isNewUser) {
                $end_date = Carbon::parse($res->end_date)->isPast();
                $res->status = (!$end_date)?$res->status: "Expired";
                $res->start_date= Carbon::parse($res->start_date)->isoFormat('MMM DD YYYY')??"-";
                $res->end_date= Carbon::parse($res->end_date)->isoFormat('MMM DD YYYY')??"-";
                $res->description= strip_tags($res->description);

                $url = sprintf('%s/web/image?model=promotion.setup&id=%s&field=image_upload&width=300&height=300', $this->base_url, $res->promotion_id);
                $res->banner = $url;

                $res->is_new_user = $isNewUser;
                $res->term_condition = $this->cleanerHtml($res->term_condition);

                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get my voucher Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get my voucher Failed", [], 500);
        }  
    }
    public function paymentMethod(Request $request){
        $rule = [
            'promotion_id'  => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        $where = "";
        if (!is_null($request->query('promotion_id'))) {
            $where .= "ps.id = '" . $request->query('promotion_id') . "'";
        }
        try{
            $sql = "SELECT
                        ps.name,
                        pm.id as payment_method_id,
                        pm.name as payment_method
                    FROM
                        promotion_setup ps
                    LEFT JOIN merchant_payment_method_promotion_setup_rel mpm ON 
                        mpm.promotion_setup_id = ps.id
                    LEFT JOIN merchant_payment_method  pm ON 
                        pm.id = mpm.merchant_payment_method_id
                    WHERE 
                        $where";
            $data = $this->conn->select(DB::raw($sql));
            $result = collect($data);
            return Helper::generalResponse(true, 'Success', $result);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Get payment method Failed", $e->getMessage());
            return Helper::generalResponse(false, "Get payment method Failed", [], 500);
        }  
    }
    public function redeemVoucher(Request $request){
        Helper::Log("info", "Redeem Voucher Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $url = config('services.medikaplaza.claim');
        $rule = [
            'promotion_id'       => 'required',
            'voucher_code'       => 'required',
            'merchant_pin'       => 'required',
            'total_transaksi'    => 'required',
            'payment_method_id'   => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $promotion_id       = $request->promotion_id;
            $voucher_code       = $request->voucher_code;
            $merchant_pin       = $request->merchant_pin;
            $total_transaksi    = $request->total_transaksi;
            $user_id            = $this->me->id;
            $user_mail          = $this->me->email;
            $is_member          = ($this->me->member_type==1)?"true":"false";
            $no_member          = $this->me->member_no;
            $card_number        = $this->me->card_number;
            $payment_method_id  = $request->payment_method_id;

            $payload = sprintf('{
                "params": { 
                    "promotion_id": "%s",
                    "voucher_code": "%s",
                    "merchant_pin": "%s",
                    "total_transaksi": "%s",
                    "user_id": "%s",
                    "user_mail": "%s",
                    "is_member": "%s",
                    "no_member": "%s",
                    "card_number": "%s",
                    "payment_method_id": "%s"
                    }
                }', $promotion_id, $voucher_code, $merchant_pin, $total_transaksi, $user_id, $user_mail, $is_member, $no_member, $card_number, $payment_method_id );
              
            Helper::Log("info", "Redeem Voucher Payload", [$payload]);
            
            $response = Http::withBody(
                $payload, 'application/json'
                )->post($url);
            $res = json_decode($response);
            if (!isset($res) || is_null($res)) {
                throw new \Exception("Redeem Voucher Failed");
            }
        if ($res->status != 200) {
                return Helper::generalResponse(false, $res->message, [], 400);
        }

            // //**Push notification */
            Helper::Log("info", "Success", $res->message);
            return Helper::generalResponse(true, 'Success', $res->message);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Redeem voucher Failed", $e->getMessage());
            return Helper::generalResponse(false, "Redeem voucher Failed", [], 500);
        }  
    }
    public function claimVoucher(Request $request){
        Helper::Log("info", "Claim Voucher Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $url = config('services.medikaplaza.redeem');
        $rule = [
            'promotion_id'  => 'required',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
        try{
            $promotion_id       = $request->promotion_id;
            $user_id            = $this->me->id;
            $user_mail          = $this->me->email;

            $payload = sprintf('{
                "params": { 
                    "promotion_id": "%s",
                    "user_id": "%s",
                    "user_mail": "%s"
                    }
                }', $promotion_id, $user_id, $user_mail );
              
            Helper::Log("info", "Claim Voucher Payload", [$payload]);
            
            $response = Http::withBody(
                $payload, 'application/json'
                )->post($url);
            $res = json_decode($response);
            if (!isset($res) || is_null($res)) {
                throw new \Exception("Claim Voucher Failed");
            }
            if ($res->status != 200) {
                    return Helper::generalResponse(false, $res->message, [], 400);
            }

            // //**Push notification */
            self::push_notification($promotion_id);
            Helper::Log("info", "Success", $res->message);
            return Helper::generalResponse(true, 'Success', $res->message);
        } catch(Exception $e){
            report($e);
            Helper::Log("error","Claim voucher Failed", $e->getMessage());
            return Helper::generalResponse(false, "Claim voucher Failed", [], 500);
        } 
    }
    public function push_notification($promotion_id){
        try{
            $user = $this->firebase->getUserToken();
            $getStatus = map_status_notif::where("type","voucher")->where("status","claim")->first();
            $promotion_id = $promotion_id ?? null;
            $label  = $getStatus['label']??"Your voucher has been successfully claimed";
            $date_now = Carbon::now()->isoFormat('D-MM-YYYY');
            $text   = $getStatus['message']??"Please open this to redeem your voucher when you make a transaction at the merchant";
        
            $notif = [
                        'user'          => $user,
                        'id_promotion'  => $promotion_id,
                        'label'         => $label,
                        'type'          => "voucher",
                        'text'          => $text,
                    ];
            //**notification */
            $this->firebase->pushNotif($notif);
        }catch(Exception $e){
            report($e);
            Helper::Log("error","Failed push notification", $e->getMessage());
        }
    }

    private function cleanerHtml($text)
    {
        // $pattern = "/<p[^>]*><\\/p[^>]*>/"; // only <p></p> removed
        $pattern = "/<[^\/>]*>([\s]?)*<\/[^>]*>/";  // use this pattern to remove any empty tag

        return preg_replace($pattern, '', $text);
    }
}
