<?php

namespace App\Http\Controllers\Payment;

use Helper;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Repository\FaspayManager;
use App\Models\Trx_history_telmed;
use App\Http\Controllers\Controller;
use App\Models\Payment_telmed;
use App\Repository\TelemedicineManager;
use App\Services\Validator\ValidatorManagerInterface;
use Exception;
use Library;

class PaymentController extends Controller
{
    public $me;
    public $REPO;
    public $TELMED;

    public function __construct()
    {
        $this->me          = auth()->user();
        $this->REPO        = new FaspayManager();
        $this->TELMED      = new TelemedicineManager();
    }
    public function postData(Request $request){
        $rule = [
            'trx_no'                => 'required',
            'pay_channel_code'      => 'required|integer',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
       
        try {
            $inv_number = strtoupper("INV-".date('ymd')."-".Helper::codeGenerator(10));
            $now            = Carbon::now();
            $expired_date   = Carbon::now()->addMinutes(15);
            $expired_date_string    = $expired_date->toDateTimeString();

            $trx = Trx_history_telmed::where('trx_no', $request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogFaspay('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
             //   check plan telmed
             if($request->pay_channel_code == 0){
                $plan_telmed = $this->TELMED->checkPlanTelmed($trx->card_number);
                if($plan_telmed->isEmpty()){
                    Helper::Log('error', 'Plan telemedicine not found', []);
                    return Helper::generalResponse(false, 'Plan telemedicine not found', [], 400);
                }
                $trx->trx_status        = Trx_history_telmed::STS_WAIT_CONFIRMATION;
                $trx->trx_status_code   = Trx_history_telmed::STS_CODE_WAIT_CONFIRMATION;
                $trx->save();
                // Insert log
                $post_data = [
                    'trx_no'                => $trx->trx_no,
                    'invoice_no'            => $inv_number,
                    'pay_method'            => $request->pay_channel_code??"-",
                    'pay_date'              => $now,
                    'pay_exp_date'          => $expired_date_string,
                    'pay_amount'            => $trx->trx_amount,
                    'pay_status'            => Payment_telmed::STS_CODE_PAID,
                    'pay_message'           => Payment_telmed::STS_PAID,
                    'post_data_response'    => "",
                ];
                $payment = Payment_telmed::Create($post_data);
                // Send email
                $to = (!is_null($trx->email))?$trx->email:"";
                if(!is_null($to)){
                    $appointment_date = Carbon::parse($trx->date_consul)->isoFormat('D MMMM YYYY')." (".Carbon::parse($trx->time_consul)->isoFormat('k:mm')." WIB)"??"-";
                    $data = [
                        'type'              => "appointment",
                        'appointment'       => "Konsultasi Dokter",
                        'subject'           => "Appointment Has Been Created",
                        'cust_name'         => $trx->cust_name,
                        'invoice_no'        => $inv_number,
                        'trx_amount'        => $trx->trx_amount,
                        'pay_method'        => Library::getPaymentChannel($request->pay_channel_code),
                        'appointment_date'  => $appointment_date,
                        'cust_number'       => "-",
                    ];
                    $this->TELMED->sendEmail($to, $data, $data['type']);
                }
                return Helper::generalResponse(true, 'Success', $payment);
            }else{
                $payment = $this->REPO->postData($trx, $request);
                if(isset($payment) && !is_null($payment) && $payment->response_code == '00'){
                    $trx->trx_status        = Trx_history_telmed::STS_WAIT_PAYMENT;
                    $trx->trx_status_code   = Trx_history_telmed::STS_CODE_WAIT_PAYMENT;

                    // set status to auto paid
                    // if (true) {
                    //     $trx->trx_status_code   = Trx_history_telmed::STS_CODE_WAIT_CONFIRMATION;
                    //     $trx->trx_status        = Trx_history_telmed::STS_WAIT_CONFIRMATION;            
                    // }

                    $trx->save();
                    // Send email
                    $to = (!is_null($trx->email))?$trx->email:"";
                    if(!is_null($to)){
                        $appointment_date = Carbon::parse($trx->date_consul)->isoFormat('D MMMM YYYY')." (".Carbon::parse($trx->time_consul)->isoFormat('k:mm')." WIB)"??"-";
                        $data = [
                            'type'              => "appointment",
                            'appointment'       => "Konsultasi Dokter",
                            'subject'           => "Appointment Has Been Created",
                            'cust_name'         => $trx->cust_name,
                            'invoice_no'        => $payment->invoice_no??"-",
                            'trx_amount'        => $trx->trx_amount,
                            'pay_method'        => Library::getPaymentChannel($request->pay_channel_code),
                            'appointment_date'  => $appointment_date,
                            'cust_number'       => $payment->trx_id??"-",
                        ];
                        $this->TELMED->sendEmail($to, $data, $data['type']);
                    }
                }else{
                    throw new \Exception("Post data to faspay Failed");
                }
                return Helper::generalResponse(true, 'Success', $payment);
            }
        } catch (\Exception $e) {
            report($e);
            Helper::LogFaspay('error','Error Post Data to Faspay', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function postDataRetail(Request $request){
        $rule = [
            'trx_no'                => 'required',
            'pay_channel_code'      => 'required|integer',
        ];
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
       
        try {
            $now            = Carbon::now();
            $trx = Trx_history_telmed::where('trx_no', $request->trx_no)->first();
            if(is_null($trx)){
                Helper::LogFaspay('error', 'Transaction tidak ditemukan', []);
                return Helper::generalResponse(false, 'Transaction tidak ditemukan', [], 400);
            }
            $payment = $this->REPO->postDataRetail($trx, $request);
            if(isset($payment) && !is_null($payment) && $payment->response_code == '00'){
                $trx->status_redeem     = Trx_history_telmed::STS_TEBUS_PROCESS;
                $trx->trx_no_med        = $request->trx_no."-MED";
                $trx->time_redeem       = $now;
                $trx->save();
            }else{
                throw new \Exception("Post data to faspay Failed");
            }
            return Helper::generalResponse(true, 'Success', $payment);
        } catch (\Exception $e) {
            report($e);
            Helper::LogFaspay('error','Error Post Data to Faspay', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function notify(Request $request){
        try {
            $payment = $this->REPO->paymentNotification($request);
            return $payment;
        } catch (\Exception $e) {
            report($e);
            Helper::LogFaspay('error','Error Payment Notification Faspay', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function getPaymentChannelList(){
        try{
            $data = $this->REPO->getPaymentChannel();
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            report($e);
            Helper::LogFaspay('error','Error get payment channel list', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function getInstruction(Request $request){
        try{
            $rule = [
                'code'    => 'required',
            ];
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

            $data = $this->REPO->getInstruction($request->code);
            return Helper::generalResponse(true, 'Success', $data);
        }catch(\Exception $e){
            report($e);
            Helper::LogFaspay('error','Error get instruction list', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
