<?php

namespace App\Http\Controllers\Notifikasi;

use Helper;
use Library;
use Exception;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Notifikasi;
use App\Services\Firebase;
use Illuminate\Http\Request;
use App\Models\Mobile_status;
use App\Models\map_status_notif;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Services\Validator\ValidatorManager;

class NotifikasiController extends Controller
{
    public $me;
    public $firebase;
    public function __construct()
    {
        $this->me          = auth()->user();
        $this->firebase    = new Firebase();
    }
    public function count()
    {
        try {
            $notif = Notifikasi::where('status', 0)->where('id_user', $this->me->id)->get()->count();

            return Helper::generalResponse(true, 'Success', $notif);
        } catch (\Exception $e) {
            Helper::Log("error",'Error Get count Notifikasi', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }

    public function list(Request $request)
    {
        try {
            $notif = Notifikasi::select([
                'id',
                'id_user',
                'id_admission',
                'label',
                'type',
                'text',
                'status',
                'created_at',
            ])
            ->where('id_user', $this->me->id)
            ->orderBy('created_at', 'DESC')
            ->limit(20)->get();
    
            $notif->values();

            return Helper::generalResponse(true, 'Success', $notif);
        } catch (\Exception $e) {
            Helper::Log("error",'Error Get Notifikasi', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }

    public function status(Request $request){
        try{
            $data = Notifikasi::where("id", $request->id)->update(["status" => 1]);
            return Helper::generalResponse(true, 'Success', $data);
        } catch(\Exception $e){
            Helper::Log("error","Update Status Failed", $e->getMessage());
            return Helper::generalResponse(false, "Gagal update status.", [], 500);
        }
    }
    public function notifyStatus(Request $request){
        // $conn = DB::connection('stag_medika');
        Helper::Log("info", "Notifikasi Request", ['request'=>$request->all(),'path'=>$request->url()]);
        try {
            $rule  = [
                'id_admission'    => 'required',
                'status'          => 'required',
            ];
            app(ValidatorManager::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
            // Cek admission
            $sql = "";
            $sql = "SELECT
                        adm.id,
                        adm.claim_source,
                        adm.card_number,
                        adm.provider_id,
	                    rp.display_name 
                    FROM
                        mobile_apps_admission adm
                    LEFT JOIN res_partner rp ON 
	                    rp.id = adm.provider_id
                    WHERE 1=1
                        AND adm.id = $request->id_admission";
            $admission = DB::select(DB::raw($sql));
            if (is_null($admission) || empty($admission)) {
                Helper::Log('error', 'Admission tidak ditemukan', []);
                return Helper::generalResponse(false, 'Admission tidak ditemukan.', [], 400);
            }
            $claim_source = $admission[0]->claim_source ??'portal';
            $admission_date = Carbon::now()->isoFormat('D-MM-YYYY');
            $provider = $admission[0]->display_name ??"";
            $status = strtolower($request->status);
            if($claim_source == 'portal'){
                try{
                    $getStatus = map_status_notif::where("type","portal")->where("status",$status)->first();
                    $label  = $getStatus['label']??$status;
                    $text   = sprintf($getStatus['message']??$status, $provider, $admission_date);
                }catch(Exception $e){
                    report($e);
                }
            }
            // Reimbursement
            if($claim_source == 'reimbursement'){
                try{
                    $getStatus = map_status_notif::where("type","reimbursement")->where("status",$status)->first();
                    $label  = $getStatus['label']??$status;
                    $text   = sprintf($getStatus['message']??$status, $provider, $admission_date);
                }catch(Exception $e){
                    report($e);
                }
            }
            // //**notification */
            $card_number = $admission[0]->card_number ??'';
            $id_user = User::select('id')->where('card_number', $card_number)->first();
            if(!$id_user){
                Helper::Log("warning", "Push Notifikasi gagal", ["message" => "User tidak ditemukan!"]);
                return Helper::generalResponse(false, "Push Notifikasi gagal, user tidak ditemukan!", [], 401);
            }
            
            $user = $this->firebase->getUserToken($id_user->id);
            $notif = [
                'id_user'       => $id_user->id,
                'user'          => $user,
                'id_admission'  => $request->id_admission ?? '',
                'label'         => $label,
                'type'          => $claim_source,
                'text'          => $text,
            ];
            // //**Push notification */
            if(!!$notif){
                $this->firebase->pushNotif($notif);
            }
            return Helper::generalResponse(true, 'Success', []);
        } catch (\Exception $e) {
            Helper::Log('error', 'Set Notif Failed', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage());
        }
    }
    public function test_firebase(Request $request){
        try {
            $rule  = [
                'label'         => 'required',
                'text'          => 'required',
                'email'         => 'required',
            ];
            app(ValidatorManager::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);
            $user = User::select('user_token.token_device')
                    ->where('email', $request->email)
                    ->leftJoin('user_token','user_token.id_user','=','app_user.id')
                    ->get();
            $result = $this->firebase->fcm($request->label, $request->text, $user);
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::Log('error', 'Test Notif Failed', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage());
        }
    }
}
